/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common;

import com.mojang.brigadier.CommandDispatcher;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.command.PowerCommand;
import io.github.apace100.apoli.command.ResourceCommand;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.component.IPowerDataCache;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiEntityAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiomeCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredDamageCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredFluidCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.registry.ApoliBuiltinRegistries;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.apoli.common.ApoliCommon;
import io.github.edwinmindcraft.apoli.common.component.PowerContainer;
import io.github.edwinmindcraft.apoli.common.component.PowerDataCache;
import io.github.edwinmindcraft.apoli.common.data.PowerLoader;
import io.github.edwinmindcraft.apoli.common.network.S2CSynchronizePowerContainer;
import io.github.edwinmindcraft.apoli.common.power.KeepInventoryPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.KeepInventoryConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.calio.api.event.CalioDynamicRegistryEvent;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.WritableRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="apoli")
public class ApoliEventHandler {
    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)object;
            event.addCapability(IPowerContainer.KEY, (ICapabilityProvider)new PowerContainer(living));
            event.addCapability(IPowerDataCache.KEY, (ICapabilityProvider)new PowerDataCache());
        }
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer spe = (ServerPlayer)player;
            S2CSynchronizePowerContainer packet = S2CSynchronizePowerContainer.forEntity((Entity)spe);
            if (packet == null) {
                Apoli.LOGGER.error("Couldn't create synchronization packet for player {}", (Object)spe.m_6302_());
            }
            ApoliCommon.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
        }
    }

    @SubscribeEvent
    public static void calioRegistries(CalioDynamicRegistryEvent.Initialize event) {
        event.getRegistryManager().addForge(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, ApoliBuiltinRegistries.CONFIGURED_POWERS, ConfiguredPower.CODEC);
        event.getRegistryManager().addForge(ApoliDynamicRegistries.CONFIGURED_BIENTITY_ACTION_KEY, ApoliBuiltinRegistries.CONFIGURED_BIENTITY_ACTIONS, ConfiguredBiEntityAction.CODEC);
        event.getRegistryManager().addForge(ApoliDynamicRegistries.CONFIGURED_BLOCK_ACTION_KEY, ApoliBuiltinRegistries.CONFIGURED_BLOCK_ACTIONS, ConfiguredBlockAction.CODEC);
        event.getRegistryManager().addForge(ApoliDynamicRegistries.CONFIGURED_ENTITY_ACTION_KEY, ApoliBuiltinRegistries.CONFIGURED_ENTITY_ACTIONS, ConfiguredEntityAction.CODEC);
        event.getRegistryManager().addForge(ApoliDynamicRegistries.CONFIGURED_ITEM_ACTION_KEY, ApoliBuiltinRegistries.CONFIGURED_ITEM_ACTIONS, ConfiguredItemAction.CODEC);
        event.getRegistryManager().addForge(ApoliDynamicRegistries.CONFIGURED_BIENTITY_CONDITION_KEY, ApoliBuiltinRegistries.CONFIGURED_BIENTITY_CONDITIONS, ConfiguredBiEntityCondition.CODEC);
        event.getRegistryManager().addForge(ApoliDynamicRegistries.CONFIGURED_BIOME_CONDITION_KEY, ApoliBuiltinRegistries.CONFIGURED_BIOME_CONDITIONS, ConfiguredBiomeCondition.CODEC);
        event.getRegistryManager().addForge(ApoliDynamicRegistries.CONFIGURED_BLOCK_CONDITION_KEY, ApoliBuiltinRegistries.CONFIGURED_BLOCK_CONDITIONS, ConfiguredBlockCondition.CODEC);
        event.getRegistryManager().addForge(ApoliDynamicRegistries.CONFIGURED_DAMAGE_CONDITION_KEY, ApoliBuiltinRegistries.CONFIGURED_DAMAGE_CONDITIONS, ConfiguredDamageCondition.CODEC);
        event.getRegistryManager().addForge(ApoliDynamicRegistries.CONFIGURED_ENTITY_CONDITION_KEY, ApoliBuiltinRegistries.CONFIGURED_ENTITY_CONDITIONS, ConfiguredEntityCondition.CODEC);
        event.getRegistryManager().addForge(ApoliDynamicRegistries.CONFIGURED_FLUID_CONDITION_KEY, ApoliBuiltinRegistries.CONFIGURED_FLUID_CONDITIONS, ConfiguredFluidCondition.CODEC);
        event.getRegistryManager().addForge(ApoliDynamicRegistries.CONFIGURED_ITEM_CONDITION_KEY, ApoliBuiltinRegistries.CONFIGURED_ITEM_CONDITIONS, ConfiguredItemCondition.CODEC);
        event.getRegistryManager().addReload(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, "powers", PowerLoader.INSTANCE);
        event.getRegistryManager().addValidation(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, PowerLoader.INSTANCE, ApoliBuiltinRegistries.CONFIGURED_POWER_CLASS, new ResourceKey[0]);
    }

    @SubscribeEvent
    public static void calioLoadComplete(CalioDynamicRegistryEvent.LoadComplete event) {
        WritableRegistry<ConfiguredPower<?, ?>> configuredPowers = event.getRegistryManager().get(ApoliDynamicRegistries.CONFIGURED_POWER_KEY);
        for (ConfiguredPower configuredPower : configuredPowers) {
            List<String> warnings = configuredPower.getWarnings(event.getRegistryManager());
            List<String> errors = configuredPower.getErrors(event.getRegistryManager());
            if (errors.isEmpty() && warnings.isEmpty()) continue;
            Apoli.LOGGER.info("Status report for power: {}", (Object)configuredPower.getRegistryName());
            warnings.forEach(arg_0 -> ((Logger)Apoli.LOGGER).warn(arg_0));
            errors.forEach(arg_0 -> ((Logger)Apoli.LOGGER).error(arg_0));
        }
    }

    @SubscribeEvent
    public static void onDataSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                IPowerContainer.get((Entity)player).ifPresent(IPowerContainer::rebuildCache);
                IPowerContainer.sync((Entity)player);
            }
        }
    }

    @SubscribeEvent
    public static void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        IPowerContainer.get((Entity)event.getEntityLiving()).ifPresent(x -> x.getPowers().forEach(y -> y.onRemoved((Entity)event.getEntityLiving())));
    }

    @SubscribeEvent
    public static void livingTick(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().f_19853_.m_5776_()) {
            IPowerContainer.get((Entity)event.getEntityLiving()).ifPresent(IPowerContainer::serverTick);
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        LazyOptional<IPowerContainer> original = IPowerContainer.get((Entity)event.getOriginal());
        LazyOptional<IPowerContainer> player = IPowerContainer.get((Entity)event.getPlayer());
        if (original.isPresent() != player.isPresent()) {
            Apoli.LOGGER.info("Capability mismatch: original:{}, new:{}", (Object)original.isPresent(), (Object)player.isPresent());
        }
        player.ifPresent(p -> original.ifPresent(o -> p.readFromNbt(o.writeToNbt(new CompoundTag()))));
        original.ifPresent(x -> x.getPowers().forEach(y -> y.onRemoved((Entity)event.getOriginal())));
        if (!event.getEntityLiving().f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
            IPowerContainer.getPowers((Entity)event.getPlayer(), (KeepInventoryPower)((Object)ApoliPowers.KEEP_INVENTORY.get())).forEach(power -> ((KeepInventoryPower)((Object)((Object)power.getFactory()))).restoreItems((ConfiguredPower<KeepInventoryConfiguration, ?>)power, event.getPlayer()));
        }
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            IPowerContainer.sync((Entity)sp);
            if (!event.isEndConquered()) {
                IPowerContainer.get((Entity)sp).ifPresent(x -> x.getPowers().forEach(y -> y.onRespawn((Entity)sp)));
            }
        }
    }

    @SubscribeEvent
    public static void playerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            IPowerContainer.sync((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void trackNew(EntityJoinWorldEvent event) {
        if (event.getWorld().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            IPowerContainer.sync((Entity)le);
        }
    }

    @SubscribeEvent
    public static void trackEntity(PlayerEvent.StartTracking event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer se = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)player;
                IPowerContainer.sync((Entity)target, se);
            }
        }
    }

    @SubscribeEvent
    public static void initializeCommands(RegisterCommandsEvent event) {
        PowerCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ResourceCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

