/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.power.factory.power;

import com.mojang.serialization.Codec;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.IVariableIntPower;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.configuration.power.IVariableIntPowerConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public abstract class VariableIntPowerFactory<T extends IVariableIntPowerConfiguration>
extends PowerFactory<T>
implements IVariableIntPower<T> {
    protected VariableIntPowerFactory(Codec<T> codec) {
        super(codec);
    }

    protected VariableIntPowerFactory(Codec<T> codec, boolean allowConditions) {
        super(codec, allowConditions);
    }

    protected abstract int get(ConfiguredPower<T, ?> var1, @Nullable IPowerContainer var2);

    protected abstract void set(ConfiguredPower<T, ?> var1, @Nullable IPowerContainer var2, int var3);

    protected int get(ConfiguredPower<T, ?> configuration, Entity player) {
        return this.get(configuration, (IPowerContainer)IPowerContainer.get(player).resolve().orElse(null));
    }

    protected void set(ConfiguredPower<T, ?> configuration, Entity player, int value) {
        this.set(configuration, (IPowerContainer)IPowerContainer.get(player).resolve().orElse(null), value);
    }

    @Override
    public int assign(ConfiguredPower<T, ?> configuration, Entity player, int value) {
        value = Mth.m_14045_((int)value, (int)this.getMinimum(configuration, player), (int)this.getMaximum(configuration, player));
        this.set(configuration, player, value);
        return value;
    }

    @Override
    public int getValue(ConfiguredPower<T, ?> configuration, Entity player) {
        return this.get(configuration, player);
    }

    @Override
    public int getMaximum(ConfiguredPower<T, ?> configuration, Entity player) {
        return ((IVariableIntPowerConfiguration)configuration.getConfiguration()).max();
    }

    @Override
    public int getMinimum(ConfiguredPower<T, ?> configuration, Entity player) {
        return ((IVariableIntPowerConfiguration)configuration.getConfiguration()).min();
    }

    public static abstract class Simple<T extends IVariableIntPowerConfiguration>
    extends VariableIntPowerFactory<T> {
        protected Simple(Codec<T> codec) {
            super(codec);
        }

        protected Simple(Codec<T> codec, boolean allowConditions) {
            super(codec, allowConditions);
        }

        protected AtomicInteger getCurrentValue(ConfiguredPower<T, ?> configuration, IPowerContainer container) {
            return (AtomicInteger)configuration.getPowerData(container, () -> new AtomicInteger(((IVariableIntPowerConfiguration)configuration.getConfiguration()).initialValue()));
        }

        @Override
        protected int get(ConfiguredPower<T, ?> configuration, @Nullable IPowerContainer container) {
            if (container == null) {
                return ((IVariableIntPowerConfiguration)configuration.getConfiguration()).initialValue();
            }
            return this.getCurrentValue(configuration, container).get();
        }

        @Override
        protected void set(ConfiguredPower<T, ?> configuration, @Nullable IPowerContainer container, int value) {
            if (container == null) {
                return;
            }
            this.getCurrentValue(configuration, container).set(value);
        }

        @Override
        public void serialize(ConfiguredPower<T, ?> configuration, IPowerContainer container, CompoundTag tag) {
            tag.m_128405_("Value", this.get(configuration, container));
        }

        @Override
        public void deserialize(ConfiguredPower<T, ?> configuration, IPowerContainer container, CompoundTag tag) {
            this.set(configuration, container, tag.m_128451_("Value"));
        }
    }
}

