/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.power.factory.power;

import com.mojang.serialization.Codec;
import io.github.apace100.apoli.util.HudRender;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.ICooldownPower;
import io.github.edwinmindcraft.apoli.api.power.IHudRenderedPower;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.configuration.power.ICooldownPowerConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.mutable.MutableLong;

public abstract class CooldownPowerFactory<T extends ICooldownPowerConfiguration>
extends PowerFactory<T>
implements ICooldownPower<T>,
IHudRenderedPower<T> {
    protected CooldownPowerFactory(Codec<T> codec) {
        super(codec);
    }

    protected CooldownPowerFactory(Codec<T> codec, boolean allowConditions) {
        super(codec, allowConditions);
    }

    @Override
    public void use(ConfiguredPower<T, ?> configuration, Entity entity) {
        this.setLastUseTime(configuration, entity, entity.m_20193_().m_46467_());
        IPowerContainer.sync(entity);
    }

    @Override
    public void onGained(ConfiguredPower<T, ?> configuration, Entity entity) {
        this.setLastUseTime(configuration, entity, entity.m_20193_().m_46467_());
    }

    @Override
    public boolean canUse(ConfiguredPower<T, ?> configuration, Entity entity) {
        return this.getRemainingDuration(configuration, entity) <= 0L && configuration.isActive(entity);
    }

    @Override
    public HudRender getRenderSettings(ConfiguredPower<T, ?> configuration, Entity entity) {
        return ((ICooldownPowerConfiguration)configuration.getConfiguration()).hudRender();
    }

    @Override
    public float getFill(ConfiguredPower<T, ?> configuration, Entity entity) {
        return 1.0f - this.getProgress(configuration, entity);
    }

    @Override
    public boolean shouldRender(ConfiguredPower<T, ?> configuration, Entity entity) {
        return this.getRemainingDuration(configuration, entity) > 0L;
    }

    protected long getLastUseTime(ConfiguredPower<T, ?> configuration, Entity entity) {
        return this.getLastUseTime(configuration, (IPowerContainer)IPowerContainer.get(entity).resolve().orElse(null));
    }

    protected abstract long getLastUseTime(ConfiguredPower<T, ?> var1, @Nullable IPowerContainer var2);

    protected void setLastUseTime(ConfiguredPower<T, ?> configuration, Entity entity, long value) {
        this.setLastUseTime(configuration, (IPowerContainer)IPowerContainer.get(entity).resolve().orElse(null), value);
    }

    protected abstract void setLastUseTime(ConfiguredPower<T, ?> var1, @Nullable IPowerContainer var2, long var3);

    protected long getElapsedDuration(ConfiguredPower<T, ?> configuration, Entity entity) {
        return Math.max(entity.m_20193_().m_46467_() - this.getLastUseTime(configuration, entity), 0L);
    }

    protected long getRemainingDuration(ConfiguredPower<T, ?> configuration, Entity entity) {
        return Math.max(this.getLastUseTime(configuration, entity) + (long)((ICooldownPowerConfiguration)configuration.getConfiguration()).duration() - entity.m_20193_().m_46467_(), 0L);
    }

    @Override
    public int assign(ConfiguredPower<T, ?> configuration, Entity entity, int value) {
        value = Mth.m_14045_((int)value, (int)this.getMinimum(configuration, entity), (int)this.getMaximum(configuration, entity));
        this.setLastUseTime(configuration, entity, entity.m_20193_().m_46467_() - (long)this.getMaximum(configuration, entity) + (long)value);
        return value;
    }

    @Override
    public int getValue(ConfiguredPower<T, ?> configuration, Entity entity) {
        return Math.toIntExact(Mth.m_14053_((long)this.getRemainingDuration(configuration, entity), (long)this.getMinimum(configuration, entity), (long)this.getMaximum(configuration, entity)));
    }

    @Override
    public int getMaximum(ConfiguredPower<T, ?> configuration, Entity entity) {
        return ((ICooldownPowerConfiguration)configuration.getConfiguration()).duration();
    }

    @Override
    public int getMinimum(ConfiguredPower<T, ?> configuration, Entity entity) {
        return 0;
    }

    public static abstract class Simple<T extends ICooldownPowerConfiguration>
    extends CooldownPowerFactory<T> {
        protected Simple(Codec<T> codec) {
            super(codec);
        }

        protected Simple(Codec<T> codec, boolean allowConditions) {
            super(codec, allowConditions);
        }

        protected MutableLong getUseTime(ConfiguredPower<T, ?> configuration, IPowerContainer container) {
            return (MutableLong)configuration.getPowerData(container, () -> new MutableLong(0L));
        }

        @Override
        protected long getLastUseTime(ConfiguredPower<T, ?> configuration, @Nullable IPowerContainer container) {
            if (container == null) {
                return 0L;
            }
            return this.getUseTime(configuration, container).getValue();
        }

        @Override
        protected void setLastUseTime(ConfiguredPower<T, ?> configuration, @Nullable IPowerContainer container, long value) {
            if (container == null) {
                return;
            }
            this.getUseTime(configuration, container).setValue(value);
        }

        @Override
        public void serialize(ConfiguredPower<T, ?> configuration, IPowerContainer container, CompoundTag tag) {
            tag.m_128356_("LastUseTime", this.getLastUseTime(configuration, container));
        }

        @Override
        public void deserialize(ConfiguredPower<T, ?> configuration, IPowerContainer container, CompoundTag tag) {
            this.setLastUseTime(configuration, container, tag.m_128454_("LastUseTime"));
        }
    }
}

