/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.power.factory;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.IFactory;
import io.github.edwinmindcraft.apoli.api.power.PowerData;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public abstract class PowerFactory<T extends IDynamicFeatureConfiguration>
extends ForgeRegistryEntry<PowerFactory<?>> {
    public static final Codec<PowerFactory<?>> CODEC = ApoliRegistries.codec(ApoliRegistries.POWER_FACTORY);
    private static final Map<String, ResourceLocation> ALIASES = (Map)Util.m_137537_(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(PowerFactory.class.getResourceAsStream("/data/apoli/power_class_registry.json")));){
            Gson gson = new GsonBuilder().create();
            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            for (String s : jsonObject.keySet()) {
                builder.put((Object)s, (Object)new ResourceLocation(jsonObject.get(s).getAsString()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.build();
    });
    public static final Codec<PowerFactory<?>> IGNORE_NAMESPACE_CODEC = Codec.STRING.comapFlatMap(val -> {
        ResourceLocation temp;
        ResourceLocation id;
        if (val.startsWith("io.github.apace100.apoli.power.")) {
            val = val.substring("io.github.apace100.apoli.power.".length());
        }
        ResourceLocation resourceLocation = id = (temp = ALIASES.get(val)) != null ? temp : ResourceLocation.m_135820_((String)val);
        if (id == null) {
            return DataResult.error((String)("Failed to convert \"" + val + "\" to a resource location"));
        }
        PowerFactory value = (PowerFactory)ApoliRegistries.POWER_FACTORY.get().getValue(id);
        if (value != null) {
            return DataResult.success((Object)((Object)value));
        }
        return ApoliRegistries.POWER_FACTORY.get().getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135815_().equals(id.m_135815_())).findFirst().map(Map.Entry::getValue).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Failed to find power factory with path: " + id.m_135815_())));
    }, x -> x.getRegistryName().toString());
    private final Codec<ConfiguredPower<T, ?>> codec;
    private final boolean allowConditions;
    private boolean ticking = false;
    private boolean tickingWhenInactive = false;
    private final Lazy<io.github.apace100.apoli.power.factory.PowerFactory<?>> legacyType = Lazy.of(() -> new io.github.apace100.apoli.power.factory.PowerFactory(this.getRegistryName(), this));

    private static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> Codec<ConfiguredPower<T, ?>> powerCodec(Codec<T> codec, F factory) {
        return IFactory.unionCodec(IFactory.asMap(codec), PowerData.CODEC, factory::configure, ConfiguredPower::getConfiguration, ConfiguredPower::getData);
    }

    protected PowerFactory(Codec<T> codec) {
        this(codec, true);
    }

    protected PowerFactory(Codec<T> codec, boolean allowConditions) {
        this.codec = PowerFactory.powerCodec(codec, this);
        this.allowConditions = allowConditions;
    }

    protected final void ticking(boolean whenInactive) {
        this.ticking = true;
        this.tickingWhenInactive = whenInactive;
    }

    public Codec<ConfiguredPower<T, ?>> getCodec() {
        return this.codec;
    }

    protected final void ticking() {
        this.ticking(false);
    }

    public Map<String, Holder<ConfiguredPower<?, ?>>> getContainedPowers(ConfiguredPower<T, ?> configuration) {
        return ImmutableMap.of();
    }

    @Nullable
    public ICapabilityProvider initCapabilities() {
        return null;
    }

    public ConfiguredPower<T, ?> configure(T input, PowerData data) {
        return new ConfiguredPower<T, PowerFactory>(() -> this, input, data);
    }

    protected boolean shouldCheckConditions(ConfiguredPower<T, ?> configuration, Entity entity) {
        return this.allowConditions;
    }

    protected boolean shouldTickWhenActive(ConfiguredPower<T, ?> configuration, Entity entity) {
        return this.ticking;
    }

    protected boolean shouldTickWhenInactive(ConfiguredPower<T, ?> configuration, Entity entity) {
        return this.tickingWhenInactive;
    }

    public boolean canTick(ConfiguredPower<T, ?> configuration, Entity entity) {
        return this.shouldTickWhenActive(configuration, entity) && (this.shouldTickWhenInactive(configuration, entity) || this.isActive(configuration, entity));
    }

    public void tick(ConfiguredPower<T, ?> configuration, Entity entity) {
        this.tick(configuration.getConfiguration(), entity);
    }

    public void onGained(ConfiguredPower<T, ?> configuration, Entity entity) {
        this.onGained(configuration.getConfiguration(), entity);
    }

    public void onLost(ConfiguredPower<T, ?> configuration, Entity entity) {
        this.onLost(configuration.getConfiguration(), entity);
    }

    public void onAdded(ConfiguredPower<T, ?> configuration, Entity entity) {
        this.onAdded(configuration.getConfiguration(), entity);
    }

    public void onRemoved(ConfiguredPower<T, ?> configuration, Entity entity) {
        this.onRemoved(configuration.getConfiguration(), entity);
    }

    public void onRespawn(ConfiguredPower<T, ?> configuration, Entity entity) {
        this.onRespawn(configuration.getConfiguration(), entity);
    }

    public int tickInterval(ConfiguredPower<T, ?> configuration, Entity entity) {
        return this.tickInterval(configuration.getConfiguration(), entity);
    }

    protected void tick(T configuration, Entity entity) {
    }

    protected void onGained(T configuration, Entity entity) {
    }

    protected void onLost(T configuration, Entity entity) {
    }

    protected void onAdded(T configuration, Entity entity) {
    }

    protected void onRemoved(T configuration, Entity entity) {
    }

    protected void onRespawn(T configuration, Entity entity) {
    }

    protected int tickInterval(T configuration, Entity entity) {
        return 1;
    }

    public boolean isActive(ConfiguredPower<T, ?> configuration, Entity entity) {
        return !this.shouldCheckConditions(configuration, entity) || configuration.getData().conditions().stream().allMatch(condition -> condition.check(entity));
    }

    public void serialize(ConfiguredPower<T, ?> configuration, IPowerContainer container, CompoundTag tag) {
    }

    public void deserialize(ConfiguredPower<T, ?> configuration, IPowerContainer container, CompoundTag tag) {
    }

    public io.github.apace100.apoli.power.factory.PowerFactory<?> getLegacyFactory() {
        return (io.github.apace100.apoli.power.factory.PowerFactory)this.legacyType.get();
    }
}

