/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.power.configuration;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import io.github.edwinmindcraft.apoli.api.power.IHudRenderedPower;
import io.github.edwinmindcraft.apoli.api.power.IVariableIntPower;
import io.github.edwinmindcraft.apoli.api.power.PowerData;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.api.registry.ApoliBuiltinRegistries;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.github.edwinmindcraft.calio.api.network.CodecSet;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfiguredPower<C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>>
extends CapabilityProvider<ConfiguredPower<?, ?>>
implements IForgeRegistryEntry<ConfiguredPower<?, ?>>,
IDynamicFeatureConfiguration {
    public static final Codec<ConfiguredPower<?, ?>> CODEC = PowerFactory.CODEC.dispatch(ConfiguredPower::getFactory, PowerFactory::getCodec);
    public static final CodecSet<ConfiguredPower<?, ?>> CODEC_SET = CalioCodecHelper.forDynamicRegistry(ApoliDynamicRegistries.CONFIGURED_POWER_KEY, SerializableDataTypes.IDENTIFIER, CODEC);
    public static final Codec<Holder<ConfiguredPower<?, ?>>> HOLDER = CODEC_SET.holder();
    private final Lazy<F> factory;
    private final C configuration;
    private final PowerData data;
    public final Delegate<ConfiguredPower<?, ?>> delegate = new Delegate(this, ApoliBuiltinRegistries.CONFIGURED_POWER_CLASS);
    private ResourceLocation registryName = null;
    private final Lazy<PowerType<?>> type = Lazy.of(() -> new PowerType(this));

    public static MapCodec<Holder<ConfiguredPower<?, ?>>> required(String name) {
        return HOLDER.fieldOf(name);
    }

    public static MapCodec<Optional<Holder<ConfiguredPower<?, ?>>>> optional(String name) {
        return CalioCodecHelper.optionalField(HOLDER, name);
    }

    public ConfiguredPower(Supplier<F> factory, C configuration, PowerData data) {
        super(ApoliBuiltinRegistries.CONFIGURED_POWER_CLASS);
        RegistryObject ro;
        this.configuration = configuration;
        this.data = data;
        this.factory = Lazy.of(() -> {
            PowerFactory f = (PowerFactory)((Object)((Object)factory.get()));
            this.gatherCapabilities(f::initCapabilities);
            return f;
        });
        if (!(factory instanceof RegistryObject) || !(ro = (RegistryObject)factory).isPresent()) {
            this.factory.get();
        }
    }

    public PowerData getData() {
        return this.data;
    }

    public Map<String, Holder<ConfiguredPower<?, ?>>> getContainedPowers() {
        return ((PowerFactory)((Object)this.getFactory())).getContainedPowers(this);
    }

    public boolean isActive(Entity entity) {
        return this.getConfiguration().isConfigurationValid() && ((PowerFactory)((Object)this.getFactory())).isActive(this, entity);
    }

    public void onGained(Entity entity) {
        ((PowerFactory)((Object)this.getFactory())).onGained((ConfiguredPower)this, entity);
    }

    public void onRemoved(Entity entity) {
        ((PowerFactory)((Object)this.getFactory())).onRemoved((ConfiguredPower)this, entity);
    }

    public void onLost(Entity entity) {
        ((PowerFactory)((Object)this.getFactory())).onLost((ConfiguredPower)this, entity);
    }

    public void onAdded(Entity entity) {
        ((PowerFactory)((Object)this.getFactory())).onAdded((ConfiguredPower)this, entity);
    }

    public void onRespawn(Entity entity) {
        ((PowerFactory)((Object)this.getFactory())).onRespawn((ConfiguredPower)this, entity);
    }

    public <T> T getPowerData(Entity player, NonNullSupplier<? extends T> supplier) {
        return (T)IPowerContainer.get(player).resolve().map(x -> x.getPowerData(this, supplier)).orElseGet(() -> supplier.get());
    }

    public <T> T getPowerData(IPowerContainer container, NonNullSupplier<? extends T> supplier) {
        return container.getPowerData(this, supplier);
    }

    public Set<Holder<ConfiguredPower<?, ?>>> getChildren() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.getContainedPowers().values().forEach(value -> {
            if (value.m_203633_()) {
                builder.add(value).addAll(((ConfiguredPower)value.m_203334_()).getChildren());
            }
        });
        return builder.build();
    }

    public CompoundTag serialize(IPowerContainer container) {
        CompoundTag tag = new CompoundTag();
        CompoundTag caps = this.serializeCaps();
        if (caps != null && !caps.m_128456_()) {
            tag.m_128365_("ForgeCaps", (Tag)caps);
        }
        ((PowerFactory)((Object)this.getFactory())).serialize(this, container, tag);
        return tag;
    }

    public void deserialize(IPowerContainer container, CompoundTag tag) {
        ((PowerFactory)((Object)this.getFactory())).deserialize(this, container, tag);
    }

    public void tick(Entity entity, boolean force) {
        if (((PowerFactory)((Object)this.getFactory())).canTick(this, entity)) {
            int i;
            if (!(force || (i = ((PowerFactory)((Object)this.getFactory())).tickInterval((ConfiguredPower)this, entity)) > 0 && entity.f_19797_ % i == 0)) {
                return;
            }
            ((PowerFactory)((Object)this.getFactory())).tick((ConfiguredPower)this, entity);
        }
    }

    public void tick(Entity entity) {
        this.tick(entity, false);
    }

    public Optional<IVariableIntPower<C>> asVariableIntPower() {
        F f = this.getFactory();
        if (f instanceof IVariableIntPower) {
            IVariableIntPower variableIntPower = (IVariableIntPower)f;
            return Optional.of(variableIntPower);
        }
        return Optional.empty();
    }

    public OptionalInt assign(Entity entity, int value) {
        return this.asVariableIntPower().map(t -> t.assign(this, entity, value)).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public OptionalInt getValue(Entity entity) {
        return this.asVariableIntPower().map(t -> t.getValue(this, entity)).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public OptionalInt getMaximum(Entity entity) {
        return this.asVariableIntPower().map(t -> t.getMaximum(this, entity)).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public OptionalInt getMinimum(Entity entity) {
        return this.asVariableIntPower().map(t -> t.getMinimum(this, entity)).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public OptionalInt change(Entity entity, int amount) {
        return this.asVariableIntPower().map(t -> t.change(this, entity, amount)).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public OptionalInt increment(Entity entity) {
        return this.asVariableIntPower().map(t -> t.increment(this, entity)).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public OptionalInt decrement(Entity entity) {
        return this.asVariableIntPower().map(t -> t.decrement(this, entity)).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public Optional<IHudRenderedPower<C>> asHudRendered() {
        Optional<IHudRenderedPower<C>> optional;
        F f = this.getFactory();
        if (f instanceof IHudRenderedPower) {
            IHudRenderedPower hudRenderedPower = (IHudRenderedPower)f;
            optional = Optional.of(hudRenderedPower);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Optional<HudRender> getRenderSettings(Entity entity) {
        return this.asHudRendered().map(x -> x.getRenderSettings(this, entity));
    }

    public Optional<Boolean> shouldRender(Entity entity) {
        return this.asHudRendered().map(x -> x.shouldRender(this, entity));
    }

    public Optional<Float> getFill(Entity entity) {
        return this.asHudRendered().map(x -> Float.valueOf(x.getFill(this, entity)));
    }

    public Optional<IActivePower<C>> asActive() {
        Optional<IActivePower<C>> optional;
        F f = this.getFactory();
        if (f instanceof IActivePower) {
            IActivePower hudRenderedPower = (IActivePower)f;
            optional = Optional.of(hudRenderedPower);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public boolean activate(Entity entity) {
        Optional<IActivePower<C>> ciActivePower = this.asActive();
        ciActivePower.ifPresent(x -> x.activate(this, entity));
        return ciActivePower.isPresent();
    }

    public Optional<IActivePower.Key> getKey(@Nullable Entity entity) {
        return this.asActive().map(x -> x.getKey(this, entity));
    }

    public Class<ConfiguredPower<?, ?>> getRegistryType() {
        return ApoliBuiltinRegistries.CONFIGURED_POWER_CLASS;
    }

    public ConfiguredPower<?, ?> setRegistryName(String name) {
        if (this.getRegistryName() != null) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.getRegistryName());
        }
        this.registryName = this.checkRegistryName(name);
        this.delegate.setName(this.registryName);
        this.getContainedPowers().forEach((s, configuredPower) -> {
            if (configuredPower.m_203633_() && ((ConfiguredPower)configuredPower.m_203334_()).getRegistryName() == null) {
                ((ConfiguredPower)configuredPower.m_203334_()).setRegistryName(name + s);
            }
        });
        return this;
    }

    public ConfiguredPower<?, ?> setRegistryName(ResourceLocation name) {
        return this.setRegistryName(name.toString());
    }

    public ConfiguredPower<?, ?> setRegistryName(String modID, String name) {
        return this.setRegistryName(modID + ":" + name);
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        if (this.delegate.name() != null) {
            return this.delegate.name();
        }
        return this.registryName != null ? this.registryName : null;
    }

    public ConfiguredPower<C, F> complete(ResourceLocation name) {
        return new ConfiguredPower<C, PowerFactory>(this::getFactory, this.getConfiguration(), this.getData().complete(name));
    }

    public F getFactory() {
        return (F)((Object)((PowerFactory)((Object)this.factory.get())));
    }

    public C getConfiguration() {
        return this.configuration;
    }

    @Override
    @NotNull
    public List<String> getErrors(@NotNull ICalioDynamicRegistryManager server) {
        return this.getConfiguration().getErrors(server);
    }

    @Override
    @NotNull
    public List<String> getWarnings(@NotNull ICalioDynamicRegistryManager server) {
        return this.getConfiguration().getWarnings(server);
    }

    @Override
    public boolean isConfigurationValid() {
        return this.getConfiguration().isConfigurationValid();
    }

    ResourceLocation checkRegistryName(String name) {
        return new ResourceLocation(name);
    }

    public String toString() {
        return "CP:" + this.getFactory().getRegistryName() + "(" + this.getData() + ")-" + this.getConfiguration();
    }

    public PowerType<?> getPowerType() {
        return (PowerType)this.type.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfiguredPower that = (ConfiguredPower)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    private static final class Delegate<T>
    implements IRegistryDelegate<T> {
        private T referent;
        private ResourceLocation name;
        private final Class<T> type;

        public Delegate(T referent, Class<T> type) {
            this.referent = referent;
            this.type = type;
        }

        public T get() {
            return this.referent;
        }

        @Nullable
        public ResourceLocation name() {
            return this.name;
        }

        public Class<T> type() {
            return this.type;
        }

        void changeReference(T newTarget) {
            this.referent = newTarget;
        }

        public void setName(ResourceLocation name) {
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Delegate) {
                Delegate other = (Delegate)obj;
                return Objects.equals(other.name, this.name);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }
    }
}

