/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.power;

import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import java.util.List;
import java.util.function.Supplier;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public abstract class ConfiguredFactory<T extends IDynamicFeatureConfiguration, F, CF extends ConfiguredFactory<?, ?, CF>>
extends ForgeRegistryEntry.UncheckedRegistryEntry<CF>
implements IDynamicFeatureConfiguration {
    private final Lazy<F> factory;
    private final T configuration;

    protected ConfiguredFactory(Supplier<F> factory, T configuration) {
        this.factory = Lazy.of(factory);
        this.configuration = configuration;
    }

    public F getFactory() {
        return (F)this.factory.get();
    }

    public T getConfiguration() {
        return this.configuration;
    }

    @Override
    @NotNull
    public List<String> getErrors(@NotNull ICalioDynamicRegistryManager server) {
        return this.getConfiguration().getErrors(server);
    }

    @Override
    @NotNull
    public List<String> getWarnings(@NotNull ICalioDynamicRegistryManager server) {
        return this.getConfiguration().getWarnings(server);
    }

    @Override
    public boolean isConfigurationValid() {
        return this.getConfiguration().isConfigurationValid();
    }
}

