/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.configuration;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.configuration.IStreamConfiguration;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public final class ListConfiguration<T>
implements IDynamicFeatureConfiguration,
IStreamConfiguration<T> {
    public static final MapCodec<ListConfiguration<AttributeModifier>> MODIFIER_CODEC = ListConfiguration.modifierCodec("modifier");
    private final ImmutableList<T> content;

    @SafeVarargs
    public static <T> ListConfiguration<T> of(T ... elements) {
        return new ListConfiguration<T>(ImmutableList.copyOf((Object[])elements));
    }

    public static MapCodec<ListConfiguration<AttributeModifier>> modifierCodec(String singular) {
        return ListConfiguration.mapCodec(SerializableDataTypes.ATTRIBUTE_MODIFIER, singular, singular + "s");
    }

    public static <T> MapCodec<ListConfiguration<T>> mapCodec(Codec<T> codec, String singular, String plural) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField(codec, singular).forGetter(ListConfiguration::getSingular), (App)CalioCodecHelper.optionalField(CalioCodecHelper.listOf(codec), plural, ImmutableList.of()).forGetter(ListConfiguration::getMultiple)).apply((Applicative)instance, (first, others) -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            first.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            builder.addAll((Iterable)others);
            return new ListConfiguration(builder.build());
        }));
    }

    public static <T> MapCodec<ListConfiguration<T>> optionalMapCodec(Codec<Optional<T>> codec, String singular, String plural) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField(codec, singular, Optional.empty()).forGetter(ListConfiguration::getSingular), (App)CalioCodecHelper.optionalListOf(codec).optionalFieldOf(plural, (Object)ImmutableList.of()).forGetter(ListConfiguration::getMultiple)).apply((Applicative)instance, (first, others) -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            first.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            builder.addAll((Iterable)others);
            return new ListConfiguration(builder.build());
        }));
    }

    public static <T> Codec<ListConfiguration<T>> codec(Codec<T> codec, String singular, String plural) {
        return ListConfiguration.mapCodec(codec, singular, plural).codec();
    }

    public static <T> Codec<ListConfiguration<T>> optionalCodec(Codec<Optional<T>> codec, String singular, String plural) {
        return ListConfiguration.optionalMapCodec(codec, singular, plural).codec();
    }

    public ListConfiguration(Iterable<T> content) {
        this.content = ImmutableList.copyOf(content);
    }

    @SafeVarargs
    public ListConfiguration(T ... params) {
        this.content = ImmutableList.copyOf((Object[])params);
    }

    private Optional<T> getSingular() {
        return this.content.size() == 1 ? this.content.stream().findFirst() : Optional.empty();
    }

    private List<T> getMultiple() {
        return this.content.size() == 1 ? ImmutableList.of() : ImmutableList.copyOf(this.content);
    }

    public List<T> getContent() {
        return this.content;
    }

    @Override
    public List<T> entries() {
        return this.content;
    }
}

