/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.api.component;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.integration.ModifyValueEvent;
import io.github.apace100.apoli.util.AttributeUtil;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.IValueModifyingPower;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.AttributeModifyTransferPower;
import io.github.edwinmindcraft.apoli.common.registry.ApoliCapabilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IPowerContainer {
    public static final ResourceLocation KEY = Apoli.identifier("powers");

    @NotNull
    public static LazyOptional<IPowerContainer> get(@Nullable Entity entity) {
        return entity == null ? LazyOptional.empty() : entity.getCapability(ApoliCapabilities.POWER_CONTAINER);
    }

    public static void sync(Entity entity) {
        ApoliAPI.synchronizePowerContainer(entity);
    }

    public static void sync(Entity entity, ServerPlayer with) {
        ApoliAPI.synchronizePowerContainer(entity, with);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> void withPower(Entity entity, F factory, Predicate<ConfiguredPower<T, F>> power, Consumer<ConfiguredPower<T, F>> with) {
        IPowerContainer.get(entity).ifPresent(x -> x.getPowers(factory).stream().filter(p -> power == null || power.test((ConfiguredPower)p)).findAny().ifPresent(with));
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> List<ConfiguredPower<T, F>> getPowers(Entity entity, F factory) {
        return IPowerContainer.get(entity).map(x -> x.getPowers(factory)).orElseGet(ImmutableList::of);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> boolean hasPower(Entity entity, F factory) {
        return IPowerContainer.get(entity).map(x -> x.getPowers().stream().anyMatch(p -> Objects.equals(factory, p.getFactory()) && p.isActive(entity))).orElse(false);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> float modify(Entity entity, F factory, float baseValue) {
        return (float)IPowerContainer.modify(entity, factory, (double)baseValue, null, null);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> float modify(Entity entity, F factory, float baseValue, Predicate<ConfiguredPower<T, F>> powerFilter) {
        return (float)IPowerContainer.modify(entity, factory, (double)baseValue, powerFilter, null);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> float modify(Entity entity, F factory, float baseValue, Predicate<ConfiguredPower<T, F>> powerFilter, Consumer<ConfiguredPower<T, F>> powerAction) {
        return (float)IPowerContainer.modify(entity, factory, (double)baseValue, powerFilter, powerAction);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> double modify(Entity entity, F factory, double baseValue) {
        return IPowerContainer.modify(entity, factory, baseValue, null, null);
    }

    public static <T extends IDynamicFeatureConfiguration, F extends PowerFactory<T>> double modify(Entity entity, F factory, double baseValue, Predicate<ConfiguredPower<T, F>> powerFilter, Consumer<ConfiguredPower<T, F>> powerAction) {
        List<ConfiguredPower> powers = IPowerContainer.getPowers(entity, factory).stream().filter(x -> powerFilter == null || powerFilter.test((ConfiguredPower)x)).toList();
        List modifiers = powers.stream().flatMap(x -> ((IValueModifyingPower)x.getFactory()).getModifiers(x, entity).stream()).collect(Collectors.toCollection(ArrayList::new));
        if (powerAction != null) {
            powers.forEach(powerAction);
        }
        modifiers.addAll(AttributeModifyTransferPower.apply(entity, factory));
        ModifyValueEvent event = new ModifyValueEvent(entity, factory, baseValue, modifiers);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return AttributeUtil.applyModifiers(event.getModifiers(), baseValue);
    }

    @Contract(mutates="this")
    public void removePower(ResourceLocation var1, ResourceLocation var2);

    @Contract(mutates="this")
    public int removeAllPowersFromSource(ResourceLocation var1);

    @NotNull
    public List<ResourceLocation> getPowersFromSource(ResourceLocation var1);

    @Contract(mutates="this")
    public boolean addPower(ResourceLocation var1, ResourceLocation var2);

    @Contract(pure=true)
    public boolean hasPower(@Nullable ResourceLocation var1);

    @Contract(pure=true)
    public boolean hasPower(ResourceLocation var1, ResourceLocation var2);

    @Nullable
    @Contract(value="null -> null", pure=true)
    public <C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>> ConfiguredPower<C, F> getPower(ResourceLocation var1);

    @NotNull
    @Contract(pure=true)
    public List<ConfiguredPower<?, ?>> getPowers();

    @NotNull
    @Contract(pure=true)
    public Set<ResourceLocation> getPowerNames();

    @NotNull
    @Contract(pure=true)
    public Set<ResourceLocation> getPowerTypes(boolean var1);

    @NotNull
    @Contract(pure=true)
    default public <C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>> List<ConfiguredPower<C, F>> getPowers(F factory) {
        return this.getPowers(factory, false);
    }

    @NotNull
    @Contract(pure=true)
    public <C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>> List<ConfiguredPower<C, F>> getPowers(F var1, boolean var2);

    @NotNull
    @Contract(pure=true)
    public List<ResourceLocation> getSources(ResourceLocation var1);

    @Contract(pure=true)
    public void sync();

    @Contract(mutates="this")
    public void serverTick();

    @Contract(mutates="this")
    default public void readFromNbt(CompoundTag tag) {
        this.readNbt(tag, true);
    }

    @Contract(mutates="this")
    public void readNbt(CompoundTag var1, boolean var2);

    public void rebuildCache();

    @Contract(mutates="this")
    public void handle(Multimap<ResourceLocation, ResourceLocation> var1, Map<ResourceLocation, CompoundTag> var2);

    @Contract(mutates="param")
    public CompoundTag writeToNbt(CompoundTag var1);

    @NotNull
    public <T> T getPowerData(ConfiguredPower<?, ?> var1, NonNullSupplier<? extends T> var2);

    public Entity getOwner();
}

