/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.apace100.origins.screen.ChooseOriginScreen;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class WaitForNextLayerScreen
extends Screen {
    private final List<OriginLayer> layerList;
    private final int currentLayerIndex;
    private final boolean showDirtBackground;
    private final int maxSelection;

    protected WaitForNextLayerScreen(List<OriginLayer> layerList, int currentLayerIndex, boolean showDirtBackground) {
        super(TextComponent.f_131282_);
        this.layerList = ImmutableList.copyOf(layerList);
        this.currentLayerIndex = currentLayerIndex;
        this.showDirtBackground = showDirtBackground;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        OriginLayer currentLayer = layerList.get(currentLayerIndex);
        this.maxSelection = currentLayer.getOriginOptionCount((Player)Objects.requireNonNull(player));
    }

    public void openSelection() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        LazyOptional<IOriginContainer> iOriginContainerLazyOptional = IOriginContainer.get((Entity)player);
        if (!iOriginContainerLazyOptional.isPresent()) {
            Minecraft.m_91087_().m_91152_(null);
            return;
        }
        IOriginContainer component = (IOriginContainer)iOriginContainerLazyOptional.orElseThrow(RuntimeException::new);
        for (int index = this.currentLayerIndex + 1; index < this.layerList.size(); ++index) {
            if (component.hasOrigin(this.layerList.get(index)) || this.layerList.get(index).origins((Player)Objects.requireNonNull(player)).size() <= 0) continue;
            Minecraft.m_91087_().m_91152_((Screen)new ChooseOriginScreen(this.layerList, index, this.showDirtBackground));
            return;
        }
        Minecraft.m_91087_().m_91152_(null);
    }

    public void m_6305_(@NotNull PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.maxSelection == 0) {
            this.openSelection();
            return;
        }
        this.m_7333_(matrices);
    }

    public void m_96558_(@NotNull PoseStack matrices, int vOffset) {
        if (this.showDirtBackground) {
            super.m_96626_(vOffset);
        } else {
            super.m_96558_(matrices, vOffset);
        }
    }
}

