/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.screen.Badge;
import io.github.apace100.origins.util.PowerKeyManager;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class OriginDisplayScreen
extends Screen {
    private static final ResourceLocation WINDOW = new ResourceLocation("origins", "textures/gui/choose_origin.png");
    private Origin origin;
    private OriginLayer layer;
    private boolean isOriginRandom;
    private Component randomOriginText;
    protected static final int windowWidth = 176;
    protected static final int windowHeight = 182;
    protected int scrollPos = 0;
    private int currentMaxScroll = 0;
    protected int guiTop;
    protected int guiLeft;
    protected final boolean showDirtBackground;
    private final List<RenderedBadge> renderedBadges = new LinkedList<RenderedBadge>();
    private boolean scrolling = false;
    private int scrollDragStart = 0;
    private double mouseDragStart = 0.0;

    public OriginDisplayScreen(Component title, boolean showDirtBackground) {
        super(title);
        this.showDirtBackground = showDirtBackground;
    }

    public void showOrigin(Origin origin, OriginLayer layer, boolean isRandom) {
        this.origin = origin;
        this.layer = layer;
        this.isOriginRandom = isRandom;
        this.scrollPos = 0;
    }

    public void setRandomOriginText(Component text) {
        this.randomOriginText = text;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - 176) / 2;
        this.guiTop = (this.f_96544_ - 182) / 2;
    }

    public Origin getCurrentOrigin() {
        return this.origin;
    }

    public OriginLayer getCurrentLayer() {
        return this.layer;
    }

    public void m_96558_(@NotNull PoseStack matrices, int vOffset) {
        if (this.showDirtBackground) {
            super.m_96626_(vOffset);
        } else {
            super.m_96558_(matrices, vOffset);
        }
    }

    public void m_6305_(@NotNull PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.renderedBadges.clear();
        this.m_7333_(matrices);
        this.renderOriginWindow(matrices, mouseX, mouseY);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        if (this.origin != null) {
            this.renderScrollbar(matrices, mouseX, mouseY);
            this.renderBadgeTooltip(matrices, mouseX, mouseY);
        }
    }

    private void renderScrollbar(PoseStack matrices, int mouseX, int mouseY) {
        if (!this.canScroll()) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)WINDOW);
        this.m_93228_(matrices, this.guiLeft + 155, this.guiTop + 35, 188, 24, 8, 134);
        int scrollbarY = 36;
        int maxScrollbarOffset = 141;
        int u = 176;
        float part = (float)this.scrollPos / (float)this.currentMaxScroll;
        scrollbarY = (int)((float)scrollbarY + (float)(maxScrollbarOffset - scrollbarY) * part);
        if (this.scrolling) {
            u += 6;
        } else if (mouseX >= this.guiLeft + 156 && mouseX < this.guiLeft + 156 + 6 && mouseY >= this.guiTop + scrollbarY && mouseY < this.guiTop + scrollbarY + 27) {
            u += 6;
        }
        this.m_93228_(matrices, this.guiLeft + 156, this.guiTop + scrollbarY, u, 24, 6, 27);
    }

    private boolean canScroll() {
        return this.origin != null && this.currentMaxScroll > 0;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.canScroll()) {
            this.scrolling = false;
            int scrollbarY = 36;
            int maxScrollbarOffset = 141;
            float part = (float)this.scrollPos / (float)this.currentMaxScroll;
            scrollbarY = (int)((float)scrollbarY + (float)(maxScrollbarOffset - scrollbarY) * part);
            if (mouseX >= (double)(this.guiLeft + 156) && mouseX < (double)(this.guiLeft + 156 + 6) && mouseY >= (double)(this.guiTop + scrollbarY) && mouseY < (double)(this.guiTop + scrollbarY + 27)) {
                this.scrolling = true;
                this.scrollDragStart = scrollbarY;
                this.mouseDragStart = mouseY;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            int delta = (int)(mouseY - this.mouseDragStart);
            int newScrollPos = Math.max(36, Math.min(141, this.scrollDragStart + delta));
            float part = (float)(newScrollPos - 36) / 105.0f;
            this.scrollPos = (int)(part * (float)this.currentMaxScroll);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void renderBadgeTooltip(PoseStack matrices, int mouseX, int mouseY) {
        for (RenderedBadge badge : this.renderedBadges) {
            if (mouseX < badge.x || mouseX >= badge.x + 9 || mouseY < badge.y || mouseY >= badge.y + 9) continue;
            String hoverText = badge.badge.getHoverText();
            String keyId = PowerKeyManager.getKeyIdentifier(badge.power);
            Component keybindText = (Component)KeyMapping.m_90842_((String)keyId).get();
            if (keybindText.getString().isEmpty()) {
                keybindText = new TranslatableComponent(keyId).m_130940_(ChatFormatting.ITALIC);
            }
            MutableComponent keyText = new TextComponent("[").m_7220_(keybindText).m_130946_("]");
            int maxWidth = this.f_96543_ - mouseX - 24;
            if (mouseX > this.f_96543_ / 2) {
                maxWidth = mouseX - 24;
            }
            if (hoverText.contains("\n")) {
                String[] texts;
                LinkedList<FormattedCharSequence> lines = new LinkedList<FormattedCharSequence>();
                for (String text : texts = hoverText.split("\n")) {
                    TranslatableComponent t = new TranslatableComponent(text, new Object[]{keyText});
                    if (this.f_96547_.m_92852_((FormattedText)t) > maxWidth) {
                        List wrapped = this.f_96547_.m_92923_((FormattedText)t, maxWidth);
                        lines.addAll(wrapped);
                        continue;
                    }
                    lines.add(t.m_7532_());
                }
                this.m_96617_(matrices, lines, mouseX, mouseY);
                break;
            }
            TranslatableComponent text = new TranslatableComponent(hoverText, new Object[]{keyText});
            if (this.f_96547_.m_92852_((FormattedText)text) > maxWidth) {
                List wrapped = this.f_96547_.m_92923_((FormattedText)text, maxWidth);
                this.m_96617_(matrices, wrapped, mouseX, mouseY);
                break;
            }
            this.m_96602_(matrices, (Component)text, mouseX, mouseY);
            break;
        }
    }

    protected Component getTitleText() {
        return new TextComponent("Origins");
    }

    private void renderOriginWindow(PoseStack matrices, int mouseX, int mouseY) {
        RenderSystem.m_69478_();
        this.renderWindowBackground(matrices, 16, 0);
        if (this.origin != null) {
            this.renderOriginContent(matrices, mouseX, mouseY);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)WINDOW);
        this.m_93228_(matrices, this.guiLeft, this.guiTop, 0, 0, 176, 182);
        if (this.origin != null) {
            this.renderOriginName(matrices);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WINDOW);
            this.renderOriginImpact(matrices, mouseX, mouseY);
            Component title = this.getTitleText();
            OriginDisplayScreen.m_93208_((PoseStack)matrices, (Font)this.f_96547_, (String)title.getString(), (int)(this.f_96543_ / 2), (int)(this.guiTop - 15), (int)0xFFFFFF);
        }
        RenderSystem.m_69461_();
    }

    private void renderOriginImpact(PoseStack matrices, int mouseX, int mouseY) {
        Impact impact = this.getCurrentOrigin().getImpact();
        int impactValue = impact.getImpactValue();
        int wOffset = impactValue * 8;
        for (int i = 0; i < 3; ++i) {
            if (i < impactValue) {
                this.m_93228_(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176 + wOffset, 16, 8, 8);
                continue;
            }
            this.m_93228_(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176, 16, 8, 8);
        }
        if (mouseX >= this.guiLeft + 128 && mouseX <= this.guiLeft + 158 && mouseY >= this.guiTop + 19 && mouseY <= this.guiTop + 27) {
            MutableComponent ttc = new TranslatableComponent("origins.gui.impact.impact").m_130946_(": ").m_7220_((Component)impact.getTextComponent());
            this.m_96602_(matrices, (Component)ttc, mouseX, mouseY);
        }
    }

    private void renderOriginName(PoseStack matrices) {
        FormattedText originName = this.f_96547_.m_92854_((FormattedText)this.getCurrentOrigin().getName(), 140);
        OriginDisplayScreen.m_93236_((PoseStack)matrices, (Font)this.f_96547_, (String)originName.getString(), (int)(this.guiLeft + 39), (int)(this.guiTop + 19), (int)0xFFFFFF);
        ItemStack is = this.getCurrentOrigin().getIcon();
        this.f_96542_.m_115123_(is, this.guiLeft + 15, this.guiTop + 15);
    }

    private void renderWindowBackground(PoseStack matrices, int offsetYStart, int offsetYEnd) {
        int border = 13;
        int endX = this.guiLeft + 176 - border;
        int endY = this.guiTop + 182 - border;
        RenderSystem.m_157456_((int)0, (ResourceLocation)WINDOW);
        for (int x = this.guiLeft; x < endX; x += 16) {
            for (int y = this.guiTop + offsetYStart; y < endY + offsetYEnd; y += 16) {
                this.m_93228_(matrices, x, y, 176, 0, Math.max(16, endX - x), Math.max(16, endY + offsetYEnd - y));
            }
        }
    }

    public boolean m_6050_(double x, double y, double z) {
        boolean retValue = super.m_6050_(x, y, z);
        int np = this.scrollPos - (int)z * 4;
        this.scrollPos = np < 0 ? 0 : Math.min(np, this.currentMaxScroll);
        return retValue;
    }

    private void renderOriginContent(PoseStack matrices, int mouseX, int mouseY) {
        int y;
        int textWidth = 128;
        Origin origin = this.getCurrentOrigin();
        int x = this.guiLeft + 18;
        int startY = y = this.guiTop + 50;
        int endY = y - 72 + 182;
        y -= this.scrollPos;
        Component orgDesc = origin.getDescription();
        List descLines = this.f_96547_.m_92923_((FormattedText)orgDesc, textWidth);
        for (FormattedCharSequence line : descLines) {
            if (y >= startY - 18 && y <= endY + 12) {
                this.f_96547_.m_92877_(matrices, line, (float)(x + 2), (float)(y - 6), 0xCCCCCC);
            }
            y += 12;
        }
        if (this.isOriginRandom) {
            List drawLines = this.f_96547_.m_92923_((FormattedText)this.randomOriginText, textWidth);
            for (FormattedCharSequence line : drawLines) {
                if ((y += 12) < startY - 24 || y > endY + 12) continue;
                this.f_96547_.m_92877_(matrices, line, (float)(x + 2), (float)y, 0xCCCCCC);
            }
            y += 14;
        } else {
            Registry<ConfiguredPower<?, ?>> powers = ApoliAPI.getPowers();
            for (ResourceLocation id : origin.getPowers()) {
                ConfiguredPower p = (ConfiguredPower)powers.m_7745_(id);
                if (p == null || p.getData().hidden()) continue;
                FormattedCharSequence name = Language.m_128107_().m_5536_(this.f_96547_.m_92854_((FormattedText)p.getData().getName().m_130940_(ChatFormatting.UNDERLINE), textWidth));
                TranslatableComponent desc = p.getData().getDescription();
                List drawLines = this.f_96547_.m_92923_((FormattedText)desc, textWidth);
                if (y >= startY - 24 && y <= endY + 12) {
                    this.f_96547_.m_92877_(matrices, name, (float)x, (float)y, 0xFFFFFF);
                    int tw = this.f_96547_.m_92724_(name);
                    Collection<Badge> badges = Origins.badgeManager.getBadges(id);
                    int xStart = x + tw + 4;
                    int bi = 0;
                    for (Badge badge : badges) {
                        RenderSystem.m_157456_((int)0, (ResourceLocation)badge.getSpriteLocation());
                        OriginDisplayScreen.m_93133_((PoseStack)matrices, (int)(xStart + 10 * bi), (int)(y - 1), (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
                        RenderedBadge rb = new RenderedBadge();
                        rb.badge = badge;
                        rb.power = id;
                        rb.x = xStart + 10 * bi;
                        rb.y = y - 1;
                        this.renderedBadges.add(rb);
                        ++bi;
                    }
                }
                for (FormattedCharSequence line : drawLines) {
                    if ((y += 12) < startY - 24 || y > endY + 12) continue;
                    this.f_96547_.m_92877_(matrices, line, (float)(x + 2), (float)y, 0xCCCCCC);
                }
                y += 14;
            }
        }
        this.currentMaxScroll = (y += this.scrollPos) - 14 - (this.guiTop + 158);
        if (this.currentMaxScroll < 0) {
            this.currentMaxScroll = 0;
        }
    }

    private static class RenderedBadge {
        ResourceLocation power;
        Badge badge;
        int x;
        int y;

        private RenderedBadge() {
        }
    }
}

