/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.registry.ModItems;
import io.github.apace100.origins.screen.OriginDisplayScreen;
import io.github.apace100.origins.screen.WaitForNextLayerScreen;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.data.PartialOrigin;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.C2SChooseOrigin;
import io.github.edwinmindcraft.origins.common.network.C2SChooseRandomOrigin;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class ChooseOriginScreen
extends OriginDisplayScreen {
    private static final Comparator<Origin> COMPARATOR = Comparator.comparingInt(a -> a.getImpact().getImpactValue()).thenComparingInt(Origin::getOrder);
    private final List<OriginLayer> layerList;
    private final int currentLayerIndex;
    private int currentOrigin = 0;
    private final List<Origin> originSelection;
    private int maxSelection;
    private Origin randomOrigin;

    public ChooseOriginScreen(List<OriginLayer> layerList, int currentLayerIndex, boolean showDirtBackground) {
        super((Component)new TranslatableComponent("origins.screen.choose_origin"), showDirtBackground);
        Origin newOrigin;
        this.layerList = layerList;
        this.currentLayerIndex = currentLayerIndex;
        this.originSelection = new ArrayList<Origin>(10);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        OriginLayer currentLayer = layerList.get(currentLayerIndex);
        Registry<Origin> originsRegistry = OriginsAPI.getOriginsRegistry();
        currentLayer.origins((Player)Objects.requireNonNull(player)).forEach(arg_0 -> this.lambda$new$1(originsRegistry, (Player)player, arg_0));
        this.originSelection.sort(COMPARATOR);
        this.maxSelection = this.originSelection.size();
        if (currentLayer.allowRandom() && currentLayer.randomOrigins((Player)player).size() > 0) {
            ++this.maxSelection;
        }
        if (this.maxSelection == 0) {
            this.openNextLayerScreen();
        }
        this.showOrigin(newOrigin, layerList.get(currentLayerIndex), (newOrigin = this.getCurrentOriginInternal()) == this.randomOrigin);
    }

    private void openNextLayerScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new WaitForNextLayerScreen(this.layerList, this.currentLayerIndex, this.showDirtBackground));
    }

    public boolean m_6913_() {
        return false;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - 176) / 2;
        this.guiTop = (this.f_96544_ - 182) / 2;
        if (this.maxSelection > 1) {
            this.m_142416_((GuiEventListener)new Button(this.guiLeft - 40, this.f_96544_ / 2 - 10, 20, 20, (Component)new TextComponent("<"), b -> {
                Origin newOrigin;
                this.currentOrigin = (this.currentOrigin - 1 + this.maxSelection) % this.maxSelection;
                this.showOrigin(newOrigin, this.layerList.get(this.currentLayerIndex), (newOrigin = this.getCurrentOriginInternal()) == this.randomOrigin);
            }));
            this.m_142416_((GuiEventListener)new Button(this.guiLeft + 176 + 20, this.f_96544_ / 2 - 10, 20, 20, (Component)new TextComponent(">"), b -> {
                Origin newOrigin;
                this.currentOrigin = (this.currentOrigin + 1) % this.maxSelection;
                this.showOrigin(newOrigin, this.layerList.get(this.currentLayerIndex), (newOrigin = this.getCurrentOriginInternal()) == this.randomOrigin);
            }));
        }
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + 88 - 50, this.guiTop + 182 + 5, 100, 20, (Component)new TranslatableComponent("origins.gui.select"), b -> {
            ResourceLocation layer = OriginsAPI.getLayersRegistry().m_7981_((Object)this.layerList.get(this.currentLayerIndex));
            this.openNextLayerScreen();
            if (this.currentOrigin == this.originSelection.size()) {
                OriginsCommon.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChooseRandomOrigin(layer));
            } else {
                OriginsCommon.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChooseOrigin(layer, this.getCurrentOrigin().getRegistryName()));
            }
        }));
    }

    @Override
    protected Component getTitleText() {
        if (this.getCurrentLayer().title().choose() != null) {
            return this.getCurrentLayer().title().choose();
        }
        return new TranslatableComponent("origins.gui.choose_origin.title", new Object[]{this.getCurrentLayer().name()});
    }

    private Origin getCurrentOriginInternal() {
        if (this.currentOrigin == this.originSelection.size()) {
            if (this.randomOrigin == null) {
                this.initRandomOrigin();
            }
            return this.randomOrigin;
        }
        return this.originSelection.get(this.currentOrigin);
    }

    private void initRandomOrigin() {
        Registry<Origin> registry = OriginsAPI.getOriginsRegistry();
        this.randomOrigin = PartialOrigin.builder().icon(new ItemStack((ItemLike)ModItems.ORB_OF_ORIGIN.get())).impact(Impact.NONE).order(Integer.MAX_VALUE).loadingOrder(Integer.MAX_VALUE).build().create(Origins.identifier("random"));
        TextComponent text = new TextComponent("");
        List<Origin> randoms = this.layerList.get(this.currentLayerIndex).randomOrigins((Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_)).stream().map(arg_0 -> registry.m_7745_(arg_0)).filter(Objects::nonNull).sorted(COMPARATOR).toList();
        randoms.forEach(arg_0 -> ChooseOriginScreen.lambda$initRandomOrigin$5((MutableComponent)text, arg_0));
        this.setRandomOriginText((Component)text);
    }

    @Override
    public void m_96558_(@NotNull PoseStack matrices, int vOffset) {
        if (this.showDirtBackground) {
            super.m_96626_(vOffset);
        } else {
            super.m_96558_(matrices, vOffset);
        }
    }

    @Override
    public void m_6305_(@NotNull PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.maxSelection == 0) {
            this.openNextLayerScreen();
            return;
        }
        super.m_6305_(matrices, mouseX, mouseY, delta);
    }

    private static /* synthetic */ void lambda$initRandomOrigin$5(MutableComponent text, Origin x) {
        text.m_7220_(x.getName()).m_130946_("\n");
    }

    private /* synthetic */ void lambda$new$1(Registry originsRegistry, Player player, ResourceLocation originId) {
        Origin origin = (Origin)((Object)originsRegistry.m_7745_(originId));
        if (origin != null && origin.isChoosable()) {
            ItemStack displayItem = origin.getIcon().m_41777_();
            if (!(displayItem.m_41720_() != Items.f_42680_ || displayItem.m_41782_() && Objects.requireNonNull(displayItem.m_41783_()).m_128441_("SkullOwner"))) {
                displayItem.m_41784_().m_128359_("SkullOwner", player.m_5446_().getString());
            }
            this.originSelection.add(origin);
        }
    }
}

