/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.github.apace100.apoli.integration.PowerLoadEvent;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.screen.Badge;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import io.github.edwinmindcraft.apoli.api.power.ITogglePower;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.calio.api.event.CalioDynamicRegistryEvent;
import io.github.edwinmindcraft.origins.common.network.S2CSynchronizeBadges;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.Nullable;

public class BadgeManager {
    private final Multimap<ResourceLocation, Badge> badges = HashMultimap.create();

    public S2CSynchronizeBadges createPacket() {
        return new S2CSynchronizeBadges((Multimap<ResourceLocation, Badge>)Multimaps.unmodifiableMultimap(this.badges));
    }

    @Nullable
    private Badge findBadge(ConfiguredPower<?, ?> power) {
        if (power.getFactory() instanceof ITogglePower) {
            return Badge.TOGGLE;
        }
        if (power.getFactory() instanceof IActivePower) {
            return Badge.ACTIVE;
        }
        return null;
    }

    private void onPowerLoad(PowerLoadEvent.Post event) {
        ResourceLocation id = event.getId();
        JsonElement data = event.getAdditionalData("badges");
        ConfiguredPower<?, ?> power = event.getPower();
        LinkedList<Badge> badges = new LinkedList<Badge>();
        if (!power.getData().hidden() && !data.isJsonNull()) {
            if (data.isJsonArray()) {
                data.getAsJsonArray().forEach(badgeJson -> {
                    try {
                        if (badgeJson.isJsonObject()) {
                            badges.add(Badge.fromJson(badgeJson));
                        } else {
                            Origins.LOGGER.error("\"badges\" field in power \"{}\" contained an entry that was not a JSON object.", (Object)id);
                        }
                    }
                    catch (JsonParseException e) {
                        Origins.LOGGER.error("\"badges\" field in power \"{}\" failed to deserialize with error: {}.", (Object)id, (Object)e.getMessage());
                    }
                });
            } else {
                Origins.LOGGER.error("\"badges\" field in power \"{}\" should be an array.", (Object)id);
            }
        }
        if (badges.isEmpty()) {
            Badge autoBadge = this.findBadge(power);
            if (autoBadge == null) {
                for (Holder<ConfiguredPower<?, ?>> subPower : power.getContainedPowers().values()) {
                    if (subPower.m_203633_() && (autoBadge = this.findBadge((ConfiguredPower)subPower.m_203334_())) != null) break;
                }
            }
            if (autoBadge != null) {
                badges.add(autoBadge);
            }
        }
        badges.forEach(x -> this.addBadge(id, (Badge)x));
    }

    private void onDynamicRegistryReload(CalioDynamicRegistryEvent.Reload event) {
        this.clear();
    }

    public BadgeManager() {
        MinecraftForge.EVENT_BUS.addListener(this::onPowerLoad);
        MinecraftForge.EVENT_BUS.addListener(this::onDynamicRegistryReload);
        ApoliAPI.addAdditionalDataField("badges");
    }

    public void clear() {
        this.badges.clear();
    }

    public void addBadge(ResourceLocation powerId, Badge badge) {
        this.badges.put((Object)powerId, (Object)badge);
    }

    public Collection<Badge> getBadges(ResourceLocation powerId) {
        if (!this.badges.containsKey((Object)powerId)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.badges.get((Object)powerId));
    }
}

