/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.origins.Origins;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record Badge(ResourceLocation spriteLocation, String hoverText) {
    public static final Codec<Badge> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableDataTypes.IDENTIFIER.fieldOf("sprite").forGetter(Badge::getSpriteLocation), (App)Codec.STRING.fieldOf("text").forGetter(Badge::getHoverText)).apply((Applicative)instance, Badge::new));
    public static final SerializableData DATA = new SerializableData().add("sprite", SerializableDataTypes.IDENTIFIER).add("text", SerializableDataTypes.STRING);
    public static final Badge ACTIVE = new Badge(Origins.identifier("textures/gui/badge/active.png"), "origins.gui.badge.active");
    public static final Badge TOGGLE = new Badge(Origins.identifier("textures/gui/badge/toggle.png"), "origins.gui.badge.toggle");

    public String getHoverText() {
        return this.hoverText;
    }

    public ResourceLocation getSpriteLocation() {
        return this.spriteLocation;
    }

    public SerializableData.Instance getData() {
        SerializableData.Instance data = DATA.new SerializableData.Instance();
        data.set("sprite", this.spriteLocation);
        data.set("text", this.hoverText);
        return data;
    }

    public static Badge fromData(SerializableData.Instance data) {
        return new Badge(data.getId("sprite"), data.getString("text"));
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.m_130059_(CODEC, (Object)this);
    }

    public JsonElement toJson() {
        return (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow(false, s -> {
            throw new JsonParseException("Failed to parse badge: " + s);
        });
    }

    public static Badge fromNetwork(FriendlyByteBuf buf) {
        return (Badge)buf.m_130057_(CODEC);
    }

    public static Badge fromJson(JsonElement element) throws JsonParseException {
        DataResult badge = CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).map(Pair::getFirst);
        if (badge.error().isPresent()) {
            throw new JsonParseException("Error parsing badge: " + ((DataResult.PartialResult)badge.error().get()).message());
        }
        if (badge.result().isPresent()) {
            return (Badge)badge.result().get();
        }
        throw new JsonParseException("If you see this message, someone did something REALLY wrong.");
    }
}

