/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.content;

import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.S2COpenOriginScreen;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrbOfOriginItem
extends Item {
    public OrbOfOriginItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40753_).m_41497_(Rarity.RARE));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            IOriginContainer.get((Entity)player).ifPresent(container -> {
                Map<OriginLayer, Origin> targets = this.getTargets(stack);
                if (targets.size() > 0) {
                    for (Map.Entry entry : targets.entrySet()) {
                        container.setOrigin((OriginLayer)entry.getKey(), (Origin)((Object)((Object)entry.getValue())));
                    }
                } else {
                    for (OriginLayer originLayer : OriginsAPI.getActiveLayers()) {
                        container.setOrigin(originLayer, Origin.EMPTY);
                    }
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    container.checkAutoChoosingLayers(false);
                    PacketDistributor.PacketTarget packetTarget = PacketDistributor.PLAYER.with(() -> sp);
                    OriginsCommon.CHANNEL.send(packetTarget, (Object)container.getSynchronizationPacket());
                    OriginsCommon.CHANNEL.send(packetTarget, (Object)new S2COpenOriginScreen(false));
                    container.synchronize();
                }
            });
        }
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flags) {
        Map<OriginLayer, Origin> targets = this.getTargets(stack);
        for (Map.Entry<OriginLayer, Origin> entry : targets.entrySet()) {
            if (entry.getValue() == Origin.EMPTY) {
                components.add((Component)new TranslatableComponent("item.origins.orb_of_origin.layer_generic", new Object[]{entry.getKey().name()}).m_130940_(ChatFormatting.GRAY));
                continue;
            }
            components.add((Component)new TranslatableComponent("item.origins.orb_of_origin.layer_specific", new Object[]{entry.getKey().name(), entry.getValue().getName()}).m_130940_(ChatFormatting.GRAY));
        }
    }

    private Map<OriginLayer, Origin> getTargets(ItemStack stack) {
        HashMap<OriginLayer, Origin> targets = new HashMap<OriginLayer, Origin>();
        if (!stack.m_41782_()) {
            return targets;
        }
        CompoundTag nbt = Objects.requireNonNull(stack.m_41783_());
        ListTag targetList = nbt.m_128437_("Targets", 10);
        for (Tag nbtElement : targetList) {
            CompoundTag targetNbt = (CompoundTag)nbtElement;
            if (!targetNbt.m_128425_("Layer", 8)) continue;
            try {
                ResourceLocation id = new ResourceLocation(targetNbt.m_128461_("Layer"));
                OriginLayer layer = (OriginLayer)OriginsAPI.getLayersRegistry().m_7745_(id);
                if (layer == null) continue;
                Origin origin = Origin.EMPTY;
                if (targetNbt.m_128425_("Origin", 8)) {
                    ResourceLocation originId = new ResourceLocation(targetNbt.m_128461_("Origin"));
                    origin = (Origin)((Object)OriginsAPI.getOriginsRegistry().m_7745_(originId));
                }
                if (origin == null || origin.getRegistryName() == null || !layer.enabled() || !layer.contains(origin.getRegistryName()) && !origin.isSpecial()) continue;
                targets.put(layer, origin);
            }
            catch (Exception exception) {}
        }
        return targets;
    }
}

