/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.component;

import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import java.util.HashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public interface OriginComponent {
    public boolean hasOrigin(OriginLayer var1);

    public boolean hasAllOrigins();

    public HashMap<OriginLayer, Origin> getOrigins();

    public Origin getOrigin(OriginLayer var1);

    public boolean hadOriginBefore();

    public void setOrigin(OriginLayer var1, Origin var2);

    public void sync();

    @Deprecated(forRemoval=true)
    default public void onPowersRead() {
    }

    public static void sync(Player player) {
        IOriginContainer.get((Entity)player).ifPresent(IOriginContainer::synchronize);
    }

    public static void onChosen(Player player, boolean hadOriginBefore) {
        IOriginContainer.get((Entity)player).ifPresent(x -> x.onChosen(hadOriginBefore));
    }

    public static void partialOnChosen(Player player, boolean hadOriginBefore, Origin origin) {
        IOriginContainer.get((Entity)player).ifPresent(x -> x.onChosen(origin.getWrapped(), hadOriginBefore));
    }

    default public boolean checkAutoChoosingLayers(Player player, boolean includeDefaults) {
        return IOriginContainer.get((Entity)player).map(x -> x.checkAutoChoosingLayers(includeDefaults)).orElse(false);
    }
}

