/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;

public final class OrderedResourceListeners {
    private static final Map<ResourceLocation, ImmutableRegistration> REGISTRATIONS = new HashMap<ResourceLocation, ImmutableRegistration>();

    public static List<PreparableReloadListener> orderedList() {
        int prevSize;
        HashSet<ResourceLocation> handled = new HashSet<ResourceLocation>();
        do {
            prevSize = handled.size();
            for (ImmutableRegistration value : REGISTRATIONS.values()) {
                if (handled.contains(value.key()) || !handled.containsAll((Collection<?>)value.dependencies())) continue;
                handled.add(value.key());
            }
        } while (prevSize != handled.size());
        if (handled.size() != REGISTRATIONS.size()) {
            throw new IllegalStateException("Some validators have missing or circular dependencies: [" + String.join((CharSequence)",", REGISTRATIONS.values().stream().filter(x -> !handled.contains(x.key())).map(Record::toString).collect(Collectors.toSet())) + "]");
        }
        return (List)handled.stream().map(REGISTRATIONS::get).filter(x -> !x.dummy() && x.listener() != null).map(ImmutableRegistration::listener).collect(ImmutableList.toImmutableList());
    }

    public static Registration register(PreparableReloadListener resourceReloadListener, ResourceLocation location) {
        return new Registration(resourceReloadListener, location);
    }

    public static void addDummy(ResourceLocation location) {
        new Registration(null, location, true).complete();
    }

    private static void completeRegistration(Registration registration) {
        REGISTRATIONS.put(registration.key(), new ImmutableRegistration(registration.resourceReloadListener, registration.key(), (ImmutableSet<ResourceLocation>)registration.afterSet.build(), registration.dummy));
    }

    private record ImmutableRegistration(PreparableReloadListener listener, ResourceLocation key, ImmutableSet<ResourceLocation> dependencies, boolean dummy) {
    }

    public static class Registration {
        private final PreparableReloadListener resourceReloadListener;
        private final ResourceLocation key;
        private final ImmutableSet.Builder<ResourceLocation> afterSet = new ImmutableSet.Builder();
        private final boolean dummy;
        private boolean isCompleted;

        private Registration(PreparableReloadListener resourceReloadListener, ResourceLocation key, boolean dummy) {
            this.resourceReloadListener = resourceReloadListener;
            this.key = key;
            this.dummy = dummy;
        }

        private Registration(PreparableReloadListener resourceReloadListener, ResourceLocation key) {
            this(resourceReloadListener, key, false);
        }

        public ResourceLocation key() {
            return this.key;
        }

        public Registration after(ResourceLocation identifier) {
            if (this.isCompleted) {
                throw new IllegalStateException("Can't add a resource reload listener registration dependency after it was completed.");
            }
            this.afterSet.add((Object)identifier);
            return this;
        }

        public void complete() {
            OrderedResourceListeners.completeRegistration(this);
            this.isCompleted = true;
        }
    }
}

