/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.apace100.calio.ClassUtil;
import io.github.apace100.calio.data.MultiJsonDataLoader;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.calio.registry.DataObject;
import io.github.apace100.calio.registry.DataObjectFactory;
import io.github.apace100.calio.util.OrderedResourceListeners;
import io.github.edwinmindcraft.calio.common.network.CalioNetwork;
import io.github.edwinmindcraft.calio.common.network.packet.S2CDataObjectRegistryPacket;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataObjectRegistry<T extends DataObject<T>> {
    private static final HashMap<ResourceLocation, DataObjectRegistry<?>> REGISTRIES = new HashMap();
    private static final Set<ResourceLocation> AUTO_SYNC_SET = new HashSet<ResourceLocation>();
    private final ResourceLocation registryId;
    private final Class<T> objectClass;
    private final HashMap<ResourceLocation, T> idToEntry = new HashMap();
    private final HashMap<T, ResourceLocation> entryToId = new HashMap();
    private final HashMap<ResourceLocation, T> staticEntries = new HashMap();
    private final String factoryFieldName;
    private final DataObjectFactory<T> defaultFactory;
    private final HashMap<ResourceLocation, DataObjectFactory<T>> factoriesById = new HashMap();
    private final HashMap<DataObjectFactory<T>, ResourceLocation> factoryToId = new HashMap();
    private SerializableDataType<T> dataType;
    private SerializableDataType<List<T>> listDataType;
    private SerializableDataType<T> registryDataType;
    private SerializableDataType<Supplier<T>> lazyDataType;
    private final Function<JsonElement, JsonElement> jsonPreprocessor;

    private DataObjectRegistry(ResourceLocation registryId, Class<T> objectClass, String factoryFieldName, DataObjectFactory<T> defaultFactory, Function<JsonElement, JsonElement> jsonPreprocessor) {
        this.registryId = registryId;
        this.objectClass = objectClass;
        this.factoryFieldName = factoryFieldName;
        this.defaultFactory = defaultFactory;
        this.jsonPreprocessor = jsonPreprocessor;
    }

    private DataObjectRegistry(ResourceLocation registryId, Class<T> objectClass, String factoryFieldName, DataObjectFactory<T> defaultFactory, Function<JsonElement, JsonElement> jsonPreprocessor, String dataFolder, boolean useLoadingPriority, BiConsumer<ResourceLocation, Exception> errorHandler) {
        this(registryId, objectClass, factoryFieldName, defaultFactory, jsonPreprocessor);
        Loader loader = new Loader(dataFolder, useLoadingPriority, errorHandler);
        OrderedResourceListeners.register((PreparableReloadListener)loader, registryId).complete();
    }

    public ResourceLocation getRegistryId() {
        return this.registryId;
    }

    public ResourceLocation getId(T entry) {
        return this.entryToId.get(entry);
    }

    public DataObjectFactory<T> getFactory(ResourceLocation id) {
        return this.factoriesById.get(id);
    }

    public ResourceLocation getFactoryId(DataObjectFactory<T> factory) {
        return this.factoryToId.get(factory);
    }

    public void registerFactory(ResourceLocation id, DataObjectFactory<T> factory) {
        this.factoriesById.put(id, factory);
        this.factoryToId.put(factory, id);
    }

    public void register(ResourceLocation id, T entry) {
        this.idToEntry.put(id, entry);
        this.entryToId.put(entry, id);
    }

    public void registerStatic(ResourceLocation id, T entry) {
        this.staticEntries.put(id, entry);
        this.register(id, entry);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.idToEntry.size());
        for (Map.Entry<ResourceLocation, T> entry : this.idToEntry.entrySet()) {
            if (this.staticEntries.containsKey(entry.getKey())) continue;
            buf.m_130085_(entry.getKey());
            this.writeDataObject(buf, (DataObject)entry.getValue());
        }
    }

    public void writeDataObject(FriendlyByteBuf buf, T t) {
        DataObjectFactory<T> factory = t.getFactory();
        buf.m_130085_(this.factoryToId.get(factory));
        SerializableData.Instance data = factory.toData(t);
        factory.getData().write(buf, data);
    }

    public void receive(FriendlyByteBuf buf) {
        this.receive(buf, Runnable::run);
    }

    public void receive(FriendlyByteBuf buf, Consumer<Runnable> scheduler) {
        int entryCount = buf.readInt();
        HashMap<ResourceLocation, T> entries = new HashMap<ResourceLocation, T>(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            ResourceLocation entryId = buf.m_130281_();
            T entry = this.receiveDataObject(buf);
            entries.put(entryId, entry);
        }
        scheduler.accept(() -> {
            this.clear();
            entries.forEach(this::register);
        });
    }

    public T receiveDataObject(FriendlyByteBuf buf) {
        ResourceLocation factoryId = buf.m_130281_();
        DataObjectFactory<T> factory = this.getFactory(factoryId);
        SerializableData.Instance data = factory.getData().read(buf);
        return (T)((DataObject)factory.fromData(data));
    }

    public T readDataObject(JsonElement element) {
        DataObjectFactory<T> factory;
        if (this.jsonPreprocessor != null) {
            element = this.jsonPreprocessor.apply(element);
        }
        if (!element.isJsonObject()) {
            throw new JsonParseException("Could not read data object of type \"" + this.registryId + "\": expected a json object.");
        }
        JsonObject jsonObject = element.getAsJsonObject();
        if (!jsonObject.has(this.factoryFieldName) && this.defaultFactory == null) {
            throw new JsonParseException("Could not read data object of type \"" + this.registryId + "\": no factory identifier provided (expected key: \"" + this.factoryFieldName + "\").");
        }
        if (jsonObject.has(this.factoryFieldName)) {
            String type = GsonHelper.m_13906_((JsonObject)jsonObject, (String)this.factoryFieldName);
            ResourceLocation factoryId = null;
            try {
                factoryId = new ResourceLocation(type);
            }
            catch (ResourceLocationException e) {
                throw new JsonParseException("Could not read data object of type \"" + this.registryId + "\": invalid factory identifier (id: \"" + factoryId + "\").", (Throwable)e);
            }
            if (!this.factoriesById.containsKey(factoryId)) {
                throw new JsonParseException("Could not read data object of type \"" + this.registryId + "\": unknown factory (id: \"" + factoryId + "\").");
            }
            factory = this.getFactory(factoryId);
        } else {
            factory = this.defaultFactory;
        }
        SerializableData.Instance data = factory.getData().read(jsonObject);
        return (T)((DataObject)factory.fromData(data));
    }

    public void sync(ServerPlayer player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.write(buf);
        CalioNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CDataObjectRegistryPacket(this.registryId, buf));
    }

    public void clear() {
        this.idToEntry.clear();
        this.entryToId.clear();
        this.staticEntries.forEach(this::register);
    }

    @Nullable
    public T get(ResourceLocation id) {
        return (T)((DataObject)this.idToEntry.get(id));
    }

    public Set<ResourceLocation> getIds() {
        return this.idToEntry.keySet();
    }

    public boolean containsId(ResourceLocation id) {
        return this.idToEntry.containsKey(id);
    }

    @NotNull
    public Iterator<T> iterator() {
        return this.idToEntry.values().iterator();
    }

    public SerializableDataType<T> dataType() {
        if (this.dataType == null) {
            this.dataType = this.createDataType();
        }
        return this.dataType;
    }

    public SerializableDataType<List<T>> listDataType() {
        if (this.dataType == null) {
            this.dataType = this.createDataType();
        }
        if (this.listDataType == null) {
            this.listDataType = SerializableDataType.list(this.dataType);
        }
        return this.listDataType;
    }

    public SerializableDataType<T> registryDataType() {
        if (this.registryDataType == null) {
            this.registryDataType = this.createRegistryDataType();
        }
        return this.registryDataType;
    }

    public SerializableDataType<Supplier<T>> lazyDataType() {
        if (this.lazyDataType == null) {
            this.lazyDataType = this.createLazyDataType();
        }
        return this.lazyDataType;
    }

    public SerializableDataType<Supplier<T>> createLazyDataType() {
        return SerializableDataType.wrap(ClassUtil.castClass(Supplier.class), SerializableDataTypes.IDENTIFIER, lazy -> this.getId((DataObject)lazy.get()), id -> () -> this.get((ResourceLocation)id));
    }

    private SerializableDataType<T> createDataType() {
        return new SerializableDataType<DataObject>(this.objectClass, this::writeDataObject, this::receiveDataObject, this::readDataObject);
    }

    private SerializableDataType<T> createRegistryDataType() {
        return SerializableDataType.wrap(this.objectClass, SerializableDataTypes.IDENTIFIER, this::getId, this::get);
    }

    public static DataObjectRegistry<?> getRegistry(ResourceLocation registryId) {
        return REGISTRIES.get(registryId);
    }

    public static void performAutoSync(ServerPlayer player) {
        for (ResourceLocation registryId : AUTO_SYNC_SET) {
            DataObjectRegistry<?> registry = DataObjectRegistry.getRegistry(registryId);
            registry.sync(player);
        }
    }

    private class Loader
    extends MultiJsonDataLoader {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        private static final HashMap<ResourceLocation, Integer> LOADING_PRIORITIES = new HashMap();
        private final boolean useLoadingPriority;
        private final BiConsumer<ResourceLocation, Exception> errorHandler;

        public Loader(String dataFolder, boolean useLoadingPriority, BiConsumer<ResourceLocation, Exception> errorHandler) {
            super(GSON, dataFolder);
            this.useLoadingPriority = useLoadingPriority;
            this.errorHandler = errorHandler;
        }

        protected void apply(Map<ResourceLocation, List<JsonElement>> data, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
            DataObjectRegistry.this.clear();
            LOADING_PRIORITIES.clear();
            data.forEach((id, jel) -> {
                for (JsonElement je : jel) {
                    try {
                        SerializableData.CURRENT_NAMESPACE = id.m_135827_();
                        SerializableData.CURRENT_PATH = id.m_135815_();
                        JsonObject jo = je.getAsJsonObject();
                        Object t = DataObjectRegistry.this.readDataObject(je);
                        if (this.useLoadingPriority) {
                            int loadingPriority = GsonHelper.m_13824_((JsonObject)jo, (String)"loading_priority", (int)0);
                            if (DataObjectRegistry.this.containsId((ResourceLocation)id) && LOADING_PRIORITIES.get(id) >= loadingPriority) continue;
                            LOADING_PRIORITIES.put((ResourceLocation)id, loadingPriority);
                            DataObjectRegistry.this.register((ResourceLocation)id, t);
                            continue;
                        }
                        DataObjectRegistry.this.register((ResourceLocation)id, t);
                    }
                    catch (Exception e) {
                        if (this.errorHandler == null) continue;
                        this.errorHandler.accept((ResourceLocation)id, e);
                    }
                }
            });
        }

        public ResourceLocation getFabricId() {
            return DataObjectRegistry.this.registryId;
        }
    }

    public static class Builder<T extends DataObject<T>> {
        private final ResourceLocation registryId;
        private final Class<T> objectClass;
        private String factoryFieldName = "type";
        private boolean autoSync = false;
        private DataObjectFactory<T> defaultFactory;
        private Function<JsonElement, JsonElement> jsonPreprocessor;
        private String dataFolder;
        private boolean readFromData = false;
        private boolean useLoadingPriority;
        private BiConsumer<ResourceLocation, Exception> errorHandler;

        public Builder(ResourceLocation registryId, Class<T> objectClass) {
            this.registryId = registryId;
            this.objectClass = objectClass;
            if (REGISTRIES.containsKey(registryId)) {
                throw new IllegalArgumentException("A data object registry with id \"" + registryId + "\" already exists.");
            }
        }

        public Builder<T> autoSync() {
            this.autoSync = true;
            return this;
        }

        public Builder<T> defaultFactory(DataObjectFactory<T> factory) {
            this.defaultFactory = factory;
            return this;
        }

        public Builder<T> jsonPreprocessor(Function<JsonElement, JsonElement> nonJsonObjectHandler) {
            this.jsonPreprocessor = nonJsonObjectHandler;
            return this;
        }

        public Builder<T> factoryFieldName(String factoryFieldName) {
            this.factoryFieldName = factoryFieldName;
            return this;
        }

        public Builder<T> readFromData(String dataFolder, boolean useLoadingPriority) {
            this.readFromData = true;
            this.dataFolder = dataFolder;
            this.useLoadingPriority = useLoadingPriority;
            return this;
        }

        public Builder<T> dataErrorHandler(BiConsumer<ResourceLocation, Exception> handler) {
            this.errorHandler = handler;
            return this;
        }

        public DataObjectRegistry<T> buildAndRegister() {
            DataObjectRegistry<T> registry = this.readFromData ? new DataObjectRegistry<T>(this.registryId, this.objectClass, this.factoryFieldName, this.defaultFactory, this.jsonPreprocessor, this.dataFolder, this.useLoadingPriority, this.errorHandler) : new DataObjectRegistry<T>(this.registryId, this.objectClass, this.factoryFieldName, this.defaultFactory, this.jsonPreprocessor);
            REGISTRIES.put(this.registryId, registry);
            if (this.autoSync) {
                AUTO_SYNC_SET.add(this.registryId);
            }
            return registry;
        }
    }
}

