/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class CodeTriggerCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final CodeTriggerCriterion INSTANCE = new CodeTriggerCriterion();
    public static final ResourceLocation ID = new ResourceLocation("apacelib", "code_trigger");

    @NotNull
    public ResourceLocation m_7295_() {
        return ID;
    }

    @NotNull
    protected Conditions createInstance(JsonObject jsonObject, @NotNull EntityPredicate.Composite extended, @NotNull DeserializationContext context) {
        String triggerId = "empty";
        if (jsonObject.has("trigger_id")) {
            triggerId = jsonObject.get("trigger_id").getAsString();
        }
        return new Conditions(extended, triggerId);
    }

    public void trigger(ServerPlayer player, String triggeredId) {
        this.m_66234_(player, conditions -> conditions.matches(triggeredId));
    }

    public static class Conditions
    extends AbstractCriterionTriggerInstance {
        private final String triggerId;

        public Conditions(EntityPredicate.Composite player, String triggerId) {
            super(ID, player);
            this.triggerId = triggerId;
        }

        public static Conditions trigger(String triggerId) {
            return new Conditions(EntityPredicate.Composite.f_36667_, triggerId);
        }

        public boolean matches(String triggered) {
            return this.triggerId.equals(triggered);
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext context) {
            JsonObject jsonObject = super.m_7683_(context);
            jsonObject.add("trigger_id", (JsonElement)new JsonPrimitive(this.triggerId));
            return jsonObject;
        }
    }
}

