/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.google.common.collect.Lists;
import io.github.apace100.apoli.access.PowerCraftingInventory;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyCraftingPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyCraftingConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRecipeSerializers;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public class ModifiedCraftingRecipe
extends CustomRecipe {
    public ModifiedCraftingRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        Player player = ModifiedCraftingRecipe.getCraftingPlayer(inv);
        Optional<CraftingRecipe> original = this.getOriginalMatch(inv, player);
        if (original.isEmpty()) {
            return false;
        }
        return this.getRecipes(player).stream().anyMatch(r -> ((ModifyCraftingConfiguration)r.getConfiguration()).doesApply(inv, (Recipe<? super CraftingContainer>)((Recipe)original.get()), world));
    }

    private static Player getCraftingPlayer(@NotNull CraftingContainer inv) {
        Player player = ForgeHooks.getCraftingPlayer();
        if (player != null) {
            return player;
        }
        return ModifiedCraftingRecipe.getPlayerFromInventory(inv);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv) {
        Optional<ConfiguredPower> optional;
        Optional<CraftingRecipe> original;
        Player player = ModifiedCraftingRecipe.getCraftingPlayer(inv);
        if (player != null && (original = this.getOriginalMatch(inv, player)).isPresent() && (optional = this.getRecipes(player).stream().filter(r -> ((ModifyCraftingConfiguration)r.getConfiguration()).doesApply(inv, (Recipe<? super CraftingContainer>)((Recipe)original.get()), player.f_19853_)).findFirst()).isPresent()) {
            ItemStack result = ((ModifyCraftingConfiguration)optional.get().getConfiguration()).createResult(inv, (Recipe<? super CraftingContainer>)((Recipe)original.get()), player.f_19853_);
            ((PowerCraftingInventory)inv).setPower(optional.get());
            return result;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ApoliRecipeSerializers.MODIFIED.get();
    }

    public static Player getPlayerFromInventory(CraftingContainer inv) {
        AbstractContainerMenu handler = inv.f_39323_;
        return ModifiedCraftingRecipe.getPlayerFromHandler(handler);
    }

    public static Optional<BlockPos> getBlockFromInventory(CraftingContainer inv) {
        AbstractContainerMenu handler = inv.f_39323_;
        if (handler instanceof CraftingMenu) {
            CraftingMenu menu = (CraftingMenu)handler;
            return menu.f_39350_.m_6721_((world, blockPos) -> blockPos);
        }
        return Optional.empty();
    }

    private List<ConfiguredPower<ModifyCraftingConfiguration, ModifyCraftingPower>> getRecipes(Player player) {
        if (player != null) {
            return IPowerContainer.getPowers((Entity)player, (ModifyCraftingPower)((Object)ApoliPowers.MODIFY_CRAFTING.get()));
        }
        return Lists.newArrayList();
    }

    private Optional<CraftingRecipe> getOriginalMatch(CraftingContainer inv, Player player) {
        if (player != null && player.m_20194_() != null) {
            List recipes = player.m_20194_().m_129894_().m_44013_(RecipeType.f_44107_);
            return recipes.stream().filter(cr -> !(cr instanceof ModifiedCraftingRecipe) && cr.m_5818_((Container)inv, player.f_19853_)).findFirst();
        }
        return Optional.empty();
    }

    private static Player getPlayerFromHandler(AbstractContainerMenu screenHandler) {
        if (screenHandler instanceof CraftingMenu) {
            CraftingMenu menu = (CraftingMenu)screenHandler;
            return menu.f_39351_;
        }
        if (screenHandler instanceof InventoryMenu) {
            InventoryMenu menu = (InventoryMenu)screenHandler;
            return menu.f_39703_;
        }
        return null;
    }
}

