/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action.block;

import io.github.apace100.apoli.action.configuration.ModifyBlockStateConfiguration;
import io.github.apace100.apoli.util.ResourceOperation;
import io.github.edwinmindcraft.apoli.api.power.factory.BlockAction;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ModifyBlockStateAction
extends BlockAction<ModifyBlockStateConfiguration> {
    public ModifyBlockStateAction() {
        super(ModifyBlockStateConfiguration.CODEC);
    }

    @Override
    public void execute(@NotNull ModifyBlockStateConfiguration configuration, @NotNull Level world, @NotNull BlockPos pos, @NotNull Direction direction) {
        BlockState state = world.m_8055_(pos);
        Collection properties = state.m_61147_();
        String desiredPropertyName = configuration.property();
        Property property = null;
        for (Property p : properties) {
            if (!p.m_61708_().equals(desiredPropertyName)) continue;
            property = p;
            break;
        }
        if (property != null) {
            if (configuration.cycle()) {
                world.m_46597_(pos, (BlockState)state.m_61122_(property));
            } else {
                Comparable value = state.m_61143_(property);
                if (configuration.enumValue() != null && value instanceof Enum) {
                    ModifyBlockStateAction.modifyEnumState(world, pos, state, property, configuration.enumValue());
                } else if (configuration.value() != null && value instanceof Boolean) {
                    world.m_46597_(pos, (BlockState)state.m_61124_(property, (Comparable)configuration.value()));
                } else if (configuration.change() != null && value instanceof Integer) {
                    ResourceOperation op = configuration.operation();
                    int opValue = configuration.change();
                    int newValue = (Integer)value;
                    switch (op) {
                        case ADD: {
                            newValue += opValue;
                            break;
                        }
                        case SET: {
                            newValue = opValue;
                        }
                    }
                    Property integerProperty = property;
                    if (integerProperty.m_6908_().contains(newValue)) {
                        world.m_46597_(pos, (BlockState)state.m_61124_(integerProperty, (Comparable)Integer.valueOf(newValue)));
                    }
                }
            }
        }
    }

    private static <T extends Comparable<T>> void modifyEnumState(Level world, BlockPos pos, BlockState originalState, Property<T> property, String value) {
        Optional enumValue = property.m_6215_(value);
        enumValue.ifPresent(v -> world.m_46597_(pos, (BlockState)originalState.m_61124_(property, v)));
    }
}

