/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.HiddenEffectStatus;
import io.github.apace100.apoli.access.ModifiableFoodEntity;
import io.github.apace100.apoli.util.StackPowerUtil;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.configuration.FieldConfiguration;
import io.github.edwinmindcraft.apoli.api.configuration.TagConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.ApoliCommon;
import io.github.edwinmindcraft.apoli.common.network.S2CSyncAttacker;
import io.github.edwinmindcraft.apoli.common.power.BiEntityConditionPower;
import io.github.edwinmindcraft.apoli.common.power.DummyPower;
import io.github.edwinmindcraft.apoli.common.power.EntityGroupPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyFallingPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyFoodPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyStatusEffectPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyValuePower;
import io.github.edwinmindcraft.apoli.common.power.WalkOnFluidPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyFoodConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements ModifiableFoodEntity {
    @Unique
    private boolean prevPowderSnowState = false;
    @Shadow
    public float f_20887_;
    @Unique
    private List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> apoli$currentModifyFoodPowers = new LinkedList<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>>();
    @Unique
    private ItemStack apoli$originalFoodStack;
    @Unique
    private boolean apoli$shouldSyncFoodData = false;

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @ModifyVariable(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at=@At(value="HEAD"), argsOnly=true)
    private MobEffectInstance modifyStatusEffect(MobEffectInstance effect) {
        MobEffect effectType = effect.m_19544_();
        int originalAmp = effect.m_19564_();
        int originalDur = effect.m_19557_();
        int amplifier = Math.round(IPowerContainer.modify(this, (ModifyStatusEffectPower)ApoliPowers.MODIFY_STATUS_EFFECT_AMPLIFIER.get(), originalAmp, power -> ModifyStatusEffectPower.doesApply(power, effectType)));
        int duration = Math.round(IPowerContainer.modify(this, (ModifyStatusEffectPower)ApoliPowers.MODIFY_STATUS_EFFECT_DURATION.get(), originalDur, power -> ModifyStatusEffectPower.doesApply(power, effectType)));
        if (amplifier != originalAmp || duration != originalDur) {
            return new MobEffectInstance(effectType, duration, amplifier, effect.m_19571_(), effect.m_19572_(), effect.m_19575_(), ((HiddenEffectStatus)effect).getHiddenEffect());
        }
        return effect;
    }

    @Inject(method={"setLastHurtByMob"}, at={@At(value="TAIL")})
    private void syncAttacker(LivingEntity attacker, CallbackInfo ci) {
        if (!this.f_19853_.m_5776_()) {
            ApoliCommon.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new S2CSyncAttacker(this.m_142049_(), attacker != null ? OptionalInt.of(attacker.m_142049_()) : OptionalInt.empty()));
        }
    }

    @Inject(method={"collectEquipmentChanges"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeMap;removeAttributeModifiers(Lcom/google/common/collect/Multimap;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void removeEquipmentPowers(CallbackInfoReturnable<Map<EquipmentSlot, ItemStack>> cir, Map<EquipmentSlot, ItemStack> map, EquipmentSlot[] var2, int var3, int var4, EquipmentSlot equipmentSlot, ItemStack itemStack3, ItemStack itemStack4) {
        List<StackPowerUtil.StackPower> powers = StackPowerUtil.getPowers(itemStack3, equipmentSlot);
        if (powers.size() > 0) {
            ResourceLocation source = new ResourceLocation("apoli", equipmentSlot.m_20751_());
            IPowerContainer.get(this).ifPresent(container -> {
                powers.forEach(sp -> container.removePower(sp.powerId, source));
                container.sync();
            });
        }
    }

    @Inject(method={"collectEquipmentChanges"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeMap;addTransientAttributeModifiers(Lcom/google/common/collect/Multimap;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void addEquipmentPowers(CallbackInfoReturnable<Map<EquipmentSlot, ItemStack>> cir, Map<EquipmentSlot, ItemStack> map, EquipmentSlot[] var2, int var3, int var4, EquipmentSlot equipmentSlot, ItemStack itemStack3, ItemStack itemStack4) {
        List<StackPowerUtil.StackPower> powers = StackPowerUtil.getPowers(itemStack4, equipmentSlot);
        if (powers.size() > 0) {
            ResourceLocation source = new ResourceLocation("apoli", equipmentSlot.m_20751_());
            IPowerContainer.get(this).ifPresent(container -> {
                powers.forEach(sp -> container.addPower(sp.powerId, source));
                container.sync();
            });
        } else if (StackPowerUtil.getPowers(itemStack3, equipmentSlot).size() > 0) {
            IPowerContainer.sync(this);
        }
    }

    @Inject(method={"canStandOnFluid"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyWalkableFluids(FluidState fluid, CallbackInfoReturnable<Boolean> cir) {
        if (IPowerContainer.getPowers(this, (WalkOnFluidPower)((Object)ApoliPowers.WALK_ON_FLUID.get())).stream().anyMatch(p -> fluid.m_205070_(((TagConfiguration)p.getConfiguration()).value()))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Redirect(method={"baseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWaterRainOrBubble()Z"))
    private boolean preventExtinguishingFromSwimming(LivingEntity livingEntity) {
        if (IPowerContainer.hasPower((Entity)livingEntity, (DummyPower)((Object)ApoliPowers.SWIMMING.get())) && livingEntity.m_6069_() && this.m_204036_(FluidTags.f_13131_) <= 0.0) {
            return false;
        }
        return livingEntity.m_20071_();
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getTicksFrozen()I")})
    private void freezeEntityFromPower(CallbackInfo ci) {
        if (IPowerContainer.hasPower(this, (DummyPower)((Object)ApoliPowers.FREEZE.get()))) {
            this.prevPowderSnowState = this.f_146808_;
            this.f_146808_ = true;
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;removeFrost()V")})
    private void unfreezeEntityFromPower(CallbackInfo ci) {
        if (IPowerContainer.hasPower(this, (DummyPower)((Object)ApoliPowers.FREEZE.get()))) {
            this.f_146808_ = this.prevPowderSnowState;
        }
    }

    @Inject(method={"canFreeze"}, at={@At(value="RETURN")}, cancellable=true)
    private void allowFreezingPower(CallbackInfoReturnable<Boolean> cir) {
        if (IPowerContainer.hasPower(this, (DummyPower)((Object)ApoliPowers.FREEZE.get()))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getMobType"}, cancellable=true)
    public void getGroup(CallbackInfoReturnable<MobType> info) {
        List powers = IPowerContainer.getPowers(this, (EntityGroupPower)((Object)ApoliPowers.ENTITY_GROUP.get()));
        if (powers.size() > 0) {
            if (powers.size() > 1) {
                Apoli.LOGGER.warn("Entity " + this.m_5446_() + " has two instances of SetEntityGroupPower.");
            }
            info.setReturnValue((Object)((MobType)((FieldConfiguration)powers.get(0).getConfiguration()).value()));
        }
    }

    @Inject(method={"doPush"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventPushing(Entity entity, CallbackInfo ci) {
        if (BiEntityConditionPower.any((BiEntityConditionPower)((Object)ApoliPowers.PREVENT_ENTITY_COLLISION.get()), this, this, entity) || BiEntityConditionPower.any((BiEntityConditionPower)((Object)ApoliPowers.PREVENT_ENTITY_COLLISION.get()), entity, entity, this)) {
            ci.cancel();
        }
    }

    @Inject(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeInstance;getValue()D", ordinal=0)})
    public void modifyFall(Vec3 motion, CallbackInfo ci) {
        ModifyFallingPower.apply(this, this.m_20184_().f_82480_ <= 0.0);
    }

    @ModifyVariable(method={"eat"}, at=@At(value="HEAD"), argsOnly=true)
    private ItemStack modifyEatenItemStack(ItemStack original) {
        if (this instanceof Player) {
            return original;
        }
        List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> mfps = ModifyFoodPower.getValidPowers(this, original);
        MutableObject stack = new MutableObject((Object)original.m_41777_());
        ModifyFoodPower.modifyStack(mfps, this.f_19853_, (Mutable<ItemStack>)stack);
        this.setCurrentModifyFoodPowers(mfps);
        this.setOriginalFoodStack(original);
        return (ItemStack)stack.getValue();
    }

    @ModifyVariable(method={"eat"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;addEatEffect(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V", shift=At.Shift.AFTER), argsOnly=true)
    private ItemStack unmodifyEatenItemStack(ItemStack modified) {
        LivingEntityMixin foodEntity = this;
        ItemStack original = foodEntity.getOriginalFoodStack();
        if (original != null) {
            foodEntity.setOriginalFoodStack(null);
            return original;
        }
        return modified;
    }

    @Inject(method={"eat"}, at={@At(value="TAIL")})
    private void removeCurrentModifyFoodPowers(Level world, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        this.setCurrentModifyFoodPowers(new LinkedList<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>>());
    }

    @Redirect(method={"eat"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;addEatEffect(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V"))
    private void preventApplyingFoodEffects(LivingEntity livingEntity, ItemStack stack, Level world, LivingEntity targetEntity) {
        if (this.getCurrentModifyFoodPowers().stream().anyMatch(x -> ((ModifyFoodConfiguration)x.getConfiguration()).preventEffects())) {
            return;
        }
        this.m_21063_(stack, world, targetEntity);
    }

    @Shadow
    protected abstract void m_21063_(ItemStack var1, Level var2, LivingEntity var3);

    @Inject(method={"getFrictionInfluencedSpeed(F)F"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyFlySpeed(float slipperiness, CallbackInfoReturnable<Float> cir) {
        if (!this.f_19861_) {
            cir.setReturnValue((Object)Float.valueOf(IPowerContainer.modify((Entity)this, (ModifyValuePower)ApoliPowers.MODIFY_AIR_SPEED.get(), this.f_20887_)));
        }
    }

    @Override
    public List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> getCurrentModifyFoodPowers() {
        return this.apoli$currentModifyFoodPowers;
    }

    @Override
    public void setCurrentModifyFoodPowers(List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> powers) {
        this.apoli$currentModifyFoodPowers = powers;
    }

    @Override
    public ItemStack getOriginalFoodStack() {
        return this.apoli$originalFoodStack;
    }

    @Override
    public void setOriginalFoodStack(ItemStack original) {
        this.apoli$originalFoodStack = original;
    }

    @Override
    public void enforceFoodSync() {
        this.apoli$shouldSyncFoodData = true;
    }

    @Override
    public void resetFoodSync() {
        this.apoli$shouldSyncFoodData = false;
    }

    @Override
    public boolean shouldSyncFood() {
        return this.apoli$shouldSyncFoodData;
    }
}

