/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.MovingEntity;
import io.github.apace100.apoli.access.SubmergableEntity;
import io.github.apace100.apoli.access.WaterMovingEntity;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.common.power.DummyPower;
import io.github.edwinmindcraft.apoli.common.power.InvisibilityPower;
import io.github.edwinmindcraft.apoli.common.power.PhasingPower;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements MovingEntity,
SubmergableEntity {
    @Shadow
    public Level f_19853_;
    @Shadow
    public float f_19788_;
    @Shadow
    protected Object2DoubleMap<TagKey<Fluid>> f_19799_;
    private boolean isMoving;
    private float distanceBefore;
    @Shadow
    protected boolean f_19861_;
    @Final
    @Shadow
    private Set<TagKey<Fluid>> f_19801_;

    @Inject(method={"fireImmune"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeFullyFireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (IPowerContainer.hasPower((Entity)this, (DummyPower)((Object)ApoliPowers.FIRE_IMMUNITY.get()))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Shadow
    public abstract double m_204036_(TagKey<Fluid> var1);

    @Inject(method={"isInWater"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeEntitiesIgnoreWater(CallbackInfoReturnable<Boolean> cir) {
        if (IPowerContainer.hasPower((Entity)this, (DummyPower)((Object)ApoliPowers.IGNORE_WATER.get())) && this instanceof WaterMovingEntity && ((WaterMovingEntity)((Object)this)).isInMovementPhase()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isInWaterRainOrBubble()Z"))
    private boolean preventExtinguishingFromSwimming(Entity entity) {
        if (IPowerContainer.hasPower(entity, (DummyPower)((Object)ApoliPowers.SWIMMING.get())) && entity.m_6069_() && !(this.m_204036_((TagKey<Fluid>)FluidTags.f_13131_) > 0.0)) {
            return false;
        }
        return entity.m_20071_();
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvisible"}, cancellable=true)
    private void phantomInvisibility(CallbackInfoReturnable<Boolean> info) {
        if (IPowerContainer.hasPower((Entity)this, (InvisibilityPower)((Object)ApoliPowers.INVISIBILITY.get()))) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"moveTowardsClosestSpace"}, cancellable=true)
    protected void pushOutOfBlocks(double x, double y, double z, CallbackInfo info) {
        if (PhasingPower.shouldPhaseThrough((Entity)this, new BlockPos(x, y, z))) {
            info.cancel();
        }
    }

    @Inject(method={"move"}, at={@At(value="HEAD")})
    private void saveDistanceTraveled(MoverType type, Vec3 movement, CallbackInfo ci) {
        this.isMoving = false;
        this.distanceBefore = this.f_19788_;
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V")})
    private void checkIsMoving(MoverType type, Vec3 movement, CallbackInfo ci) {
        if (this.f_19788_ > this.distanceBefore) {
            this.isMoving = true;
        }
    }

    @Override
    public boolean isSubmergedInLoosely(TagKey<Fluid> tag) {
        if (tag == null || this.f_19801_ == null) {
            return false;
        }
        return this.f_19801_.contains(tag);
    }

    @Override
    public double getFluidHeightLoosely(TagKey<Fluid> tag) {
        if (tag == null) {
            return 0.0;
        }
        if (this.f_19799_.containsKey(tag)) {
            return this.f_19799_.getDouble(tag);
        }
        for (TagKey ft : this.f_19799_.keySet()) {
            if (!ft.equals(tag)) continue;
            return this.f_19799_.getDouble((Object)ft);
        }
        return 0.0;
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }
}

