/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.edwinmindcraft.apoli.common.power.PhasingPower;
import io.github.edwinmindcraft.apoli.common.power.PreventBlockActionPower;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class AbstractBlockStateMixin {
    @Shadow
    public abstract Block m_60734_();

    @Shadow
    @NotNull
    protected abstract BlockState m_7160_();

    @Inject(at={@At(value="HEAD")}, method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, cancellable=true)
    private void phaseThroughBlocks(BlockGetter world, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> info) {
        EntityCollisionContext esc;
        VoxelShape blockShape = this.m_60734_().m_5939_(this.m_7160_(), world, pos, context);
        if (!blockShape.m_83281_() && context instanceof EntityCollisionContext && (esc = (EntityCollisionContext)context).m_193113_() != null) {
            Entity entity = esc.m_193113_();
            boolean isAbove = this.isAbove(entity, blockShape, pos, false);
            if (world instanceof LevelReader) {
                LivingEntity living;
                LevelReader reader = (LevelReader)world;
                if (entity instanceof LivingEntity && PhasingPower.shouldPhaseThrough((Entity)(living = (LivingEntity)entity), reader, pos, (NonNullSupplier<BlockState>)((NonNullSupplier)this::m_7160_), isAbove)) {
                    info.setReturnValue((Object)Shapes.m_83040_());
                }
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, cancellable=true)
    private void modifyBlockOutline(BlockGetter world, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        Entity entity;
        EntityCollisionContext ctx;
        if (context instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)context).m_193113_() != null && PreventBlockActionPower.isSelectionPrevented(entity = ctx.m_193113_(), pos, (NonNullSupplier<BlockState>)((NonNullSupplier)this::m_7160_))) {
            cir.setReturnValue((Object)Shapes.m_83040_());
        }
    }

    @Unique
    private boolean isAbove(Entity entity, VoxelShape shape, BlockPos pos, boolean defaultValue) {
        return entity.m_20186_() > (double)pos.m_123342_() + shape.m_83297_(Direction.Axis.Y) - (entity.m_20096_() ? 0.503125 : 0.0015);
    }

    @Inject(method={"entityInside"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventCollisionWhenPhasing(Level world, BlockPos pos, Entity entity, CallbackInfo ci) {
        LivingEntity living;
        if (entity instanceof LivingEntity && PhasingPower.shouldPhaseThrough((Entity)(living = (LivingEntity)entity), pos)) {
            ci.cancel();
        }
    }
}

