/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.command;

import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.command.EntityConditionArgument;
import io.github.apace100.apoli.command.PowerSourceArgumentType;
import io.github.apace100.apoli.command.PowerTypeArgumentType;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.LazyOptional;

public class PowerCommand {
    public static final ResourceLocation COMMAND_POWER_SOURCE = Apoli.identifier("command");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"power").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"grant").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(command -> {
            int i = 0;
            try {
                Collection targets = EntityArgument.m_91461_((CommandContext)command, (String)"targets");
                ResourceLocation power = (ResourceLocation)command.getArgument("power", ResourceLocation.class);
                for (Entity target : targets) {
                    if (!(target instanceof LivingEntity) || !PowerCommand.grantPower((LivingEntity)target, power)) continue;
                    ++i;
                }
                if (i == 0) {
                    if (targets.size() == 1) {
                        ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.grant.fail.single", new Object[]{((Entity)targets.iterator().next()).m_5446_(), power, COMMAND_POWER_SOURCE}));
                    } else {
                        ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.grant.fail.multiple", new Object[]{targets.size(), power, COMMAND_POWER_SOURCE}));
                    }
                } else if (targets.size() == 1 && i == 1) {
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.grant.success.single", new Object[]{((Entity)targets.iterator().next()).m_5446_(), power}), true);
                } else {
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.grant.success.multiple", new Object[]{i, power}), true);
                }
            }
            catch (Exception e) {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)new TextComponent(e.getMessage()));
            }
            return i;
        })).then(Commands.m_82129_((String)"source", (ArgumentType)PowerSourceArgumentType.powerSource("targets")).executes(command -> {
            int i = 0;
            try {
                Collection targets = EntityArgument.m_91461_((CommandContext)command, (String)"targets");
                ResourceLocation power = (ResourceLocation)command.getArgument("power", ResourceLocation.class);
                ResourceLocation source = ResourceLocationArgument.m_107011_((CommandContext)command, (String)"source");
                for (Entity target : targets) {
                    if (!(target instanceof LivingEntity) || !PowerCommand.grantPower((LivingEntity)target, power, source)) continue;
                    ++i;
                }
                if (i == 0) {
                    if (targets.size() == 1) {
                        ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.grant.fail.single", new Object[]{((Entity)targets.iterator().next()).m_5446_(), power, source}));
                    } else {
                        ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.grant.fail.multiple", new Object[]{targets.size(), power, source}));
                    }
                } else if (targets.size() == 1 && i == 1) {
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.grant_from_source.success.single", new Object[]{((Entity)targets.iterator().next()).m_5446_(), power, source}), true);
                } else {
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.grant_from_source.success.multiple", new Object[]{i, power, source}), true);
                }
            }
            catch (Exception e) {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)new TextComponent(e.getMessage()));
            }
            return i;
        })))))).then(Commands.m_82127_((String)"revoke").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(command -> {
            int i = 0;
            Collection targets = EntityArgument.m_91461_((CommandContext)command, (String)"targets");
            ResourceLocation power = (ResourceLocation)command.getArgument("power", ResourceLocation.class);
            try {
                for (Entity target : targets) {
                    if (!(target instanceof LivingEntity) || !PowerCommand.revokePower((LivingEntity)target, power)) continue;
                    ++i;
                }
                if (i == 0) {
                    if (targets.size() == 1) {
                        ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.revoke.fail.single", new Object[]{((Entity)targets.iterator().next()).m_5446_(), power, COMMAND_POWER_SOURCE}));
                    } else {
                        ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.revoke.fail.multiple", new Object[]{power, COMMAND_POWER_SOURCE}));
                    }
                } else if (targets.size() == 1) {
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.revoke.success.single", new Object[]{((Entity)targets.iterator().next()).m_5446_(), power}), false);
                } else {
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.revoke.success.multiple", new Object[]{i, power}), false);
                }
            }
            catch (Exception e) {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)new TextComponent(e.getMessage()));
            }
            return i;
        })).then(Commands.m_82129_((String)"source", (ArgumentType)PowerSourceArgumentType.powerSource("targets")).executes(command -> {
            int i = 0;
            Collection targets = EntityArgument.m_91461_((CommandContext)command, (String)"targets");
            ResourceLocation power = (ResourceLocation)command.getArgument("power", ResourceLocation.class);
            ResourceLocation source = ResourceLocationArgument.m_107011_((CommandContext)command, (String)"source");
            try {
                for (Entity target : targets) {
                    if (!(target instanceof LivingEntity) || !PowerCommand.revokePower((LivingEntity)target, power, source)) continue;
                    ++i;
                }
                if (i == 0) {
                    if (targets.size() == 1) {
                        ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.revoke.fail.single", new Object[]{((Entity)targets.iterator().next()).m_5446_(), power, source}));
                    } else {
                        ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.revoke.fail.multiple", new Object[]{power, source}));
                    }
                } else if (targets.size() == 1) {
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.revoke_from_source.success.single", new Object[]{((Entity)targets.iterator().next()).m_5446_(), power, source}), false);
                } else {
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.revoke_from_source.success.multiple", new Object[]{i, power, source}), false);
                }
            }
            catch (Exception e) {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)new TextComponent(e.getMessage()));
            }
            return i;
        })))))).then(Commands.m_82127_((String)"revokeall").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"source", (ArgumentType)PowerSourceArgumentType.powerSource("targets")).executes(command -> {
            int i = 0;
            Collection targets = EntityArgument.m_91461_((CommandContext)command, (String)"targets");
            ResourceLocation source = ResourceLocationArgument.m_107011_((CommandContext)command, (String)"source");
            try {
                for (Entity target : targets) {
                    if (!(target instanceof LivingEntity)) continue;
                    i += PowerCommand.revokeAllPowersFromSource((LivingEntity)target, source);
                }
                if (i == 0) {
                    if (targets.size() == 1) {
                        ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.revoke_all.fail.single", new Object[]{((Entity)targets.iterator().next()).m_5446_(), source}));
                    } else {
                        ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.revoke_all.fail.multiple", new Object[]{source}));
                    }
                } else if (targets.size() == 1) {
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.revoke_all.success.single", new Object[]{((Entity)targets.iterator().next()).m_5446_(), i, source}), false);
                } else {
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.revoke_all.success.multiple", new Object[]{targets.size(), i, source}), false);
                }
            }
            catch (Exception e) {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)new TextComponent(e.getMessage()));
            }
            return i;
        }))))).then(Commands.m_82127_((String)"list").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(command -> {
            int i = 0;
            Entity target = EntityArgument.m_91452_((CommandContext)command, (String)"target");
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                LazyOptional<IPowerContainer> componentOptional = IPowerContainer.get((Entity)living);
                if (!componentOptional.isPresent()) {
                    ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.list.fail"));
                } else {
                    IPowerContainer component = (IPowerContainer)componentOptional.orElseThrow(RuntimeException::new);
                    StringBuilder powers = new StringBuilder();
                    for (ResourceLocation powerType : component.getPowerTypes(false)) {
                        if (i > 0) {
                            powers.append(", ");
                        }
                        powers.append(powerType.toString());
                        ++i;
                    }
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.list.pass", new Object[]{i, powers}), false);
                }
            } else {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.list.fail"));
            }
            return i;
        })).then(Commands.m_82129_((String)"subpowers", (ArgumentType)BoolArgumentType.bool()).executes(command -> {
            int i = 0;
            Entity target = EntityArgument.m_91452_((CommandContext)command, (String)"target");
            boolean listSubpowers = BoolArgumentType.getBool((CommandContext)command, (String)"subpowers");
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                LazyOptional<IPowerContainer> componentOptional = IPowerContainer.get((Entity)living);
                if (!componentOptional.isPresent()) {
                    ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.list.fail"));
                } else {
                    IPowerContainer component = (IPowerContainer)componentOptional.orElseThrow(RuntimeException::new);
                    StringBuilder powers = new StringBuilder();
                    for (ResourceLocation powerType : component.getPowerTypes(listSubpowers)) {
                        if (i > 0) {
                            powers.append(", ");
                        }
                        powers.append(powerType.toString());
                        ++i;
                    }
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.list.pass", new Object[]{i, powers}), false);
                }
            } else {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.list.fail"));
            }
            return i;
        }))))).then(Commands.m_82127_((String)"has").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(command -> {
            int i = 0;
            Collection targets = EntityArgument.m_91461_((CommandContext)command, (String)"targets");
            ResourceLocation power = (ResourceLocation)command.getArgument("power", ResourceLocation.class);
            for (Entity target : targets) {
                if (!(target instanceof LivingEntity) || !PowerCommand.hasPower((LivingEntity)target, power)) continue;
                ++i;
            }
            if (i == 0) {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.execute.conditional.fail"));
            } else if (targets.size() == 1) {
                ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.execute.conditional.pass"), false);
            } else {
                ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.execute.conditional.pass_count", new Object[]{i}), false);
            }
            return i;
        }))))).then(Commands.m_82127_((String)"sources").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(command -> {
            int i = 0;
            Entity target = EntityArgument.m_91452_((CommandContext)command, (String)"target");
            ResourceLocation power = (ResourceLocation)command.getArgument("power", ResourceLocation.class);
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                LazyOptional<IPowerContainer> componentOptional = IPowerContainer.get((Entity)living);
                if (!componentOptional.isPresent()) {
                    ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.sources.fail", new Object[]{target.m_5446_(), power}));
                } else {
                    IPowerContainer component = (IPowerContainer)componentOptional.orElseThrow(RuntimeException::new);
                    StringBuilder sources = new StringBuilder();
                    for (ResourceLocation source : component.getSources(power)) {
                        if (i > 0) {
                            sources.append(", ");
                        }
                        sources.append(source.toString());
                        ++i;
                    }
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.sources.pass", new Object[]{target.m_5446_(), i, power, sources}), false);
                }
            } else {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.sources.fail", new Object[]{target.m_5446_(), power}));
            }
            return i;
        }))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(command -> {
            int i = 0;
            Collection targets = EntityArgument.m_91461_((CommandContext)command, (String)"targets");
            ResourceLocation power = (ResourceLocation)command.getArgument("power", ResourceLocation.class);
            try {
                for (Entity target : targets) {
                    if (!(target instanceof LivingEntity) || !PowerCommand.revokePowerAllSources((LivingEntity)target, power)) continue;
                    ++i;
                }
                if (i == 0) {
                    if (targets.size() == 1) {
                        ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.remove.fail.single", new Object[]{((Entity)targets.iterator().next()).m_5446_(), power}));
                    } else {
                        ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.remove.fail.multiple", new Object[]{power}));
                    }
                } else if (targets.size() == 1) {
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.remove.success.single", new Object[]{((Entity)targets.iterator().next()).m_5446_(), power}), false);
                } else {
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.remove.success.multiple", new Object[]{i, power}), false);
                }
            }
            catch (Exception e) {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)new TextComponent(e.getMessage()));
            }
            return i;
        }))))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(command -> {
            int i = 0;
            Collection targets = EntityArgument.m_91461_((CommandContext)command, (String)"targets");
            try {
                for (Entity target : targets) {
                    if (!(target instanceof LivingEntity)) continue;
                    i += PowerCommand.revokeAllPowers((LivingEntity)target);
                }
                if (i == 0) {
                    if (targets.size() == 1) {
                        ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.clear.fail.single", new Object[]{((Entity)targets.iterator().next()).m_5446_()}));
                    } else {
                        ((CommandSourceStack)command.getSource()).m_81352_((Component)new TranslatableComponent("commands.apoli.clear.fail.multiple"));
                    }
                } else if (targets.size() == 1) {
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.clear.success.single", new Object[]{((Entity)targets.iterator().next()).m_5446_(), i}), false);
                } else {
                    ((CommandSourceStack)command.getSource()).m_81354_((Component)new TranslatableComponent("commands.apoli.clear.success.multiple", new Object[]{targets.size(), i}), false);
                }
            }
            catch (Exception e) {
                ((CommandSourceStack)command.getSource()).m_81352_((Component)new TextComponent(e.getMessage()));
            }
            return i;
        })))).then(Commands.m_82127_((String)"dump").then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(command -> {
            ConfiguredPower<?, ?> arg = PowerTypeArgumentType.getConfiguredPower((CommandContext<CommandSourceStack>)command, "power");
            String s = (String)ConfiguredPower.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, arg).map(JsonElement::toString).result().orElseThrow(() -> new CommandRuntimeException((Component)new TextComponent("Failed to encode " + arg.getRegistryName())));
            ((CommandSourceStack)command.getSource()).m_81354_((Component)new TextComponent(s), false);
            return 1;
        })))).then(Commands.m_82127_((String)"condition").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"condition_json", (ArgumentType)EntityConditionArgument.entityCondition()).executes(context -> {
            Entity target = EntityArgument.m_91452_((CommandContext)context, (String)"target");
            ConfiguredEntityCondition<?, ?> condition = EntityConditionArgument.getEntityCondition((CommandContext<CommandSourceStack>)context, "condition_json");
            if (condition.check(target)) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Passed"), false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Failed"), false);
            return 0;
        })))));
    }

    private static boolean grantPower(LivingEntity entity, ResourceLocation power) {
        return PowerCommand.grantPower(entity, power, COMMAND_POWER_SOURCE);
    }

    private static boolean grantPower(LivingEntity entity, ResourceLocation power, ResourceLocation source) {
        return IPowerContainer.get((Entity)entity).map(component -> {
            boolean success = component.addPower(power, source);
            if (success) {
                component.sync();
            }
            return success;
        }).orElse(false);
    }

    private static boolean revokePower(LivingEntity entity, ResourceLocation power) {
        return PowerCommand.revokePower(entity, power, COMMAND_POWER_SOURCE);
    }

    private static boolean revokePower(LivingEntity entity, ResourceLocation power, ResourceLocation source) {
        return IPowerContainer.get((Entity)entity).map(component -> {
            if (component.hasPower(power, source)) {
                component.removePower(power, source);
                component.sync();
                return true;
            }
            return false;
        }).orElse(false);
    }

    private static boolean revokePowerAllSources(LivingEntity entity, ResourceLocation power) {
        return IPowerContainer.get((Entity)entity).map(component -> {
            List<ResourceLocation> sources = component.getSources(power);
            for (ResourceLocation source : sources) {
                component.removePower(power, source);
            }
            if (sources.size() > 0) {
                component.sync();
            }
            return true;
        }).orElse(false);
    }

    private static int revokeAllPowers(LivingEntity entity) {
        return IPowerContainer.get((Entity)entity).map(component -> {
            Set<ResourceLocation> powers = component.getPowerTypes(false);
            for (ResourceLocation power : powers) {
                PowerCommand.revokePowerAllSources(entity, power);
            }
            if (powers.size() > 0) {
                component.sync();
            }
            return powers.size();
        }).orElse(0);
    }

    private static int revokeAllPowersFromSource(LivingEntity entity, ResourceLocation source) {
        return IPowerContainer.get((Entity)entity).map(component -> {
            int i = component.removeAllPowersFromSource(source);
            if (i > 0) {
                component.sync();
            }
            return i;
        }).orElse(0);
    }

    private static boolean hasPower(LivingEntity entity, ResourceLocation powerType) {
        return IPowerContainer.get((Entity)entity).map(x -> x.hasPower(powerType)).orElse(false);
    }
}

