/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.core;

import biomesoplenty.api.block.BOPBlockEntities;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.entity.BOPEntities;
import biomesoplenty.client.renderer.BoatRendererBOP;
import biomesoplenty.common.entity.BoatBOP;
import biomesoplenty.core.CommonProxy;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;

public class ClientProxy
extends CommonProxy {
    @Override
    public void registerRenderers() {
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        ItemColors itemColors = Minecraft.m_91087_().getItemColors();
        blockColors.m_92589_((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{BOPBlocks.SPROUT, BOPBlocks.CLOVER, BOPBlocks.HUGE_CLOVER_PETAL, BOPBlocks.WATERGRASS, BOPBlocks.POTTED_SPROUT, BOPBlocks.POTTED_CLOVER});
        blockColors.m_92589_((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{BOPBlocks.BUSH, BOPBlocks.FLOWERING_OAK_LEAVES, BOPBlocks.MAHOGANY_LEAVES, BOPBlocks.PALM_LEAVES, BOPBlocks.WILLOW_LEAVES, BOPBlocks.WILLOW_VINE});
        blockColors.m_92589_((state, world, pos, tintIndex) -> world != null && pos != null ? ClientProxy.getRainbowBirchColor(world, pos) : FoliageColor.m_46113_(), new Block[]{BOPBlocks.RAINBOW_BIRCH_LEAVES});
        itemColors.m_92689_((stack, tintIndex) -> {
            BlockState state = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            return blockColors.m_92577_(state, null, null, tintIndex);
        }, new ItemLike[]{BOPBlocks.SPROUT, BOPBlocks.BUSH, BOPBlocks.CLOVER, BOPBlocks.HUGE_CLOVER_PETAL, BOPBlocks.FLOWERING_OAK_LEAVES, BOPBlocks.MAHOGANY_LEAVES, BOPBlocks.PALM_LEAVES, BOPBlocks.WILLOW_LEAVES, BOPBlocks.WILLOW_VINE});
        BlockEntityRenderers.m_173590_(BOPBlockEntities.SIGN, SignRenderer::new);
        EntityRenderers.m_174036_(BOPEntities.BOAT, BoatRendererBOP::new);
        LayerDefinition boatLayerDefinition = BoatModel.m_170463_();
        for (BoatBOP.ModelType type : BoatBOP.ModelType.values()) {
            ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)BoatRendererBOP.createBoatModelName(type), () -> boatLayerDefinition);
        }
    }

    public static int getRainbowBirchColor(BlockAndTintGetter world, BlockPos pos) {
        float saturation = world.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_144279_) ? 0.25f : 0.5f;
        Color foliage = Color.getHSBColor(((float)pos.m_123341_() + Mth.m_14031_((float)(((float)pos.m_123343_() + (float)pos.m_123341_()) / 35.0f)) * 35.0f) % 150.0f / 150.0f, saturation, 1.0f);
        return foliage.getRGB();
    }
}

