/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.fusion;

import java.util.List;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class FusionReactorCache
extends MultiblockCache<FusionReactorMultiblockData> {
    private double plasmaTemperature = -1.0;
    private int injectionRate = -1;
    private boolean burning;

    private int getInjectionRate() {
        if (this.injectionRate == -1) {
            return 2;
        }
        return this.injectionRate;
    }

    public void merge(MultiblockCache<FusionReactorMultiblockData> mergeCache, List<ItemStack> rejectedItems) {
        super.merge(mergeCache, rejectedItems);
        this.plasmaTemperature = Math.max(this.plasmaTemperature, ((FusionReactorCache)mergeCache).plasmaTemperature);
        this.injectionRate = Math.max(this.injectionRate, ((FusionReactorCache)mergeCache).injectionRate);
        this.burning |= ((FusionReactorCache)mergeCache).burning;
    }

    public void apply(FusionReactorMultiblockData data) {
        super.apply((MultiblockData)data);
        if (this.plasmaTemperature >= 0.0) {
            data.plasmaTemperature = this.plasmaTemperature;
        }
        data.setInjectionRate(this.getInjectionRate());
        data.setBurning(this.burning);
        data.updateTemperatures();
    }

    public void sync(FusionReactorMultiblockData data) {
        super.sync((MultiblockData)data);
        this.plasmaTemperature = data.plasmaTemperature;
        this.injectionRate = data.getInjectionRate();
        this.burning = data.isBurning();
    }

    public void load(CompoundTag nbtTags) {
        super.load(nbtTags);
        this.plasmaTemperature = nbtTags.m_128459_("plasmaTemp");
        this.injectionRate = nbtTags.m_128451_("injectionRate");
        this.burning = nbtTags.m_128471_("burning");
    }

    public void save(CompoundTag nbtTags) {
        super.save(nbtTags);
        nbtTags.m_128347_("plasmaTemp", this.plasmaTemperature);
        nbtTags.m_128405_("injectionRate", this.getInjectionRate());
        nbtTags.m_128379_("burning", this.burning);
    }
}

