/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.data.ChemicalRenderData;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.util.WorldUtils;
import mekanism.generators.client.render.RenderTurbineRotor;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.BlockGetter;

@ParametersAreNonnullByDefault
public class RenderIndustrialTurbine
extends MekanismTileEntityRenderer<TileEntityTurbineCasing> {
    public RenderIndustrialTurbine(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void render(TileEntityTurbineCasing tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        TurbineMultiblockData multiblock;
        if (tile.isMaster() && (multiblock = (TurbineMultiblockData)tile.getMultiblock()).isFormed() && multiblock.complex != null && multiblock.renderLocation != null) {
            int height;
            BlockPos pos = tile.m_58899_();
            BlockPos complexPos = multiblock.complex;
            VertexConsumer buffer = RenderTurbineRotor.INSTANCE.model.getBuffer(renderer);
            profiler.m_6180_("turbineRotor");
            while (true) {
                complexPos = complexPos.m_7495_();
                TileEntityTurbineRotor rotor = (TileEntityTurbineRotor)WorldUtils.getTileEntity(TileEntityTurbineRotor.class, (BlockGetter)tile.m_58904_(), (BlockPos)complexPos);
                if (rotor == null) break;
                matrix.m_85836_();
                matrix.m_85837_((double)(complexPos.m_123341_() - pos.m_123341_()), (double)(complexPos.m_123342_() - pos.m_123342_()), (double)(complexPos.m_123343_() - pos.m_123343_()));
                RenderTurbineRotor.INSTANCE.render(rotor, matrix, buffer, MekanismRenderer.FULL_SKY_LIGHT, overlayLight);
                matrix.m_85849_();
            }
            profiler.m_7238_();
            if (!multiblock.gasTank.isEmpty() && multiblock.length() > 0 && (height = multiblock.lowerVolume / (multiblock.length() * multiblock.width())) >= 1) {
                ChemicalRenderData.GasRenderData data = new ChemicalRenderData.GasRenderData((GasStack)multiblock.gasTank.getStack());
                data.location = multiblock.renderLocation;
                data.height = height;
                data.length = multiblock.length();
                data.width = multiblock.width();
                int glow = data.calculateGlowLight(MekanismRenderer.FULL_SKY_LIGHT);
                matrix.m_85836_();
                matrix.m_85837_((double)(data.location.m_123341_() - pos.m_123341_()), (double)(data.location.m_123342_() - pos.m_123342_()), (double)(data.location.m_123343_() - pos.m_123343_()));
                MekanismRenderer.Model3D gasModel = ModelRenderer.getModel((RenderData)data, (double)1.0);
                MekanismRenderer.renderObject((MekanismRenderer.Model3D)gasModel, (PoseStack)matrix, (VertexConsumer)renderer.m_6299_(Sheets.m_110792_()), (int)data.getColorARGB(multiblock.prevSteamScale), (int)glow, (int)overlayLight, (RenderResizableCuboid.FaceDisplay)this.getFaceDisplay((RenderData)data, gasModel));
                matrix.m_85849_();
            }
        }
    }

    protected String getProfilerSection() {
        return "industrialTurbine";
    }

    public boolean shouldRenderOffScreen(TileEntityTurbineCasing tile) {
        if (tile.isMaster()) {
            TurbineMultiblockData multiblock = (TurbineMultiblockData)tile.getMultiblock();
            return multiblock.isFormed() && multiblock.complex != null && multiblock.renderLocation != null;
        }
        return false;
    }
}

