/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.common.mail;

import com.mrcrayfish.furniture.common.mail.Mail;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;

public class MailBox
implements INBTSerializable<CompoundTag> {
    private UUID id;
    private String name;
    private UUID ownerId;
    private String ownerName;
    private BlockPos pos;
    private ResourceKey<Level> levelResourceKey = Level.f_46428_;
    private List<Mail> mailStorage = new ArrayList<Mail>();

    public MailBox(UUID id, String name, UUID ownerId, String ownerName, BlockPos pos, ResourceKey<Level> levelResourceKey) {
        this.id = id;
        this.name = name;
        this.ownerId = ownerId;
        this.ownerName = ownerName;
        this.pos = pos;
        this.levelResourceKey = levelResourceKey;
    }

    public MailBox(CompoundTag compound) {
        this.deserializeNBT(compound);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ResourceKey<Level> getLevelResourceKey() {
        return this.levelResourceKey;
    }

    public void addMail(Mail mail) {
        this.mailStorage.add(mail);
    }

    public List<Mail> getMailStorage() {
        return this.mailStorage;
    }

    public int getMailCount() {
        return this.mailStorage.size();
    }

    public CompoundTag serializeDetails() {
        CompoundTag compound = new CompoundTag();
        compound.m_128362_("MailBoxUUID", this.id);
        compound.m_128359_("MailBoxName", this.name);
        compound.m_128362_("OwnerUUID", this.ownerId);
        compound.m_128359_("OwnerName", this.ownerName);
        return compound;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128362_("MailBoxUUID", this.id);
        compound.m_128359_("MailBoxName", this.name);
        compound.m_128362_("OwnerUUID", this.ownerId);
        compound.m_128359_("OwnerName", this.ownerName);
        compound.m_128356_("Pos", this.pos.m_121878_());
        compound.m_128359_("World", this.levelResourceKey.m_135782_().toString());
        if (!this.mailStorage.isEmpty()) {
            ListTag mailStorageList = new ListTag();
            this.mailStorage.forEach(mail -> mailStorageList.add((Object)mail.serializeNBT()));
            compound.m_128365_("MailStorage", (Tag)mailStorageList);
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.mailStorage = new ArrayList<Mail>();
        this.id = compound.m_128342_("MailBoxUUID");
        this.name = compound.m_128461_("MailBoxName");
        this.ownerId = compound.m_128342_("OwnerUUID");
        this.ownerName = compound.m_128461_("OwnerName");
        this.pos = BlockPos.m_122022_((long)compound.m_128454_("Pos"));
        this.levelResourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(compound.m_128461_("World")));
        if (compound.m_128425_("MailStorage", 9)) {
            ListTag mailStorageList = compound.m_128437_("MailStorage", 10);
            mailStorageList.forEach(nbt2 -> {
                CompoundTag mailCompound = (CompoundTag)nbt2;
                this.mailStorage.add(new Mail(mailCompound));
            });
        }
    }
}

