/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client.event;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.FurnitureMod;
import com.mrcrayfish.furniture.client.gui.widget.button.IconButton;
import com.mrcrayfish.furniture.client.gui.widget.button.TagButton;
import com.mrcrayfish.furniture.common.ModTags;
import com.mrcrayfish.furniture.core.ModBlocks;
import com.mrcrayfish.furniture.core.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CreativeScreenEvents {
    private static final ResourceLocation ICONS = new ResourceLocation("cfm", "textures/gui/icons.png");
    private static int startIndex;
    private List<TagFilter> filters;
    private List<TagButton> buttons;
    private Button btnScrollUp;
    private Button btnScrollDown;
    private Button btnEnableAll;
    private Button btnDisableAll;
    private boolean viewingFurnitureTab;
    private int guiCenterX = 0;
    private int guiCenterY = 0;

    @SubscribeEvent
    public void onPlayerLogout(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.filters = null;
    }

    @SubscribeEvent
    public void onScreenInit(ScreenEvent.InitScreenEvent.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            if (this.filters == null) {
                this.compileItems();
            }
            this.viewingFurnitureTab = false;
            this.guiCenterX = creativeScreen.getGuiLeft();
            this.guiCenterY = creativeScreen.getGuiTop();
            this.buttons = new ArrayList<TagButton>();
            this.btnScrollUp = new IconButton(this.guiCenterX - 22, this.guiCenterY - 12, (Component)new TranslatableComponent("gui.button.cfm.scroll_filters_up"), button -> {
                if (startIndex > 0) {
                    --startIndex;
                }
                this.updateTagButtons();
            }, ICONS, 64, 0);
            event.addListener((GuiEventListener)this.btnScrollUp);
            this.btnScrollDown = new IconButton(this.guiCenterX - 22, this.guiCenterY + 127, (Component)new TranslatableComponent("gui.button.cfm.scroll_filters_down"), button -> {
                if (startIndex <= this.filters.size() - 4 - 1) {
                    ++startIndex;
                }
                this.updateTagButtons();
            }, ICONS, 80, 0);
            event.addListener((GuiEventListener)this.btnScrollDown);
            this.btnEnableAll = new IconButton(this.guiCenterX - 50, this.guiCenterY + 10, (Component)new TranslatableComponent("gui.button.cfm.enable_filters"), button -> {
                this.filters.forEach(filters -> filters.setEnabled(true));
                this.buttons.forEach(TagButton::updateState);
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof CreativeModeInventoryScreen) {
                    this.updateItems((CreativeModeInventoryScreen)screen);
                }
            }, ICONS, 96, 0);
            event.addListener((GuiEventListener)this.btnEnableAll);
            this.btnDisableAll = new IconButton(this.guiCenterX - 50, this.guiCenterY + 32, (Component)new TranslatableComponent("gui.button.cfm.disable_filters"), button -> {
                this.filters.forEach(filters -> filters.setEnabled(false));
                this.buttons.forEach(TagButton::updateState);
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof CreativeModeInventoryScreen) {
                    this.updateItems((CreativeModeInventoryScreen)screen);
                }
            }, ICONS, 112, 0);
            event.addListener((GuiEventListener)this.btnDisableAll);
            this.btnScrollUp.f_93624_ = false;
            this.btnScrollDown.f_93624_ = false;
            this.btnEnableAll.f_93624_ = false;
            this.btnDisableAll.f_93624_ = false;
            this.updateTagButtons();
            if (creativeScreen.m_98628_() == FurnitureMod.GROUP.m_40775_()) {
                this.btnScrollUp.f_93624_ = true;
                this.btnScrollDown.f_93624_ = true;
                this.btnEnableAll.f_93624_ = true;
                this.btnDisableAll.f_93624_ = true;
                this.viewingFurnitureTab = true;
                this.buttons.forEach(button -> {
                    button.f_93624_ = true;
                });
                this.updateItems(creativeScreen);
            }
        }
    }

    @SubscribeEvent
    public void onScreenClick(ScreenEvent.MouseClickedEvent.Pre event) {
        if (event.getButton() != 0) {
            return;
        }
        if (event.getScreen() instanceof CreativeModeInventoryScreen) {
            for (Button button : this.buttons) {
                if (!button.m_5953_(event.getMouseX(), event.getMouseY()) || !button.m_6375_(event.getMouseX(), event.getMouseY(), event.getButton())) continue;
                return;
            }
        }
    }

    @SubscribeEvent
    public void onScreenDrawPre(ScreenEvent.DrawScreenEvent.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            if (creativeScreen.m_98628_() == FurnitureMod.GROUP.m_40775_()) {
                if (!this.viewingFurnitureTab) {
                    this.updateItems(creativeScreen);
                    this.viewingFurnitureTab = true;
                }
            } else {
                this.viewingFurnitureTab = false;
            }
        }
    }

    @SubscribeEvent
    public void onScreenDrawPost(ScreenEvent.DrawScreenEvent.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            this.guiCenterX = creativeScreen.getGuiLeft();
            this.guiCenterY = creativeScreen.getGuiTop();
            if (creativeScreen.m_98628_() == FurnitureMod.GROUP.m_40775_()) {
                this.btnScrollUp.f_93624_ = true;
                this.btnScrollDown.f_93624_ = true;
                this.btnEnableAll.f_93624_ = true;
                this.btnDisableAll.f_93624_ = true;
                this.buttons.forEach(button -> {
                    button.f_93624_ = true;
                });
                this.buttons.forEach(button -> button.m_6305_(event.getPoseStack(), event.getMouseX(), event.getMouseY(), event.getPartialTicks()));
                this.buttons.forEach(button -> {
                    if (button.m_5953_(event.getMouseX(), event.getMouseY())) {
                        creativeScreen.m_96602_(event.getPoseStack(), (Component)button.getCategory().getName(), event.getMouseX(), event.getMouseY());
                    }
                });
                if (this.btnEnableAll.m_5953_((double)event.getMouseX(), (double)event.getMouseY())) {
                    creativeScreen.m_96602_(event.getPoseStack(), this.btnEnableAll.m_6035_(), event.getMouseX(), event.getMouseY());
                }
                if (this.btnDisableAll.m_5953_((double)event.getMouseX(), (double)event.getMouseY())) {
                    creativeScreen.m_96602_(event.getPoseStack(), this.btnDisableAll.m_6035_(), event.getMouseX(), event.getMouseY());
                }
            } else {
                this.btnScrollUp.f_93624_ = false;
                this.btnScrollDown.f_93624_ = false;
                this.btnEnableAll.f_93624_ = false;
                this.btnDisableAll.f_93624_ = false;
                this.buttons.forEach(button -> {
                    button.f_93624_ = false;
                });
            }
        }
    }

    private void updateTagButtons() {
        Button.OnPress onPress = button -> {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
                this.updateItems(creativeScreen);
            }
        };
        this.buttons.clear();
        for (int i = startIndex; i < startIndex + 4 && i < this.filters.size(); ++i) {
            TagButton button2 = new TagButton(this.guiCenterX - 28, this.guiCenterY + 29 * (i - startIndex) + 10, this.filters.get(i), onPress);
            this.buttons.add(button2);
        }
        this.btnScrollUp.f_93623_ = startIndex > 0;
        this.btnScrollDown.f_93623_ = startIndex <= this.filters.size() - 4 - 1;
    }

    private void updateItems(CreativeModeInventoryScreen screen) {
        CreativeModeInventoryScreen.ItemPickerMenu menu = (CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_();
        LinkedHashSet<Item> categorisedItems = new LinkedHashSet<Item>();
        for (TagFilter filter : this.filters) {
            if (!filter.isEnabled()) continue;
            categorisedItems.addAll(filter.getItems());
        }
        NonNullList newItems = NonNullList.m_122779_();
        for (Item item : categorisedItems) {
            item.m_6787_(FurnitureMod.GROUP, newItems);
        }
        menu.f_98639_.clear();
        menu.f_98639_.addAll((Collection)newItems);
        menu.f_98639_.sort(Comparator.comparingInt(o -> Item.m_41393_((Item)o.m_41720_())));
        menu.m_98642_(0.0f);
    }

    private void compileItems() {
        TagFilter[] filters = new TagFilter[]{new TagFilter(ModTags.Items.GENERAL, new ItemStack((ItemLike)ModBlocks.CHAIR_OAK.get())), new TagFilter(ModTags.Items.STORAGE, new ItemStack((ItemLike)ModBlocks.CABINET_OAK.get())), new TagFilter(ModTags.Items.BEDROOM, new ItemStack((ItemLike)ModBlocks.DESK_OAK.get())), new TagFilter(ModTags.Items.OUTDOORS, new ItemStack((ItemLike)ModBlocks.MAIL_BOX_OAK.get())), new TagFilter(ModTags.Items.KITCHEN, new ItemStack((ItemLike)ModBlocks.KITCHEN_COUNTER_CYAN.get())), new TagFilter(ModTags.Items.ITEMS, new ItemStack((ItemLike)ModItems.SPATULA.get()))};
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_41471_() == FurnitureMod.GROUP).filter(item -> item.getRegistryName().m_135827_().equals("cfm")).forEach(item -> item.m_204114_().m_203616_().forEach(tagKey -> {
            for (TagFilter filter : filters) {
                if (tagKey != filter.getTag()) continue;
                filter.add((Item)item);
            }
        }));
        this.filters = new ArrayList<TagFilter>();
        this.filters.addAll(Arrays.asList(filters));
    }

    public static class TagFilter {
        private final List<Item> items = Lists.newArrayList();
        private final TagKey<Item> tag;
        private final TranslatableComponent name;
        private final ItemStack icon;
        private boolean enabled = true;

        public TagFilter(TagKey<Item> tag, ItemStack icon) {
            this.tag = tag;
            this.name = new TranslatableComponent(String.format("gui.tag_filter.%s.%s", tag.f_203868_().m_135827_(), tag.f_203868_().m_135815_().replace("/", ".")));
            this.icon = icon;
        }

        public TagKey<Item> getTag() {
            return this.tag;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public TranslatableComponent getName() {
            return this.name;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void add(Item item) {
            this.items.add(item);
        }

        public void add(Block block) {
            this.items.add(Item.m_41439_((Block)block));
        }

        public List<Item> getItems() {
            return this.items;
        }
    }
}

