/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.util.JsonHelper;

public abstract class FluidIngredient {
    public static final FluidIngredient EMPTY = new Empty();
    public static Serializer SERIALIZER = new Serializer();
    private List<FluidStack> displayFluids;

    public abstract boolean test(Fluid var1);

    public abstract int getAmount(Fluid var1);

    public boolean test(FluidStack stack) {
        Fluid fluid = stack.getFluid();
        return stack.getAmount() >= this.getAmount(fluid) && this.test(stack.getFluid());
    }

    public List<FluidStack> getFluids() {
        if (this.displayFluids == null) {
            this.displayFluids = this.getAllFluids().stream().filter(stack -> {
                Fluid fluid = stack.getFluid();
                return fluid.m_7444_(fluid.m_76145_());
            }).collect(Collectors.toList());
        }
        return this.displayFluids;
    }

    protected abstract List<FluidStack> getAllFluids();

    public abstract JsonElement serialize();

    public void write(FriendlyByteBuf buffer) {
        List<FluidStack> fluids = this.getAllFluids();
        buffer.writeInt(fluids.size());
        for (FluidStack stack : fluids) {
            buffer.m_130070_(Objects.requireNonNull(stack.getFluid().getRegistryName()).toString());
            buffer.writeInt(stack.getAmount());
        }
    }

    public static FluidIngredient of(Fluid fluid, int amount) {
        return new FluidMatch(fluid, amount);
    }

    public static FluidIngredient of(FluidStack stack) {
        return FluidIngredient.of(stack.getFluid(), stack.getAmount());
    }

    public static FluidIngredient of(TagKey<Fluid> fluid, int amount) {
        return new TagMatch(fluid, amount);
    }

    public static FluidIngredient of(FluidIngredient ... ingredients) {
        return new Compound(ingredients);
    }

    public static FluidIngredient deserialize(JsonObject parent, String name) {
        return FluidIngredient.deserialize(JsonHelper.getElement(parent, name), name);
    }

    public static FluidIngredient deserialize(JsonElement json, String name) {
        if (json.isJsonObject()) {
            return FluidIngredient.deserializeObject(json.getAsJsonObject());
        }
        if (json.isJsonArray()) {
            return Compound.deserialize(json.getAsJsonArray(), name);
        }
        throw new JsonSyntaxException("Fluid ingredient " + name + " must be either an object or array");
    }

    private static FluidIngredient deserializeObject(JsonObject json) {
        if (json.entrySet().isEmpty()) {
            return EMPTY;
        }
        if (json.has("name")) {
            if (json.has("tag")) {
                throw new JsonSyntaxException("An ingredient entry is either a tag or an fluid, not both");
            }
            return FluidMatch.deserialize(json);
        }
        if (json.has("tag")) {
            return TagMatch.deserialize(json);
        }
        throw new JsonSyntaxException("An ingredient entry needs either a tag or an fluid");
    }

    public static FluidIngredient read(FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        FluidIngredient[] ingredients = new FluidIngredient[count];
        for (int i = 0; i < count; ++i) {
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE)));
            if (fluid == null) {
                fluid = Fluids.f_76191_;
            }
            int amount = buffer.readInt();
            ingredients[i] = FluidIngredient.of(fluid, amount);
        }
        if (count == 1) {
            return ingredients[0];
        }
        return FluidIngredient.of(ingredients);
    }

    private static class FluidMatch
    extends FluidIngredient {
        private final Fluid fluid;
        private final int amount;

        @Override
        public boolean test(Fluid fluid) {
            return fluid == this.fluid;
        }

        @Override
        public int getAmount(Fluid fluid) {
            return this.amount;
        }

        @Override
        public List<FluidStack> getAllFluids() {
            return Collections.singletonList(new FluidStack(this.fluid, this.amount));
        }

        @Override
        public JsonElement serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("name", Objects.requireNonNull(this.fluid.getRegistryName()).toString());
            object.addProperty("amount", (Number)this.amount);
            return object;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(1);
            buffer.m_130070_(Objects.requireNonNull(this.fluid.getRegistryName()).toString());
            buffer.writeInt(this.amount);
        }

        private static FluidMatch deserialize(JsonObject json) {
            String fluidName = GsonHelper.m_13906_((JsonObject)json, (String)"name");
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
            if (fluid == null || fluid == Fluids.f_76191_) {
                throw new JsonSyntaxException("Unknown fluid '" + fluidName + "'");
            }
            int amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
            return new FluidMatch(fluid, amount);
        }

        private FluidMatch(Fluid fluid, int amount) {
            this.fluid = fluid;
            this.amount = amount;
        }
    }

    private static class TagMatch
    extends FluidIngredient {
        private final TagKey<Fluid> tag;
        private final int amount;

        @Override
        public boolean test(Fluid fluid) {
            return fluid.m_205067_(this.tag);
        }

        @Override
        public int getAmount(Fluid fluid) {
            return this.amount;
        }

        @Override
        public List<FluidStack> getAllFluids() {
            return StreamSupport.stream(Registry.f_122822_.m_206058_(this.tag).spliterator(), false).filter(Holder::m_203633_).map(fluid -> new FluidStack((Fluid)fluid.m_203334_(), this.amount)).toList();
        }

        @Override
        public JsonElement serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("tag", this.tag.f_203868_().toString());
            object.addProperty("amount", (Number)this.amount);
            return object;
        }

        private static TagMatch deserialize(JsonObject json) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)JsonHelper.getResourceLocation(json, "tag"));
            int amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
            return new TagMatch((TagKey<Fluid>)tag, amount);
        }

        private TagMatch(TagKey<Fluid> tag, int amount) {
            this.tag = tag;
            this.amount = amount;
        }
    }

    private static class Compound
    extends FluidIngredient {
        private final List<FluidIngredient> ingredients;

        private Compound(FluidIngredient[] ingredients) {
            this.ingredients = Arrays.asList(ingredients);
        }

        @Override
        public boolean test(Fluid fluid) {
            return this.ingredients.stream().anyMatch(ingredient -> ingredient.test(fluid));
        }

        @Override
        public boolean test(FluidStack stack) {
            return this.ingredients.stream().anyMatch(ingredient -> ingredient.test(stack));
        }

        @Override
        public int getAmount(Fluid fluid) {
            return this.ingredients.stream().filter(ingredient -> ingredient.test(fluid)).mapToInt(ingredient -> ingredient.getAmount(fluid)).findFirst().orElse(0);
        }

        @Override
        public List<FluidStack> getAllFluids() {
            return this.ingredients.stream().flatMap(ingredient -> ingredient.getFluids().stream()).collect(Collectors.toList());
        }

        @Override
        public JsonElement serialize() {
            return (JsonElement)this.ingredients.stream().map(FluidIngredient::serialize).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
        }

        private static Compound deserialize(JsonArray array, String name) {
            int size = array.size();
            if (size == 0) {
                throw new JsonSyntaxException("Fluid array cannot be empty, at least one fluid must be defined");
            }
            FluidIngredient[] ingredients = new FluidIngredient[size];
            for (int i = 0; i < size; ++i) {
                ingredients[i] = FluidIngredient.deserializeObject(GsonHelper.m_13918_((JsonElement)array.get(i), (String)(name + "[" + i + "]")));
            }
            return new Compound(ingredients);
        }
    }

    private static class Empty
    extends FluidIngredient {
        @Override
        public boolean test(Fluid fluid) {
            return fluid == Fluids.f_76191_;
        }

        @Override
        public boolean test(FluidStack fluid) {
            return fluid.isEmpty();
        }

        @Override
        public int getAmount(Fluid fluid) {
            return 0;
        }

        @Override
        public List<FluidStack> getAllFluids() {
            return Collections.emptyList();
        }

        @Override
        public JsonElement serialize() {
            return new JsonObject();
        }

        private Empty() {
        }
    }

    public static class Serializer
    implements JsonDeserializer<FluidIngredient>,
    JsonSerializer<FluidIngredient> {
        private Serializer() {
        }

        public FluidIngredient deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return FluidIngredient.deserialize(json, "ingredient");
        }

        public JsonElement serialize(FluidIngredient src, Type typeOfSrc, JsonSerializationContext context) {
            return src.serialize();
        }
    }
}

