/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.helper;

import com.google.gson.JsonObject;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.util.JsonHelper;

public class TagEmptyCondition<T>
implements ICondition {
    private static final ResourceLocation NAME = Mantle.getResource("tag_empty");
    public static final Serializer SERIALIZER = new Serializer();
    private final TagKey<T> tag;

    public TagEmptyCondition(ResourceKey<? extends Registry<T>> registry, ResourceLocation name) {
        this(TagKey.m_203882_(registry, (ResourceLocation)name));
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        Mantle.logger.error("Improperly calling TagEmpty condition for " + this.tag + ", use context sensitive test method");
        return false;
    }

    public boolean test(ICondition.IContext context) {
        return context.getTag(this.tag).m_6497_().isEmpty();
    }

    public String toString() {
        return "tag_empty(\"" + this.tag + "\")";
    }

    public TagEmptyCondition(TagKey<T> tag) {
        this.tag = tag;
    }

    private static class Serializer
    implements IConditionSerializer<TagEmptyCondition<?>> {
        private Serializer() {
        }

        public void write(JsonObject json, TagEmptyCondition<?> value) {
            json.addProperty("registry", value.tag.f_203867_().m_135782_().toString());
            json.addProperty("tag", value.tag.f_203868_().toString());
        }

        private <T> TagEmptyCondition<T> readGeneric(JsonObject json) {
            ResourceKey registry = ResourceKey.m_135788_((ResourceLocation)JsonHelper.getResourceLocation(json, "registry"));
            return new TagEmptyCondition(registry, JsonHelper.getResourceLocation(json, "tag"));
        }

        public TagEmptyCondition<?> read(JsonObject json) {
            return this.readGeneric(json);
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

