/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.NamedComponentRegistry;
import slimeknights.mantle.util.JsonHelper;

public class GenericLoaderRegistry<T extends IHaveLoader<T>>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    private static final JsonObject EMPTY_OBJECT = new JsonObject();
    private final NamedComponentRegistry<IGenericLoader<? extends T>> loaders = new NamedComponentRegistry("Unknown loader");
    @Nullable
    private final T defaultInstance;
    private final boolean compact;

    public GenericLoaderRegistry(T defaultInstance) {
        this(defaultInstance, false);
    }

    public GenericLoaderRegistry(boolean compact) {
        this(null, compact);
    }

    public GenericLoaderRegistry() {
        this(null, false);
    }

    public void register(ResourceLocation name, IGenericLoader<? extends T> loader) {
        this.loaders.register(name, loader);
    }

    public T deserialize(JsonElement element) {
        if (this.defaultInstance != null && element.isJsonNull()) {
            return this.defaultInstance;
        }
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            return this.loaders.deserialize(object, "type").deserialize(object);
        }
        if (this.compact) {
            if (element.isJsonPrimitive()) {
                EMPTY_OBJECT.entrySet().clear();
                return this.loaders.convert(element, "type").deserialize(EMPTY_OBJECT);
            }
            throw new JsonSyntaxException("Invalid JSON for " + this.getClass().getSimpleName() + ", must be a JSON object or a string");
        }
        throw new JsonSyntaxException("Invalid JSON for " + this.getClass().getSimpleName() + ", must be a JSON object");
    }

    public T getAndDeserialize(JsonObject parent, String key) {
        if (this.defaultInstance != null && !parent.has(key)) {
            return this.defaultInstance;
        }
        if (this.compact) {
            return this.deserialize(JsonHelper.getElement(parent, key));
        }
        return this.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)parent, (String)key));
    }

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return this.deserialize(json);
    }

    private <L extends IHaveLoader<T>> JsonElement serialize(IGenericLoader<L> loader, T src) {
        JsonObject json = new JsonObject();
        JsonPrimitive type = new JsonPrimitive(this.loaders.getKey(loader).toString());
        json.add("type", (JsonElement)type);
        loader.serialize(src, json);
        if (json.get("type") != type) {
            throw new IllegalStateException("Serializer " + type.getAsString() + " modified the type key, this is not allowed as it breaks deserialization");
        }
        if (this.compact && json.entrySet().size() == 1) {
            return type;
        }
        return json;
    }

    public JsonElement serialize(T src) {
        return this.serialize(src.getLoader(), src);
    }

    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == this.defaultInstance) {
            return JsonNull.INSTANCE;
        }
        return this.serialize(src);
    }

    private <L extends IHaveLoader<T>> void toNetwork(IGenericLoader<L> loader, T src, FriendlyByteBuf buffer) {
        buffer.m_130085_(this.loaders.getKey(loader));
        loader.toNetwork(src, buffer);
    }

    public void toNetwork(T src, FriendlyByteBuf buffer) {
        if (this.defaultInstance != null) {
            if (src == this.defaultInstance) {
                buffer.writeBoolean(false);
                return;
            }
            buffer.writeBoolean(true);
        }
        this.toNetwork(src.getLoader(), src, buffer);
    }

    public T fromNetwork(FriendlyByteBuf buffer) {
        if (this.defaultInstance != null && !buffer.readBoolean()) {
            return this.defaultInstance;
        }
        return this.loaders.fromNetwork(buffer).fromNetwork(buffer);
    }

    public GenericLoaderRegistry(@Nullable T defaultInstance, boolean compact) {
        this.defaultInstance = defaultInstance;
        this.compact = compact;
    }

    public static interface IHaveLoader<T> {
        public IGenericLoader<? extends T> getLoader();
    }

    public static interface IGenericLoader<T extends IHaveLoader<?>> {
        public T deserialize(JsonObject var1);

        public T fromNetwork(FriendlyByteBuf var1);

        public void serialize(T var1, JsonObject var2);

        public void toNetwork(T var1, FriendlyByteBuf var2);
    }

    public static class SingletonLoader<T extends IHaveLoader<?>>
    implements IGenericLoader<T> {
        private final T instance;

        public SingletonLoader(Function<IGenericLoader<T>, T> creator) {
            this.instance = (IHaveLoader)creator.apply(this);
        }

        @Override
        public T deserialize(JsonObject json) {
            return this.instance;
        }

        @Override
        public T fromNetwork(FriendlyByteBuf buffer) {
            return this.instance;
        }

        @Override
        public void serialize(T object, JsonObject json) {
        }

        @Override
        public void toNetwork(T object, FriendlyByteBuf buffer) {
        }

        public static <T extends IHaveLoader<?>> T singleton(Function<IGenericLoader<T>, T> instance) {
            return (T)new SingletonLoader<Function<IGenericLoader<T>, T>>(instance).getInstance();
        }

        public SingletonLoader(T instance) {
            this.instance = instance;
        }

        public T getInstance() {
            return this.instance;
        }
    }
}

