/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagManager;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.DumpTagCommand;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.command.RegistryArgument;

public class DumpAllTagsCommand {
    private static final String TAG_DUMP_PATH = "./mantle_data_dump";
    private static final int EXTENSION_LENGTH = ".json".length();

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(1))).executes(DumpAllTagsCommand::runAll)).then(Commands.m_82129_((String)"type", RegistryArgument.registry()).suggests(MantleCommand.REGISTRY).executes(DumpAllTagsCommand::runType));
    }

    protected static File getOutputFile(CommandContext<CommandSourceStack> context) {
        return ((CommandSourceStack)context.getSource()).m_81377_().m_129971_(TAG_DUMP_PATH);
    }

    protected static Component getOutputComponent(File file) {
        return new TextComponent(file.getAbsolutePath()).m_130938_(style -> style.setUnderlined(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
    }

    private static int runAll(CommandContext<CommandSourceStack> context) {
        File output = DumpAllTagsCommand.getOutputFile(context);
        int tagsDumped = ((CommandSourceStack)context.getSource()).m_5894_().m_206193_().mapToInt(r -> DumpAllTagsCommand.runForFolder(context, r.f_206233_(), output)).sum();
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("command.mantle.dump_all_tags.success", new Object[]{DumpAllTagsCommand.getOutputComponent(output)}), true);
        return tagsDumped;
    }

    private static int runType(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        File output = DumpAllTagsCommand.getOutputFile(context);
        Registry<?> registry = RegistryArgument.getResult(context, "type");
        int result = DumpAllTagsCommand.runForFolder(context, registry.m_123023_(), output);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("command.mantle.dump_all_tags.type_success", new Object[]{registry.m_123023_().m_135782_(), DumpAllTagsCommand.getOutputComponent(output)}), true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runForFolder(CommandContext<CommandSourceStack> context, ResourceKey<? extends Registry<?>> key, File output) {
        HashMap foundTags = Maps.newHashMap();
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        ResourceManager manager = server.m_177941_();
        ResourceLocation tagType = key.m_135782_();
        String dataPackFolder = TagManager.m_203918_(key);
        for (ResourceLocation resourceLocation : manager.m_6540_(dataPackFolder, fileName -> fileName.endsWith(".json"))) {
            String path = resourceLocation.m_135815_();
            ResourceLocation tagId = new ResourceLocation(resourceLocation.m_135827_(), path.substring(dataPackFolder.length() + 1, path.length() - EXTENSION_LENGTH));
            try {
                for (Resource resource : manager.m_7396_(resourceLocation)) {
                    try {
                        InputStream inputstream = resource.m_6679_();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                            JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)DumpTagCommand.GSON, (Reader)reader, JsonObject.class);
                            if (json == null) {
                                Mantle.logger.error("Couldn't load {} tag list {} from {} in data pack {} as it is empty or null", (Object)tagType, (Object)tagId, (Object)resourceLocation, (Object)resource.m_7816_());
                                continue;
                            }
                            foundTags.computeIfAbsent(resourceLocation, id -> Tag.Builder.m_13304_()).m_13312_(json, resource.m_7816_());
                        }
                        finally {
                            if (inputstream == null) continue;
                            inputstream.close();
                        }
                    }
                    catch (IOException | RuntimeException ex) {
                        Mantle.logger.error("Couldn't read {} tag list {} from {} in data pack {}", (Object)tagType, (Object)tagId, (Object)resourceLocation, (Object)resource.m_7816_(), (Object)ex);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)resource);
                    }
                }
            }
            catch (IOException ex) {
                Mantle.logger.error("Couldn't read {} tag list {} from {}", (Object)tagType, (Object)tagId, (Object)resourceLocation, (Object)ex);
            }
        }
        for (Map.Entry entry : foundTags.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            Path path = output.toPath().resolve(location.m_135827_() + "/" + location.m_135815_());
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
                try {
                    writer.write(DumpTagCommand.GSON.toJson((JsonElement)((Tag.Builder)entry.getValue()).m_13334_()));
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (IOException ex) {
                Mantle.logger.error("Couldn't save tags to {}", (Object)path, (Object)ex);
            }
        }
        return foundTags.size();
    }
}

