/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.screen.book.TextDataRenderer;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;

public class SelectionElement
extends SizedBookElement {
    public static final int IMG_SIZE = 32;
    public static final int WIDTH = 42;
    public static final int HEIGHT = 42;
    private SectionData section;
    private ImageElement iconRenderer;
    private final int iconX;
    private final int iconY;

    public SelectionElement(int x, int y, SectionData section) {
        super(x, y, 42, 42);
        this.section = section;
        this.iconX = this.x + 21 - 16;
        this.iconY = this.y + 21 - 16;
        this.iconRenderer = new ImageElement(this.iconX, this.iconY, 32, 32, section.icon);
    }

    @Override
    public void draw(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks, Font fontRenderer) {
        boolean unlocked = this.section.isUnlocked(this.parent.advancementCache);
        boolean hover = this.isHovered(mouseX, mouseY);
        if (hover) {
            SelectionElement.m_93172_((PoseStack)matrixStack, (int)this.iconX, (int)this.iconY, (int)(this.iconX + 32), (int)(this.iconY + 32), (int)this.parent.book.appearance.hoverColor);
        }
        if (unlocked) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(hover ? 1.0f : 0.5f));
        } else {
            float r = (float)(this.parent.book.appearance.lockedSectionColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.parent.book.appearance.lockedSectionColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.parent.book.appearance.lockedSectionColor & 0xFF) / 255.0f;
            RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)0.75f);
        }
        this.iconRenderer.draw(matrixStack, mouseX, mouseY, partialTicks, fontRenderer);
        if (this.section.parent.appearance.drawSectionListText) {
            String title = this.section.getTitle().replace("\\n", "\n");
            Objects.requireNonNull(fontRenderer);
            String[] splitTitle = TextDataRenderer.cropStringBySize(title, "", 44, 9 * 2 + 1, fontRenderer, 1.0f);
            for (int i = 0; i < splitTitle.length; ++i) {
                int textW = fontRenderer.m_92895_(splitTitle[i]);
                int textX = this.x + 21 - textW / 2;
                Objects.requireNonNull(fontRenderer);
                int n = this.y + 42 - 9 / 2;
                Objects.requireNonNull(fontRenderer);
                int textY = n + 9 * i;
                fontRenderer.m_92883_(matrixStack, splitTitle[i], (float)textX, (float)textY, hover ? -16777216 : 0x7F000000);
            }
        }
    }

    @Override
    public void drawOverlay(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks, Font fontRenderer) {
        if (this.section != null && this.isHovered(mouseX, mouseY)) {
            ArrayList<Component> text = new ArrayList<Component>();
            text.add((Component)new TextComponent(this.section.getTitle()));
            if (!this.section.isUnlocked(this.parent.advancementCache)) {
                text.add((Component)new TextComponent("Locked").m_130940_(ChatFormatting.RED));
                text.add((Component)new TextComponent("Requirements:"));
                for (String requirement : this.section.requirements) {
                    text.add((Component)new TextComponent(requirement));
                }
            }
            this.drawTooltip(matrixStack, text, mouseX, mouseY, fontRenderer);
        }
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.section != null && this.section.isUnlocked(this.parent.advancementCache) && this.isHovered(mouseX, mouseY)) {
            this.parent.openPage(this.parent.book.getFirstPageNumber(this.section, this.parent.advancementCache));
        }
    }
}

