/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.fluid;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.registration.ModelFluidAttributes;

public class FluidTextureModel
implements IModelGeometry<FluidTextureModel> {
    public static Loader LOADER = new Loader();
    private final int color;

    private static boolean isMissing(Material material) {
        return MissingTextureAtlasSprite.m_118071_().equals((Object)material.m_119203_());
    }

    private static void getTexture(IModelConfiguration owner, String name, Collection<Material> textures, Set<Pair<String, String>> missingTextureErrors) {
        Material material = owner.resolveTexture(name);
        if (FluidTextureModel.isMissing(material)) {
            missingTextureErrors.add((Pair<String, String>)Pair.of((Object)name, (Object)owner.getModelName()));
        }
        textures.add(material);
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<Material> textures = new HashSet<Material>();
        FluidTextureModel.getTexture(owner, "still", textures, missingTextureErrors);
        FluidTextureModel.getTexture(owner, "flowing", textures, missingTextureErrors);
        Material overlay = owner.resolveTexture("overlay");
        if (!FluidTextureModel.isMissing(overlay)) {
            textures.add(overlay);
        }
        return textures;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        Material still = owner.resolveTexture("still");
        Material flowing = owner.resolveTexture("flowing");
        Material overlay = owner.resolveTexture("overlay");
        ResourceLocation overlayLocation = FluidTextureModel.isMissing(overlay) ? null : overlay.m_119203_();
        BakedModel baked = new SimpleBakedModel.Builder(owner, overrides).m_119528_(spriteGetter.apply(still)).m_119533_();
        return new Baked(baked, still.m_119203_(), flowing.m_119203_(), overlayLocation, this.color);
    }

    public FluidTextureModel(int color) {
        this.color = color;
    }

    private static class Baked
    extends BakedModelWrapper<BakedModel> {
        private final ResourceLocation still;
        private final ResourceLocation flowing;
        private final ResourceLocation overlay;
        private final int color;

        public Baked(BakedModel originalModel, ResourceLocation still, ResourceLocation flowing, @Nullable ResourceLocation overlay, int color) {
            super(originalModel);
            this.still = still;
            this.flowing = flowing;
            this.overlay = overlay;
            this.color = color;
        }

        public ResourceLocation getStill() {
            return this.still;
        }

        public ResourceLocation getFlowing() {
            return this.flowing;
        }

        public ResourceLocation getOverlay() {
            return this.overlay;
        }

        public int getColor() {
            return this.color;
        }
    }

    private static class Loader
    implements IModelLoader<FluidTextureModel>,
    ModelFluidAttributes.IFluidModelProvider {
        private final Map<Fluid, Baked> modelCache = new ConcurrentHashMap<Fluid, Baked>();

        private Loader() {
        }

        @Nullable
        private Baked getFluidModel(Fluid fluid) {
            return ModelHelper.getBakedModel(fluid.m_76145_().m_76188_(), Baked.class);
        }

        @Nullable
        private Baked getCachedModel(Fluid fluid) {
            return this.modelCache.computeIfAbsent(fluid, this::getFluidModel);
        }

        @Override
        @Nullable
        public ResourceLocation getStillTexture(Fluid fluid) {
            Baked model = this.getCachedModel(fluid);
            return model == null ? null : model.getStill();
        }

        @Override
        @Nullable
        public ResourceLocation getFlowingTexture(Fluid fluid) {
            Baked model = this.getCachedModel(fluid);
            return model == null ? null : model.getFlowing();
        }

        @Override
        @Nullable
        public ResourceLocation getOverlayTexture(Fluid fluid) {
            Baked model = this.getCachedModel(fluid);
            return model == null ? null : model.getOverlay();
        }

        @Override
        public int getColor(Fluid fluid) {
            Baked model = this.getCachedModel(fluid);
            return model == null ? -1 : model.getColor();
        }

        public void m_6213_(ResourceManager resourceManager) {
            this.modelCache.clear();
        }

        public FluidTextureModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            int color = -1;
            if (modelContents.has("color")) {
                String colorString = GsonHelper.m_13906_((JsonObject)modelContents, (String)"color");
                int length = colorString.length();
                if (colorString.charAt(0) == '-' || length != 6 && length != 8) {
                    throw new JsonSyntaxException("Invalid color '" + colorString + "'");
                }
                try {
                    color = (int)Long.parseLong(colorString, 16);
                    if (length == 6) {
                        color |= 0xFF000000;
                    }
                }
                catch (NumberFormatException e) {
                    throw new JsonSyntaxException("Invalid color '" + colorString + "'");
                }
            }
            return new FluidTextureModel(color);
        }
    }
}

