/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.util.ModelTextureIteratable;
import slimeknights.mantle.util.JsonHelper;

public class NBTKeyModel
implements IModelGeometry<NBTKeyModel> {
    public static final Loader LOADER = new Loader();
    private static final Multimap<ResourceLocation, Pair<String, ResourceLocation>> EXTRA_TEXTURES = HashMultimap.create();
    private final String nbtKey;
    @Nullable
    private final ResourceLocation extraTexturesKey;
    private Map<String, Material> textures = Collections.emptyMap();

    public static void registerExtraTexture(ResourceLocation key, String textureName, ResourceLocation texture) {
        EXTRA_TEXTURES.put((Object)key, (Object)Pair.of((Object)textureName, (Object)texture));
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        UnbakedModel model;
        this.textures = new HashMap<String, Material>();
        Material defaultTexture = owner.resolveTexture("default");
        this.textures.put("default", defaultTexture);
        if (Objects.equals(defaultTexture.m_119203_(), MissingTextureAtlasSprite.m_118071_())) {
            missingTextureErrors.add((Pair<String, String>)Pair.of((Object)"default", (Object)owner.getModelName()));
        }
        if ((model = owner.getOwnerModel()) instanceof BlockModel) {
            ModelTextureIteratable iterable = new ModelTextureIteratable(null, (BlockModel)model);
            for (Map map : iterable) {
                for (String key : map.keySet()) {
                    if (this.textures.containsKey(key) || !owner.isTexturePresent(key)) continue;
                    this.textures.put(key, owner.resolveTexture(key));
                }
            }
        }
        if (this.extraTexturesKey != null) {
            for (Pair extra : EXTRA_TEXTURES.get((Object)this.extraTexturesKey)) {
                String key = (String)extra.getFirst();
                if (this.textures.containsKey(key)) continue;
                this.textures.put(key, ModelLoaderRegistry.blockMaterial((ResourceLocation)((ResourceLocation)extra.getSecond())));
            }
        }
        return this.textures.values();
    }

    private static BakedModel bakeModel(IModelConfiguration owner, Material texture, Function<Material, TextureAtlasSprite> spriteGetter, ImmutableMap<ItemTransforms.TransformType, Transformation> transformMap, ItemOverrides overrides) {
        TextureAtlasSprite sprite = spriteGetter.apply(texture);
        ImmutableList quads = ItemLayerModel.getQuadsForSprite((int)-1, (TextureAtlasSprite)sprite, (Transformation)Transformation.m_121093_());
        return new BakedItemModel(quads, sprite, transformMap, overrides, true, owner.isSideLit());
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        ImmutableMap.Builder variants = ImmutableMap.builder();
        ImmutableMap transformMap = Maps.immutableEnumMap((Map)PerspectiveMapWrapper.getTransforms((ModelState)owner.getCombinedTransform()));
        for (Map.Entry<String, Material> entry : this.textures.entrySet()) {
            String key = entry.getKey();
            if (key.equals("default")) continue;
            variants.put((Object)key, (Object)NBTKeyModel.bakeModel(owner, entry.getValue(), spriteGetter, (ImmutableMap<ItemTransforms.TransformType, Transformation>)transformMap, ItemOverrides.f_111734_));
        }
        return NBTKeyModel.bakeModel(owner, this.textures.get("default"), spriteGetter, (ImmutableMap<ItemTransforms.TransformType, Transformation>)transformMap, new Overrides(this.nbtKey, this.textures, (Map<String, BakedModel>)variants.build()));
    }

    public NBTKeyModel(String nbtKey, @Nullable ResourceLocation extraTexturesKey) {
        this.nbtKey = nbtKey;
        this.extraTexturesKey = extraTexturesKey;
    }

    public static class Overrides
    extends ItemOverrides {
        private final String nbtKey;
        private final Map<String, Material> textures;
        private final Map<String, BakedModel> variants;

        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity livingEntity, int pSeed) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null && nbt.m_128441_(this.nbtKey)) {
                return this.variants.getOrDefault(nbt.m_128461_(this.nbtKey), model);
            }
            return model;
        }

        public Material getTexture(String name) {
            Material texture = this.textures.get(name);
            return texture != null ? texture : this.textures.get("default");
        }

        public Overrides(String nbtKey, Map<String, Material> textures, Map<String, BakedModel> variants) {
            this.nbtKey = nbtKey;
            this.textures = textures;
            this.variants = variants;
        }
    }

    private static class Loader
    implements IModelLoader<NBTKeyModel> {
        private Loader() {
        }

        public void m_6213_(ResourceManager resourceManager) {
        }

        public NBTKeyModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            String key = GsonHelper.m_13906_((JsonObject)modelContents, (String)"nbt_key");
            ResourceLocation extraTexturesKey = null;
            if (modelContents.has("extra_textures_key")) {
                extraTexturesKey = JsonHelper.getResourceLocation(modelContents, "extra_textures_key");
            }
            return new NBTKeyModel(key, extraTexturesKey);
        }
    }
}

