/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.setup;

import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.RSContainerMenus;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.RSKeyBindings;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.refinedmods.refinedstorage.container.CrafterContainerMenu;
import com.refinedmods.refinedstorage.container.CrafterManagerContainerMenu;
import com.refinedmods.refinedstorage.container.slot.CrafterManagerSlot;
import com.refinedmods.refinedstorage.item.property.ControllerItemPropertyGetter;
import com.refinedmods.refinedstorage.item.property.NetworkItemPropertyGetter;
import com.refinedmods.refinedstorage.item.property.SecurityCardItemPropertyGetter;
import com.refinedmods.refinedstorage.render.BakedModelOverrideRegistry;
import com.refinedmods.refinedstorage.render.blockentity.StorageMonitorBlockEntityRenderer;
import com.refinedmods.refinedstorage.render.color.PatternItemColor;
import com.refinedmods.refinedstorage.render.model.BakedModelCableCover;
import com.refinedmods.refinedstorage.render.model.BakedModelCover;
import com.refinedmods.refinedstorage.render.model.DiskDriveBakedModel;
import com.refinedmods.refinedstorage.render.model.DiskManipulatorBakedModel;
import com.refinedmods.refinedstorage.render.model.FullbrightBakedModel;
import com.refinedmods.refinedstorage.render.model.PatternBakedModel;
import com.refinedmods.refinedstorage.render.model.PortableGridBakedModel;
import com.refinedmods.refinedstorage.render.resourcepack.ResourcePackListener;
import com.refinedmods.refinedstorage.screen.ConstructorScreen;
import com.refinedmods.refinedstorage.screen.ControllerScreen;
import com.refinedmods.refinedstorage.screen.CrafterScreen;
import com.refinedmods.refinedstorage.screen.CraftingMonitorScreen;
import com.refinedmods.refinedstorage.screen.DestructorScreen;
import com.refinedmods.refinedstorage.screen.DetectorScreen;
import com.refinedmods.refinedstorage.screen.DiskDriveScreen;
import com.refinedmods.refinedstorage.screen.DiskManipulatorScreen;
import com.refinedmods.refinedstorage.screen.ExporterScreen;
import com.refinedmods.refinedstorage.screen.ExternalStorageScreen;
import com.refinedmods.refinedstorage.screen.FilterScreen;
import com.refinedmods.refinedstorage.screen.FluidInterfaceScreen;
import com.refinedmods.refinedstorage.screen.FluidStorageBlockScreen;
import com.refinedmods.refinedstorage.screen.ImporterScreen;
import com.refinedmods.refinedstorage.screen.InterfaceScreen;
import com.refinedmods.refinedstorage.screen.KeyInputListener;
import com.refinedmods.refinedstorage.screen.NetworkTransmitterScreen;
import com.refinedmods.refinedstorage.screen.RelayScreen;
import com.refinedmods.refinedstorage.screen.SecurityManagerScreen;
import com.refinedmods.refinedstorage.screen.StorageBlockScreen;
import com.refinedmods.refinedstorage.screen.StorageMonitorScreen;
import com.refinedmods.refinedstorage.screen.WirelessTransmitterScreen;
import com.refinedmods.refinedstorage.screen.factory.CrafterManagerScreenFactory;
import com.refinedmods.refinedstorage.screen.factory.GridScreenFactory;
import com.refinedmods.refinedstorage.util.ColorMap;
import java.util.Arrays;
import java.util.function.BiConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public final class ClientSetup {
    private static final ResourceLocation DISK_RESOURCE = new ResourceLocation("refinedstorage:block/disks/disk");
    private static final ResourceLocation DISK_NEAR_CAPACITY_RESOURCE = new ResourceLocation("refinedstorage:block/disks/disk_near_capacity");
    private static final ResourceLocation DISK_FULL_RESOURCE = new ResourceLocation("refinedstorage:block/disks/disk_full");
    private static final ResourceLocation DISK_DISCONNECTED_RESOURCE = new ResourceLocation("refinedstorage:block/disks/disk_disconnected");
    private static final ResourceLocation CONNECTED = new ResourceLocation("connected");
    private static final BakedModelOverrideRegistry BAKED_MODEL_OVERRIDE_REGISTRY = new BakedModelOverrideRegistry();

    private static ResourceLocation[] getMultipleColoredModels(DyeColor color, String ... paths) {
        return (ResourceLocation[])Arrays.stream(paths).map(path -> ClientSetup.getColoredModel(color, path)).toArray(ResourceLocation[]::new);
    }

    private static ResourceLocation getColoredModel(DyeColor color, String path) {
        return new ResourceLocation("refinedstorage", path + color);
    }

    private static void forEachColorApply(String name, BiConsumer<ResourceLocation, DyeColor> consumer) {
        for (DyeColor color : DyeColor.values()) {
            Object prefix = color == ColorMap.DEFAULT_COLOR ? "" : color + "_";
            consumer.accept(new ResourceLocation("refinedstorage", (String)prefix + name), color);
        }
    }

    private ClientSetup() {
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputListener());
        ClientSetup.registerBakedModelOverrides();
        ClientSetup.registerPatternRenderHandlers();
        e.enqueueWork(() -> {
            MenuScreens.m_96206_(RSContainerMenus.FILTER, FilterScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.CONTROLLER, ControllerScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.DISK_DRIVE, DiskDriveScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.GRID, (MenuScreens.ScreenConstructor)new GridScreenFactory());
            MenuScreens.m_96206_(RSContainerMenus.STORAGE_BLOCK, StorageBlockScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.FLUID_STORAGE_BLOCK, FluidStorageBlockScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.EXTERNAL_STORAGE, ExternalStorageScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.IMPORTER, ImporterScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.EXPORTER, ExporterScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.NETWORK_TRANSMITTER, NetworkTransmitterScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.RELAY, RelayScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.DETECTOR, DetectorScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.SECURITY_MANAGER, SecurityManagerScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.INTERFACE, InterfaceScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.FLUID_INTERFACE, FluidInterfaceScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.WIRELESS_TRANSMITTER, WirelessTransmitterScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.STORAGE_MONITOR, StorageMonitorScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.CONSTRUCTOR, ConstructorScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.DESTRUCTOR, DestructorScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.DISK_MANIPULATOR, DiskManipulatorScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.CRAFTER, CrafterScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.CRAFTER_MANAGER, (MenuScreens.ScreenConstructor)new CrafterManagerScreenFactory());
            MenuScreens.m_96206_(RSContainerMenus.CRAFTING_MONITOR, CraftingMonitorScreen::new);
            MenuScreens.m_96206_(RSContainerMenus.WIRELESS_CRAFTING_MONITOR, CraftingMonitorScreen::new);
        });
        ClientRegistry.registerKeyBinding((KeyMapping)RSKeyBindings.FOCUS_SEARCH_BAR);
        ClientRegistry.registerKeyBinding((KeyMapping)RSKeyBindings.CLEAR_GRID_CRAFTING_MATRIX);
        ClientRegistry.registerKeyBinding((KeyMapping)RSKeyBindings.OPEN_WIRELESS_GRID);
        ClientRegistry.registerKeyBinding((KeyMapping)RSKeyBindings.OPEN_WIRELESS_FLUID_GRID);
        ClientRegistry.registerKeyBinding((KeyMapping)RSKeyBindings.OPEN_WIRELESS_CRAFTING_MONITOR);
        ClientRegistry.registerKeyBinding((KeyMapping)RSKeyBindings.OPEN_PORTABLE_GRID);
        e.enqueueWork(() -> {
            RSBlocks.CONTROLLER.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.CREATIVE_CONTROLLER.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.CRAFTER.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.CRAFTER_MANAGER.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.CRAFTING_MONITOR.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.DETECTOR.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.DISK_MANIPULATOR.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.GRID.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.CRAFTING_GRID.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.PATTERN_GRID.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.FLUID_GRID.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.NETWORK_RECEIVER.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.NETWORK_TRANSMITTER.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.RELAY.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.SECURITY_MANAGER.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            RSBlocks.WIRELESS_TRANSMITTER.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RSBlocks.CABLE.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RSBlocks.IMPORTER.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RSBlocks.EXPORTER.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RSBlocks.EXTERNAL_STORAGE.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RSBlocks.CONSTRUCTOR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RSBlocks.DESTRUCTOR.get()), (RenderType)RenderType.m_110463_());
        });
        BlockEntityRenderers.m_173590_(RSBlockEntities.STORAGE_MONITOR, ctx -> new StorageMonitorBlockEntityRenderer());
        e.enqueueWork(() -> {
            Minecraft.m_91087_().getItemColors().m_92689_((ItemColor)new PatternItemColor(), new ItemLike[]{(ItemLike)RSItems.PATTERN.get()});
            ItemProperties.register((Item)((Item)RSItems.SECURITY_CARD.get()), (ResourceLocation)new ResourceLocation("active"), (ItemPropertyFunction)new SecurityCardItemPropertyGetter());
            RSItems.CONTROLLER.values().forEach(controller -> ItemProperties.register((Item)((Item)controller.get()), (ResourceLocation)new ResourceLocation("energy_type"), (ItemPropertyFunction)new ControllerItemPropertyGetter()));
            RSItems.CREATIVE_CONTROLLER.values().forEach(controller -> ItemProperties.register((Item)((Item)controller.get()), (ResourceLocation)new ResourceLocation("energy_type"), (ItemPropertyFunction)new ControllerItemPropertyGetter()));
            ItemProperties.register((Item)((Item)RSItems.WIRELESS_CRAFTING_MONITOR.get()), (ResourceLocation)CONNECTED, (ItemPropertyFunction)new NetworkItemPropertyGetter());
            ItemProperties.register((Item)((Item)RSItems.CREATIVE_WIRELESS_CRAFTING_MONITOR.get()), (ResourceLocation)CONNECTED, (ItemPropertyFunction)new NetworkItemPropertyGetter());
            ItemProperties.register((Item)((Item)RSItems.WIRELESS_GRID.get()), (ResourceLocation)CONNECTED, (ItemPropertyFunction)new NetworkItemPropertyGetter());
            ItemProperties.register((Item)((Item)RSItems.CREATIVE_WIRELESS_GRID.get()), (ResourceLocation)CONNECTED, (ItemPropertyFunction)new NetworkItemPropertyGetter());
            ItemProperties.register((Item)((Item)RSItems.WIRELESS_FLUID_GRID.get()), (ResourceLocation)CONNECTED, (ItemPropertyFunction)new NetworkItemPropertyGetter());
            ItemProperties.register((Item)((Item)RSItems.CREATIVE_WIRELESS_FLUID_GRID.get()), (ResourceLocation)CONNECTED, (ItemPropertyFunction)new NetworkItemPropertyGetter());
        });
    }

    private static void registerPatternRenderHandlers() {
        API.instance().addPatternRenderHandler(pattern -> Screen.m_96638_());
        API.instance().addPatternRenderHandler(pattern -> {
            AbstractContainerMenu container = Minecraft.m_91087_().f_91074_.f_36096_;
            if (container instanceof CrafterManagerContainerMenu) {
                for (Slot slot : container.f_38839_) {
                    if (!(slot instanceof CrafterManagerSlot) || slot.m_7993_() != pattern) continue;
                    return true;
                }
            }
            return false;
        });
        API.instance().addPatternRenderHandler(pattern -> {
            AbstractContainerMenu container = Minecraft.m_91087_().f_91074_.f_36096_;
            if (container instanceof CrafterContainerMenu) {
                for (int i = 0; i < 9; ++i) {
                    if (container.m_38853_(i).m_7993_() != pattern) continue;
                    return true;
                }
            }
            return false;
        });
    }

    private static void registerBakedModelOverrides() {
        ClientSetup.forEachColorApply("controller", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, new ResourceLocation("refinedstorage", "block/controller/cutouts/" + color), new ResourceLocation("refinedstorage", "block/controller/cutouts/nearly_off"), new ResourceLocation("refinedstorage", "block/controller/cutouts/nearly_on"))));
        ClientSetup.forEachColorApply("creative_controller", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, new ResourceLocation("refinedstorage", "block/controller/cutouts/" + color), new ResourceLocation("refinedstorage", "block/controller/cutouts/nearly_off"), new ResourceLocation("refinedstorage", "block/controller/cutouts/nearly_on"))));
        ClientSetup.forEachColorApply("grid", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, ClientSetup.getColoredModel(color, "block/grid/cutouts/"))));
        ClientSetup.forEachColorApply("crafting_grid", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, ClientSetup.getColoredModel(color, "block/crafting_grid/cutouts/"))));
        ClientSetup.forEachColorApply("pattern_grid", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, ClientSetup.getColoredModel(color, "block/pattern_grid/cutouts/"))));
        ClientSetup.forEachColorApply("fluid_grid", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, ClientSetup.getColoredModel(color, "block/fluid_grid/cutouts/"))));
        ClientSetup.forEachColorApply("network_receiver", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, ClientSetup.getColoredModel(color, "block/network_receiver/cutouts/"))));
        ClientSetup.forEachColorApply("network_transmitter", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, ClientSetup.getColoredModel(color, "block/network_transmitter/cutouts/"))));
        ClientSetup.forEachColorApply("relay", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, ClientSetup.getColoredModel(color, "block/relay/cutouts/"))));
        ClientSetup.forEachColorApply("detector", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, ClientSetup.getColoredModel(color, "block/detector/cutouts/"))));
        ClientSetup.forEachColorApply("security_manager", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, ClientSetup.getMultipleColoredModels(color, "block/security_manager/cutouts/top_", "block/security_manager/cutouts/front_", "block/security_manager/cutouts/left_", "block/security_manager/cutouts/back_", "block/security_manager/cutouts/right_"))));
        ClientSetup.forEachColorApply("wireless_transmitter", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, ClientSetup.getColoredModel(color, "block/wireless_transmitter/cutouts/"))));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "disk_drive"), (base, registry) -> new FullbrightBakedModel(new DiskDriveBakedModel(base, (BakedModel)registry.get(DISK_RESOURCE), (BakedModel)registry.get(DISK_NEAR_CAPACITY_RESOURCE), (BakedModel)registry.get(DISK_FULL_RESOURCE), (BakedModel)registry.get(DISK_DISCONNECTED_RESOURCE)), false, new ResourceLocation("refinedstorage", "block/disks/leds")));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "cable"), (base, registry) -> new BakedModelCableCover(base));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "exporter"), (base, registry) -> new BakedModelCableCover(base));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "importer"), (base, registry) -> new BakedModelCableCover(base));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "constructor"), (base, registry) -> new BakedModelCableCover(new FullbrightBakedModel(base, true, new ResourceLocation("refinedstorage", "block/constructor/cutouts/connected"))));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "destructor"), (base, registry) -> new BakedModelCableCover(new FullbrightBakedModel(base, true, new ResourceLocation("refinedstorage", "block/destructor/cutouts/connected"))));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "external_storage"), (base, registry) -> new BakedModelCableCover(base));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "cover"), (base, registry) -> new BakedModelCover(ItemStack.f_41583_, CoverType.NORMAL));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "hollow_cover"), (base, registry) -> new BakedModelCover(ItemStack.f_41583_, CoverType.HOLLOW));
        ClientSetup.forEachColorApply("disk_manipulator", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(new DiskManipulatorBakedModel((BakedModel)registry.get(new ResourceLocation("refinedstorage:block/disk_manipulator/" + color)), (BakedModel)registry.get(new ResourceLocation("refinedstorage:block/disk_manipulator/disconnected")), (BakedModel)registry.get(DISK_RESOURCE), (BakedModel)registry.get(DISK_NEAR_CAPACITY_RESOURCE), (BakedModel)registry.get(DISK_FULL_RESOURCE), (BakedModel)registry.get(DISK_DISCONNECTED_RESOURCE)), false, new ResourceLocation("refinedstorage", "block/disks/leds"), new ResourceLocation("refinedstorage", "block/disk_manipulator/cutouts/" + color))));
        for (String portableGridName : new String[]{"portable_grid", "creative_portable_grid"}) {
            BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", portableGridName), (base, registry) -> new FullbrightBakedModel(new PortableGridBakedModel((BakedModel)registry.get(new ResourceLocation("refinedstorage:block/portable_grid_connected")), (BakedModel)registry.get(new ResourceLocation("refinedstorage:block/portable_grid_disconnected")), (BakedModel)registry.get(new ResourceLocation("refinedstorage:block/disks/portable_grid_disk")), (BakedModel)registry.get(new ResourceLocation("refinedstorage:block/disks/portable_grid_disk_near_capacity")), (BakedModel)registry.get(new ResourceLocation("refinedstorage:block/disks/portable_grid_disk_full")), (BakedModel)registry.get(new ResourceLocation("refinedstorage:block/disks/portable_grid_disk_disconnected"))), false, new ResourceLocation("refinedstorage:block/disks/leds")));
        }
        ClientSetup.forEachColorApply("crafter", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, ClientSetup.getMultipleColoredModels(color, "block/crafter/cutouts/side_", "block/crafter/cutouts/top_"))));
        ClientSetup.forEachColorApply("crafter_manager", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, ClientSetup.getColoredModel(color, "block/crafter_manager/cutouts/"))));
        ClientSetup.forEachColorApply("crafting_monitor", (name, color) -> BAKED_MODEL_OVERRIDE_REGISTRY.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, ClientSetup.getColoredModel(color, "block/crafting_monitor/cutouts/"))));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "pattern"), (base, registry) -> new PatternBakedModel(base));
    }

    @SubscribeEvent
    public static void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ResourcePackListener());
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent e) {
        ForgeModelBakery.addSpecialModel((ResourceLocation)DISK_RESOURCE);
        ForgeModelBakery.addSpecialModel((ResourceLocation)DISK_NEAR_CAPACITY_RESOURCE);
        ForgeModelBakery.addSpecialModel((ResourceLocation)DISK_FULL_RESOURCE);
        ForgeModelBakery.addSpecialModel((ResourceLocation)DISK_DISCONNECTED_RESOURCE);
        ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/disk_manipulator/disconnected"));
        for (DyeColor color : DyeColor.values()) {
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/disk_manipulator/" + color));
        }
        ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/portable_grid_connected"));
        ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/portable_grid_disconnected"));
        ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/disks/portable_grid_disk"));
        ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/disks/portable_grid_disk_near_capacity"));
        ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/disks/portable_grid_disk_full"));
        ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/disks/portable_grid_disk_disconnected"));
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent e) {
        FullbrightBakedModel.invalidateCache();
        for (ResourceLocation id : e.getModelRegistry().keySet()) {
            BakedModelOverrideRegistry.BakedModelOverrideFactory factory = BAKED_MODEL_OVERRIDE_REGISTRY.get(new ResourceLocation(id.m_135827_(), id.m_135815_()));
            if (factory == null) continue;
            e.getModelRegistry().put(id, factory.create((BakedModel)e.getModelRegistry().get(id), e.getModelRegistry()));
        }
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            event.addSprite(new ResourceLocation("refinedstorage", "block/cable_part_border"));
        }
    }
}

