/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid.stack;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.storage.tracker.StorageTrackerEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.render.RenderSettings;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.tags.IReverseTag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemGridStack
implements IGridStack {
    private static final String ERROR_PLACEHOLDER = "<Error>";
    private static final Logger LOGGER = LogManager.getLogger(ItemGridStack.class);
    private final ItemStack stack;
    private UUID id;
    @Nullable
    private UUID otherId;
    private boolean craftable;
    @Nullable
    private StorageTrackerEntry entry;
    private boolean zeroed;
    private Set<String> cachedTags;
    private String cachedName;
    private String cachedModId;
    private String cachedModName;
    private List<Component> cachedTooltip;

    public ItemGridStack(ItemStack stack) {
        this.stack = stack;
    }

    public ItemGridStack(UUID id, @Nullable UUID otherId, ItemStack stack, boolean craftable, StorageTrackerEntry entry) {
        this.id = id;
        this.otherId = otherId;
        this.stack = stack;
        this.craftable = craftable;
        this.entry = entry;
    }

    @Nullable
    static String getModNameByModId(String modId) {
        Optional modContainer = ModList.get().getModContainerById(modId);
        return modContainer.map(container -> container.getModInfo().getDisplayName()).orElse(null);
    }

    public void setZeroed(boolean zeroed) {
        this.zeroed = zeroed;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    @Nullable
    public UUID getOtherId() {
        return this.otherId;
    }

    @Override
    public void updateOtherId(@Nullable UUID otherId) {
        this.otherId = otherId;
    }

    @Override
    public String getName() {
        if (this.cachedName == null) {
            try {
                this.cachedName = this.stack.m_41786_().getString();
            }
            catch (Throwable t) {
                LOGGER.warn("Could not retrieve item name of {}", (Object)this.stack.m_41720_().getRegistryName());
                this.cachedName = ERROR_PLACEHOLDER;
            }
        }
        return this.cachedName;
    }

    @Override
    public String getModId() {
        if (this.cachedModId == null) {
            this.cachedModId = this.stack.m_41720_().getCreatorModId(this.stack);
            if (this.cachedModId == null) {
                this.cachedModId = ERROR_PLACEHOLDER;
            }
            this.cachedModId = this.cachedModId.toLowerCase().replace(" ", "");
        }
        return this.cachedModId;
    }

    @Override
    public String getModName() {
        if (this.cachedModName == null) {
            this.cachedModName = ItemGridStack.getModNameByModId(this.getModId());
            if (this.cachedModName == null) {
                this.cachedModName = ERROR_PLACEHOLDER;
            }
        }
        return this.cachedModName;
    }

    @Override
    public Set<String> getTags() {
        if (this.cachedTags == null) {
            this.cachedTags = ForgeRegistries.ITEMS.tags().getReverseTag((IForgeRegistryEntry)this.stack.m_41720_()).stream().flatMap(IReverseTag::getTagKeys).map(TagKey::f_203868_).map(ResourceLocation::m_135815_).collect(Collectors.toSet());
        }
        return this.cachedTags;
    }

    @Override
    public List<Component> getTooltip(boolean bypassCache) {
        if (bypassCache || this.cachedTooltip == null) {
            List<Component> tooltip;
            try {
                tooltip = RenderUtils.getTooltipFromItem(this.stack);
            }
            catch (Throwable t) {
                LOGGER.warn("Could not retrieve item tooltip of {}", (Object)this.stack.m_41720_().getRegistryName());
                tooltip = new ArrayList<Component>();
                tooltip.add((Component)new TextComponent(ERROR_PLACEHOLDER));
            }
            if (bypassCache) {
                return tooltip;
            }
            this.cachedTooltip = tooltip;
        }
        return this.cachedTooltip;
    }

    @Override
    public int getQuantity() {
        return this.isCraftable() || this.zeroed ? 0 : this.stack.m_41613_();
    }

    @Override
    public void setQuantity(int amount) {
        if (amount <= 0) {
            this.setZeroed(true);
        } else {
            this.stack.m_41764_(amount);
        }
    }

    @Override
    public String getFormattedFullQuantity() {
        if (this.zeroed) {
            return "0";
        }
        return API.instance().getQuantityFormatter().format(this.getQuantity());
    }

    @Override
    public void draw(PoseStack poseStack, BaseScreen<?> screen, int x, int y) {
        String text = null;
        int color = RenderSettings.INSTANCE.getSecondaryColor();
        if (this.zeroed) {
            text = "0";
            color = 0xFF5555;
        } else if (this.craftable) {
            text = I18n.m_118938_((String)"gui.refinedstorage.grid.craft", (Object[])new Object[0]);
        } else if (this.stack.m_41613_() > 1) {
            text = API.instance().getQuantityFormatter().formatWithUnits(this.getQuantity());
        }
        screen.renderItem(poseStack, x, y, this.stack, true, text, color);
    }

    @Override
    public Object getIngredient() {
        return this.getStack();
    }

    @Override
    @Nullable
    public StorageTrackerEntry getTrackerEntry() {
        return this.entry;
    }

    @Override
    public void setTrackerEntry(@Nullable StorageTrackerEntry entry) {
        this.entry = entry;
    }
}

