/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.render.RenderSettings;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AmountSpecifyingScreen<T extends AbstractContainerMenu>
extends BaseScreen<T> {
    private final BaseScreen<T> parent;
    protected EditBox amountField;
    protected Button okButton;
    protected Button cancelButton;

    protected AmountSpecifyingScreen(BaseScreen<T> parent, T container, int width, int height, Inventory playerInventory, Component title) {
        super(container, width, height, playerInventory, title);
        this.parent = parent;
    }

    protected abstract Component getOkButtonText();

    protected abstract String getTexture();

    protected abstract int[] getIncrements();

    protected abstract int getDefaultAmount();

    protected abstract boolean canAmountGoNegative();

    protected abstract int getMaxAmount();

    protected Pair<Integer, Integer> getAmountPos() {
        return Pair.of((Object)9, (Object)51);
    }

    protected Pair<Integer, Integer> getOkCancelPos() {
        return Pair.of((Object)114, (Object)33);
    }

    protected int getOkCancelButtonWidth() {
        return 50;
    }

    @Override
    public void onPostInit(int x, int y) {
        TextComponent text2;
        int increment;
        int i;
        Pair<Integer, Integer> pos = this.getOkCancelPos();
        this.okButton = this.addButton(x + (Integer)pos.getLeft(), y + (Integer)pos.getRight(), this.getOkCancelButtonWidth(), 20, this.getOkButtonText(), true, true, btn -> this.onOkButtonPressed(AmountSpecifyingScreen.m_96638_()));
        this.cancelButton = this.addButton(x + (Integer)pos.getLeft(), y + (Integer)pos.getRight() + 24, this.getOkCancelButtonWidth(), 20, (Component)new TranslatableComponent("gui.cancel"), true, true, btn -> this.close());
        int n = x + (Integer)this.getAmountPos().getLeft();
        int n2 = y + (Integer)this.getAmountPos().getRight();
        Objects.requireNonNull(this.f_96547_);
        this.amountField = new EditBox(this.f_96547_, n, n2, 63, 9, (Component)new TextComponent(""));
        this.amountField.m_94182_(false);
        this.amountField.m_94194_(true);
        this.amountField.m_94144_(String.valueOf(this.getDefaultAmount()));
        this.amountField.m_94202_(RenderSettings.INSTANCE.getSecondaryColor());
        this.amountField.m_94190_(false);
        this.amountField.m_5755_(true);
        this.amountField.m_94151_(text -> {
            int amount = 0;
            try {
                amount = Integer.parseInt(this.amountField.m_94155_());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (amount > this.getMaxAmount()) {
                this.amountField.m_94144_(String.valueOf(this.getMaxAmount()));
            }
        });
        this.m_142416_((GuiEventListener)this.amountField);
        this.m_7522_((GuiEventListener)this.amountField);
        int[] increments = this.getIncrements();
        int xx = 7;
        int width = 30;
        for (i = 0; i < 3; ++i) {
            increment = increments[i];
            text2 = new TextComponent("+" + increment);
            if (text2.getString().equals("+1000")) {
                text2 = new TextComponent("+1B");
            }
            this.addButton(x + xx, y + 20, width, 20, (Component)text2, true, true, btn -> this.onIncrementButtonClicked(increment));
            xx += width + 3;
        }
        xx = 7;
        for (i = 0; i < 3; ++i) {
            increment = increments[i];
            text2 = new TextComponent("-" + increment);
            if (text2.getString().equals("-1000")) {
                text2 = new TextComponent("-1B");
            }
            this.addButton(x + xx, y + this.f_97727_ - 20 - 7, width, 20, (Component)text2, true, true, btn -> this.onIncrementButtonClicked(-increment));
            xx += width + 3;
        }
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.close();
            return true;
        }
        if ((key == 257 || key == 335) && this.amountField.m_93696_()) {
            this.onOkButtonPressed(AmountSpecifyingScreen.m_96638_());
            return true;
        }
        if (this.amountField.m_7933_(key, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    private void onIncrementButtonClicked(int increment) {
        int oldAmount = 0;
        try {
            oldAmount = Integer.parseInt(this.amountField.m_94155_());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int newAmount = increment;
        newAmount = !this.canAmountGoNegative() ? Math.max(1, (oldAmount == 1 && newAmount != 1 ? 0 : oldAmount) + newAmount) : oldAmount + newAmount;
        if (newAmount > this.getMaxAmount()) {
            newAmount = this.getMaxAmount();
        }
        this.amountField.m_94144_(String.valueOf(newAmount));
    }

    @Override
    public void tick(int x, int y) {
    }

    @Override
    public void renderBackground(PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", this.getTexture());
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.amountField.m_6303_(poseStack, 0, 0, 0.0f);
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY) {
        this.renderString(poseStack, 7, 7, this.f_96539_.getString());
    }

    protected void onOkButtonPressed(boolean shiftDown) {
    }

    public boolean m_6050_(double x, double y, double delta) {
        if (delta > 0.0) {
            this.onIncrementButtonClicked(1);
        } else {
            this.onIncrementButtonClicked(-1);
        }
        return super.m_6050_(x, y, delta);
    }

    public void close() {
        this.f_96541_.m_91152_(this.parent);
    }

    public BaseScreen<T> getParent() {
        return this.parent;
    }
}

