/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.grid;

import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class GridTransferMessage {
    private final ItemStack[][] recipe = new ItemStack[9][];
    List<List<ItemStack>> inputs;

    public GridTransferMessage() {
    }

    public GridTransferMessage(List<List<ItemStack>> inputs) {
        this.inputs = inputs;
    }

    public static GridTransferMessage decode(FriendlyByteBuf buf) {
        GridTransferMessage msg = new GridTransferMessage();
        int slots = buf.readInt();
        for (int i = 0; i < slots; ++i) {
            int numberOfIngredients = buf.readInt();
            msg.recipe[i] = new ItemStack[numberOfIngredients];
            for (int j = 0; j < numberOfIngredients; ++j) {
                msg.recipe[i][j] = StackUtils.readItemStack(buf);
            }
        }
        return msg;
    }

    public static void encode(GridTransferMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.inputs.size());
        for (List<ItemStack> stacks : message.inputs) {
            buf.writeInt(stacks.size());
            for (ItemStack possibleStack : stacks) {
                StackUtils.writeItemStack(buf, possibleStack);
            }
        }
    }

    public static void handle(GridTransferMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> GridTransferMessage.lambda$handle$0((Player)player, message));
        }
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$0(Player player, GridTransferMessage message) {
        IGrid grid;
        if (player.f_36096_ instanceof GridContainerMenu && ((grid = ((GridContainerMenu)player.f_36096_).getGrid()).getGridType() == GridType.CRAFTING || grid.getGridType() == GridType.PATTERN)) {
            grid.onRecipeTransfer(player, message.recipe);
        }
    }
}

