/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.integration.jei.Ingredient;
import com.refinedmods.refinedstorage.integration.jei.IngredientTracker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class RecipeTransferCraftingGridError
implements IRecipeTransferError {
    protected static final Color AUTOCRAFTING_HIGHLIGHT_COLOR = new Color(0.0f, 0.0f, 1.0f, 0.4f);
    private static final Color MISSING_HIGHLIGHT_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.4f);
    private static final boolean HOST_OS_IS_MACOS = System.getProperty("os.name").equals("Mac OS X");
    protected final IngredientTracker tracker;

    public RecipeTransferCraftingGridError(IngredientTracker tracker) {
        this.tracker = tracker;
    }

    public IRecipeTransferError.Type getType() {
        return IRecipeTransferError.Type.COSMETIC;
    }

    public void showError(PoseStack poseStack, int mouseX, int mouseY, IRecipeSlotsView recipeSlotsView, int recipeX, int recipeY) {
        poseStack.m_85837_((double)recipeX, (double)recipeY, 0.0);
        List<Component> message = this.drawIngredientHighlights(poseStack, recipeX, recipeY);
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        currentScreen.m_96597_(poseStack, message, mouseX, mouseY);
    }

    protected List<Component> drawIngredientHighlights(PoseStack stack, int recipeX, int recipeY) {
        ArrayList<Component> message = new ArrayList<Component>();
        message.add((Component)new TranslatableComponent("jei.tooltip.transfer"));
        boolean craftMessage = false;
        boolean missingMessage = false;
        for (Ingredient ingredient : this.tracker.getIngredients()) {
            if (ingredient.isAvailable()) continue;
            if (ingredient.isCraftable()) {
                ingredient.getSlotView().drawHighlight(stack, AUTOCRAFTING_HIGHLIGHT_COLOR.getRGB());
                craftMessage = true;
                continue;
            }
            ingredient.getSlotView().drawHighlight(stack, MISSING_HIGHLIGHT_COLOR.getRGB());
            missingMessage = true;
        }
        if (missingMessage) {
            message.add((Component)new TranslatableComponent("jei.tooltip.error.recipe.transfer.missing").m_130940_(ChatFormatting.RED));
        }
        if (craftMessage) {
            if (HOST_OS_IS_MACOS) {
                message.add((Component)new TranslatableComponent("gui.refinedstorage.jei.transfer.request_autocrafting_mac").m_130940_(ChatFormatting.BLUE));
            } else {
                message.add((Component)new TranslatableComponent("gui.refinedstorage.jei.transfer.request_autocrafting").m_130940_(ChatFormatting.BLUE));
            }
        }
        return message;
    }
}

