/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.jei;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.integration.jei.Ingredient;
import com.refinedmods.refinedstorage.item.PatternItem;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class IngredientTracker {
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final Map<ResourceLocation, Integer> storedItems = new HashMap<ResourceLocation, Integer>();
    private boolean doTransfer;

    public IngredientTracker(IRecipeSlotsView recipeLayout, boolean doTransfer) {
        for (IRecipeSlotView slotView : recipeLayout.getSlotViews(RecipeIngredientRole.INPUT)) {
            Optional<ItemStack> optionalItemStack = slotView.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).findAny();
            optionalItemStack.ifPresent(stack -> this.ingredients.add(new Ingredient(slotView, stack.m_41613_())));
        }
        this.doTransfer = doTransfer;
    }

    public Collection<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public void addAvailableStack(ItemStack stack, @Nullable IGridStack gridStack) {
        int available = stack.m_41613_();
        if (this.doTransfer) {
            if (stack.m_41720_() instanceof ICraftingPatternProvider) {
                ICraftingPattern pattern = PatternItem.fromCache((Level)Minecraft.m_91087_().f_91073_, stack);
                if (pattern.isValid()) {
                    for (ItemStack outputStack : pattern.getOutputs()) {
                        this.storedItems.merge(outputStack.m_41720_().getRegistryName(), outputStack.m_41613_(), Integer::sum);
                    }
                }
            } else {
                this.storedItems.merge(stack.m_41720_().getRegistryName(), available, Integer::sum);
            }
        }
        for (Ingredient ingredient : this.ingredients) {
            if (available == 0) {
                return;
            }
            Optional<ItemStack> match = ingredient.getSlotView().getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).filter(s -> API.instance().getComparer().isEqual(stack, (ItemStack)s, 1)).findFirst();
            if (!match.isPresent()) continue;
            if (gridStack != null && gridStack.isCraftable()) {
                ingredient.setCraftStackId(gridStack.getId());
                continue;
            }
            if (ingredient.isAvailable()) continue;
            int needed = ingredient.getMissingAmount();
            int used = Math.min(available, needed);
            ingredient.fulfill(used);
            available -= used;
        }
    }

    public boolean hasMissing() {
        return this.ingredients.stream().anyMatch(ingredient -> !ingredient.isAvailable());
    }

    public boolean hasMissingButAutocraftingAvailable() {
        return this.ingredients.stream().anyMatch(ingredient -> !ingredient.isAvailable() && ingredient.isCraftable());
    }

    public boolean isAutocraftingAvailable() {
        return this.ingredients.stream().anyMatch(Ingredient::isCraftable);
    }

    public Map<UUID, Integer> createCraftingRequests() {
        HashMap<UUID, Integer> toRequest = new HashMap<UUID, Integer>();
        for (Ingredient ingredient : this.ingredients) {
            if (ingredient.isAvailable() || !ingredient.isCraftable()) continue;
            toRequest.merge(ingredient.getCraftStackId(), ingredient.getMissingAmount(), Integer::sum);
        }
        return toRequest;
    }

    public ItemStack findBestMatch(List<ItemStack> list) {
        ItemStack stack = ItemStack.f_41583_;
        int count = 0;
        for (ItemStack itemStack : list) {
            Integer stored = this.storedItems.get(itemStack.m_41720_().getRegistryName());
            if (stored == null || stored <= count) continue;
            stack = itemStack;
            count = stored;
        }
        return stack;
    }
}

