/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.NetworkType;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.Network;
import com.refinedmods.refinedstorage.block.BaseBlock;
import com.refinedmods.refinedstorage.blockentity.ControllerBlockEntity;
import com.refinedmods.refinedstorage.container.ControllerContainerMenu;
import com.refinedmods.refinedstorage.util.BlockUtils;
import com.refinedmods.refinedstorage.util.ColorMap;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.network.NetworkHooks;

public class ControllerBlock
extends BaseBlock
implements EntityBlock {
    public static final EnumProperty<EnergyType> ENERGY_TYPE = EnumProperty.m_61587_((String)"energy_type", EnergyType.class);
    private final NetworkType type;

    public ControllerBlock(NetworkType type) {
        super(BlockUtils.DEFAULT_ROCK_PROPERTIES);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(ENERGY_TYPE, (Comparable)((Object)EnergyType.OFF)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ENERGY_TYPE});
    }

    public NetworkType getType() {
        return this.type;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        if (!level.f_46443_) {
            stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyFromStack -> {
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity != null) {
                    blockEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyFromBlockEntity -> energyFromBlockEntity.receiveEnergy(energyFromStack.getEnergyStored(), false));
                }
            });
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        INetwork network;
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
        if (!level.f_46443_ && (network = API.instance().getNetworkManager((ServerLevel)level).getNetwork(pos)) instanceof Network) {
            ((Network)network).setRedstonePowered(level.m_46753_(pos));
        }
    }

    public InteractionResult m_6227_(BlockState state, final Level level, final BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = super.m_6227_(state, level, pos, player, hand, hit);
        if (result != InteractionResult.PASS) {
            return result;
        }
        ColorMap<ControllerBlock> colorMap = this.type == NetworkType.CREATIVE ? RSBlocks.CREATIVE_CONTROLLER : RSBlocks.CONTROLLER;
        DyeColor color = DyeColor.getColor((ItemStack)player.m_21120_(hand));
        if (color != null && !state.m_60734_().equals(colorMap.get(color).get())) {
            BlockState newState = (BlockState)((ControllerBlock)((Object)colorMap.get(color).get())).m_49966_().m_61124_(ENERGY_TYPE, (Comparable)((Object)((EnergyType)((Object)state.m_61143_(ENERGY_TYPE)))));
            return RSBlocks.CONTROLLER.setBlockState(newState, player.m_21120_(hand), level, pos, player);
        }
        if (!level.f_46443_) {
            return NetworkUtils.attemptModify(level, pos, player, () -> NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return new TranslatableComponent("gui.refinedstorage." + (ControllerBlock.this.getType() == NetworkType.CREATIVE ? "creative_" : "") + "controller");
                }

                public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player player) {
                    return new ControllerContainerMenu((ControllerBlockEntity)level.m_7702_(pos), player, i);
                }
            }, (BlockPos)pos));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() instanceof ControllerBlock) {
            return;
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ControllerBlockEntity(this.type, pos, state);
    }

    public static enum EnergyType implements StringRepresentable
    {
        OFF("off"),
        NEARLY_OFF("nearly_off"),
        NEARLY_ON("nearly_on"),
        ON("on");

        private final String name;

        private EnergyType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

