/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.mods.harvest;

import com.naxanria.mods.harvest.Config;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="harvest")
public class Harvest {
    public static final String MODID = "harvest";
    public static final Logger LOGGER = LogManager.getLogger((String)"harvest");
    private static final int BLOCK_FLAGS = 8;

    public Harvest() {
        MinecraftForge.EVENT_BUS.addListener(this::onInteract);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void onInteract(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getWorld();
        if (event.getHand() == InteractionHand.OFF_HAND) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        Config config = Config.COMMON;
        List blacklist = (List)config.blacklist.get();
        boolean whitelist = (Boolean)config.whitelist.get();
        boolean consumeSeed = (Boolean)config.consumeSeed.get();
        if (blacklist.contains(block.getRegistryName().toString()) ? !whitelist : whitelist) {
            return;
        }
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            if (crop.m_52307_(state)) {
                if (!level.f_46443_) {
                    List drops = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
                    ItemStack seed = crop.m_7397_((BlockGetter)level, pos, state);
                    for (ItemStack drop : drops) {
                        if (consumeSeed && drop.m_41720_() == seed.m_41720_()) {
                            drop.m_41774_(1);
                        }
                        if (drop.m_41619_()) continue;
                        this.spawnItemStack(level, pos, drop);
                    }
                    level.m_7731_(pos, crop.m_52289_(0), 8);
                }
                event.setCanceled(true);
            }
        } else if (block == Blocks.f_50200_ && ((Boolean)Config.COMMON.harvestNetherWart.get()).booleanValue() && (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) == 3) {
            if (!level.f_46443_) {
                List drops = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
                for (ItemStack drop : drops) {
                    if (consumeSeed && drop.m_41720_() == Items.f_42588_) {
                        drop.m_41774_(1);
                    }
                    if (drop.m_41619_()) continue;
                    this.spawnItemStack(level, pos, drop);
                }
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf(0)), 8);
            }
            event.setCanceled(true);
        }
    }

    private void spawnItemStack(Level level, BlockPos position, ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(level, (double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.5, stack);
        level.m_7967_((Entity)itemEntity);
    }
}

