/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.CrashReportCategory;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.mixin.client.compat114.WorldRendererAccessor;
import virtuoel.pehkui.util.ScaleUtils;
import virtuoel.pehkui.util.VersionUtils;

public class ScaleRenderUtils {
    private static boolean loggedWrongVersionCall = false;
    private static final Set<Item> loggedItems = ConcurrentHashMap.newKeySet();
    private static ItemStack lastRenderedStack = null;
    private static int itemRecursionDepth = 0;
    private static int maxItemRecursionDepth = 2;
    private static final Set<EntityType<?>> loggedEntityTypes = ConcurrentHashMap.newKeySet();
    private static EntityType<?> lastRenderedEntity = null;
    private static int entityRecursionDepth = 0;
    private static int maxEntityRecursionDepth = 2;

    public static void renderInteractionBox(AABB box) {
        ScaleRenderUtils.renderInteractionBox(box, 0.25f, 1.0f, 0.0f, 1.0f);
    }

    public static void renderInteractionBox(AABB box, float red, float green, float blue, float alpha) {
        if (VersionUtils.MINOR < 15) {
            WorldRendererAccessor.pehkui$drawBoxOutline(box, red, green, blue, alpha);
        } else if (!loggedWrongVersionCall) {
            Pehkui.LOGGER.warn("Called outline render method for wrong version (1.{}), but currently on 1.{}.x", new Object[]{"14.x", VersionUtils.MINOR});
            loggedWrongVersionCall = true;
        }
    }

    public static void renderInteractionBox(Object matrices, Object vertices, AABB box) {
        ScaleRenderUtils.renderInteractionBox(matrices, vertices, box, 0.25f, 1.0f, 0.0f, 1.0f);
    }

    public static void renderInteractionBox(Object matrices, Object vertices, AABB box, float red, float green, float blue, float alpha) {
        if (VersionUtils.MINOR > 14) {
            LevelRenderer.m_109646_((PoseStack)((PoseStack)matrices), (VertexConsumer)((VertexConsumer)vertices), (AABB)box, (float)red, (float)green, (float)blue, (float)alpha);
        } else if (!loggedWrongVersionCall) {
            Pehkui.LOGGER.warn("Called outline render method for wrong version (1.{}), but currently on 1.{}.x", new Object[]{"15+", VersionUtils.MINOR});
            loggedWrongVersionCall = true;
        }
    }

    public static final float modifyProjectionMatrixDepthByWidth(float depth, @Nullable Entity entity, float tickDelta) {
        return entity == null ? depth : ScaleRenderUtils.modifyProjectionMatrixDepth(ScaleUtils.getBoundingBoxWidthScale(entity, tickDelta), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepthByHeight(float depth, @Nullable Entity entity, float tickDelta) {
        return entity == null ? depth : ScaleRenderUtils.modifyProjectionMatrixDepth(ScaleUtils.getEyeHeightScale(entity, tickDelta), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepth(float depth, @Nullable Entity entity, float tickDelta) {
        return entity == null ? depth : ScaleRenderUtils.modifyProjectionMatrixDepth(Math.min(ScaleUtils.getBoundingBoxWidthScale(entity, tickDelta), ScaleUtils.getEyeHeightScale(entity, tickDelta)), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepth(float scale, float depth, Entity entity, float tickDelta) {
        if (scale < 1.0f) {
            return Math.max(depth * scale, (float)((Double)PehkuiConfig.CLIENT.minimumCameraDepth.get()).doubleValue());
        }
        return depth;
    }

    public static void logIfItemRenderCancelled() {
        Item i;
        if (lastRenderedStack != null && itemRecursionDepth >= maxItemRecursionDepth && !loggedItems.contains(i = lastRenderedStack.m_41720_())) {
            String itemKey;
            String stackKey = lastRenderedStack.m_41778_();
            if (stackKey.equals(itemKey = lastRenderedStack.m_41720_().m_5524_())) {
                Pehkui.LOGGER.fatal("[{}]: Did something cancel item rendering early? Matrix stack was not popped after rendering item {} ({}).", new Object[]{"pehkui", stackKey, lastRenderedStack.m_41720_()});
            } else {
                Pehkui.LOGGER.fatal("[{}]: Did something cancel item rendering early? Matrix stack was not popped after rendering item {} ({}) ({})", new Object[]{"pehkui", stackKey, itemKey, lastRenderedStack.m_41720_()});
            }
            loggedItems.add(i);
        }
    }

    public static void saveLastRenderedItem(ItemStack currentStack) {
        if (itemRecursionDepth == 0) {
            lastRenderedStack = currentStack;
        }
        ++itemRecursionDepth;
    }

    public static void clearLastRenderedItem() {
        lastRenderedStack = null;
        itemRecursionDepth = 0;
    }

    public static void logIfEntityRenderCancelled() {
        if (lastRenderedEntity != null && entityRecursionDepth >= maxEntityRecursionDepth && !loggedEntityTypes.contains(lastRenderedEntity)) {
            ResourceLocation id = EntityType.m_20613_(lastRenderedEntity);
            Pehkui.LOGGER.fatal("[{}]: Did something cancel entity rendering early? Matrix stack was not popped after rendering entity {}.", new Object[]{"pehkui", id});
            loggedEntityTypes.add(lastRenderedEntity);
        }
    }

    public static void saveLastRenderedEntity(EntityType<?> type) {
        if (entityRecursionDepth == 0) {
            lastRenderedEntity = type;
        }
        ++entityRecursionDepth;
    }

    public static void clearLastRenderedEntity() {
        lastRenderedEntity = null;
        entityRecursionDepth = 0;
    }

    public static void addDetailsToCrashReport(CrashReportCategory section) {
        if (lastRenderedStack != null) {
            section.m_128159_("pehkui:debug/render/item", (Object)lastRenderedStack.m_41720_().m_5524_());
        }
        if (lastRenderedEntity != null) {
            ResourceLocation id = EntityType.m_20613_(lastRenderedEntity);
            section.m_128159_("pehkui:debug/render/entity", (Object)id);
        }
    }
}

