/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkDirection;
import org.spongepowered.asm.mixin.MixinEnvironment;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.network.DebugPacket;
import virtuoel.pehkui.network.PehkuiPacketHandler;
import virtuoel.pehkui.util.I18nUtils;
import virtuoel.pehkui.util.NbtCompoundExtensions;

public class DebugCommand {
    private static final Collection<UUID> MARKED_UUIDS = new HashSet<UUID>();
    private static final Collection<String> MARKED_USERNAMES = new HashSet<String>();
    private static final List<EntityType<? extends Entity>> TYPES = Arrays.asList(EntityType.f_20501_, EntityType.f_20558_, EntityType.f_20564_, EntityType.f_20551_);

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"scale").requires(commandSource -> commandSource.m_6761_(2));
        if (!FMLLoader.isProduction() || ((Boolean)PehkuiConfig.COMMON.enableCommands.get()).booleanValue()) {
            builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"delete_scale_data").then(Commands.m_82127_((String)"uuid").then(Commands.m_82129_((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String uuidString = StringArgumentType.getString((CommandContext)context, (String)"uuid");
                try {
                    MARKED_UUIDS.add(UUID.fromString(uuidString));
                }
                catch (IllegalArgumentException e) {
                    ((CommandSourceStack)context.getSource()).m_81352_(I18nUtils.translate("commands.pehkui.debug.delete.uuid.invalid", "Invalid UUID \"%s\".", uuidString));
                    return 0;
                }
                return 1;
            })))).then(Commands.m_82127_((String)"username").then(Commands.m_82129_((String)"username", (ArgumentType)StringArgumentType.string()).executes(context -> {
                MARKED_USERNAMES.add(StringArgumentType.getString((CommandContext)context, (String)"username").toLowerCase(Locale.ROOT));
                return 1;
            }))))).then(Commands.m_82127_((String)"garbage_collect").executes(context -> {
                ((CommandSourceStack)context.getSource()).m_81375_().f_8906_.m_141995_(PehkuiPacketHandler.INSTANCE.toVanillaPacket((Object)new DebugPacket(DebugPacket.Type.GARBAGE_COLLECT), NetworkDirection.PLAY_TO_CLIENT));
                System.gc();
                return 1;
            })));
        }
        if (!FMLLoader.isProduction() || ((Boolean)PehkuiConfig.COMMON.enableDebugCommands.get()).booleanValue()) {
            builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").then(Commands.m_82127_((String)"run_mixin_tests").executes(DebugCommand::runMixinTests))).then(Commands.m_82127_((String)"run_tests").executes(DebugCommand::runTests)));
        }
        commandDispatcher.register(builder);
    }

    public static boolean unmarkEntityForScaleReset(Entity entity, CompoundTag nbt) {
        if (entity instanceof Player && MARKED_USERNAMES.remove(((Player)entity).m_36316_().getName().toLowerCase(Locale.ROOT))) {
            return true;
        }
        NbtCompoundExtensions compound = (NbtCompoundExtensions)nbt;
        return compound.pehkui_containsUuid("UUID") && MARKED_UUIDS.remove(compound.pehkui_getUuid("UUID"));
    }

    private static int runTests(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).m_81374_();
        Direction dir = entity.m_6350_();
        Direction opposite = dir.m_122424_();
        Direction left = dir.m_122428_();
        Direction right = dir.m_122427_();
        int distance = 4;
        int spacing = 2;
        int width = (TYPES.size() - 1) * (spacing + 1) + 1;
        Vec3 pos = entity.m_20182_();
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos(pos.f_82479_, pos.f_82480_, pos.f_82481_).m_122175_(dir, distance).m_122175_(left, width / 2);
        Level w = entity.m_20193_();
        for (EntityType<? extends Entity> t : TYPES) {
            w.m_46597_((BlockPos)mut, Blocks.f_50387_.m_49966_());
            Entity e = t.m_20615_(w);
            e.m_19890_((double)mut.m_123341_() + 0.5, (double)(mut.m_123342_() + 1), (double)mut.m_123343_() + 0.5, opposite.m_122435_(), 0.0f);
            e.m_7678_((double)mut.m_123341_() + 0.5, (double)(mut.m_123342_() + 1), (double)mut.m_123343_() + 0.5, opposite.m_122435_(), 0.0f);
            e.m_5616_(opposite.m_122435_());
            e.m_20049_("pehkui");
            w.m_7967_(e);
            mut.m_122175_(right, spacing + 1);
        }
        int successes = -1;
        int total = -1;
        ((CommandSourceStack)context.getSource()).m_81354_(I18nUtils.translate("commands.pehkui.debug.test.success", "Tests succeeded: %d/%d", successes, total), false);
        return 1;
    }

    private static int runMixinTests(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity executor = ((CommandSourceStack)context.getSource()).m_81373_();
        if (executor instanceof ServerPlayer) {
            ((ServerPlayer)executor).f_8906_.m_141995_(PehkuiPacketHandler.INSTANCE.toVanillaPacket((Object)new DebugPacket(DebugPacket.Type.MIXIN_AUDIT), NetworkDirection.PLAY_TO_CLIENT));
        }
        ((CommandSourceStack)context.getSource()).m_81354_(I18nUtils.translate("commands.pehkui.debug.audit.start", "Starting Mixin environment audit..."), false);
        MixinEnvironment.getCurrentEnvironment().audit();
        ((CommandSourceStack)context.getSource()).m_81354_(I18nUtils.translate("commands.pehkui.debug.audit.end", "Mixin environment audit complete!"), false);
        return 1;
    }
}

