/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Desc;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin {
    @Inject(at={@At(value="RETURN")}, method={"getDimensions"}, cancellable=true)
    private void pehkui$getDimensions(Pose pose, CallbackInfoReturnable<EntityDimensions> info) {
        info.setReturnValue((Object)((EntityDimensions)info.getReturnValue()).m_20390_(ScaleUtils.getBoundingBoxWidthScale((Entity)this), ScaleUtils.getBoundingBoxHeightScale((Entity)this)));
    }

    @ModifyArg(method={"tickMovement"}, index=1, at=@At(value="INVOKE", target="Ljava/lang/Math;min(FF)F"))
    private float pehkui$tickMovement$mMinVelocity(float velocity) {
        return velocity * ScaleUtils.getMotionScale((Entity)this);
    }

    @Inject(method={"travel(Lnet/minecraft/util/math/Vec3d;)V"}, at={@At(value="INVOKE", ordinal=0, shift=At.Shift.BEFORE, target="Lnet/minecraft/entity/LivingEntity;travel(Lnet/minecraft/util/math/Vec3d;)V")})
    private void pehkui$travel$flightSpeed(Vec3 movementInput, CallbackInfo info) {
        float scale = ScaleUtils.getFlightScale((Entity)this);
        if (scale != 1.0f) {
            ((Player)this).f_20887_ *= scale;
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;"})
    private void pehkui$dropItem(ItemStack stack, boolean spread, boolean thrown, CallbackInfoReturnable<ItemEntity> info) {
        ItemEntity entity = (ItemEntity)info.getReturnValue();
        if (entity != null) {
            ScaleUtils.setScaleOfDrop((Entity)entity, (Entity)this);
            float scale = ScaleUtils.getEyeHeightScale((Entity)this);
            if (scale != 1.0f) {
                Vec3 pos = entity.m_20182_();
                entity.m_20248_(pos.f_82479_, pos.f_82480_ + (double)(1.0f - scale) * 0.3, pos.f_82481_);
            }
        }
    }

    @ModifyArg(method={"tickMovement()V"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;"))
    private double pehkui$tickMovement$expand$x(double value) {
        return value * (double)ScaleUtils.getMotionScale((Entity)this);
    }

    @ModifyArg(method={"tickMovement()V"}, index=1, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;"))
    private double pehkui$tickMovement$expand$y(double value) {
        return value * (double)ScaleUtils.getMotionScale((Entity)this);
    }

    @ModifyArg(method={"tickMovement()V"}, index=2, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;"))
    private double pehkui$tickMovement$expand$z(double value) {
        return value * (double)ScaleUtils.getMotionScale((Entity)this);
    }

    @ModifyConstant(method={"attack(Lnet/minecraft/entity/Entity;)V"}, constant={@Constant(floatValue=0.5f, ordinal=1), @Constant(floatValue=0.5f, ordinal=2), @Constant(floatValue=0.5f, ordinal=3)})
    private float pehkui$attack$knockback(float value) {
        float scale = ScaleUtils.getKnockbackScale((Entity)this);
        return scale != 1.0f ? scale * value : value;
    }

    @ModifyConstant(method={"getAttackCooldownProgressPerTick"}, constant={@Constant(doubleValue=20.0)})
    private double pehkui$getAttackCooldownProgressPerTick$multiplier(double value) {
        float scale = ScaleUtils.getAttackSpeedScale((Entity)this);
        return scale != 1.0f ? value / (double)scale : value;
    }

    @Inject(at={@At(value="RETURN")}, target={@Desc(value="getDigSpeed", args={BlockState.class, BlockPos.class}, ret=float.class)}, cancellable=true)
    private void pehkui$getBlockBreakingSpeed(BlockState block, BlockPos pos, CallbackInfoReturnable<Float> info) {
        float scale = ScaleUtils.getMiningSpeedScale((Entity)this);
        if (scale != 1.0f) {
            info.setReturnValue((Object)Float.valueOf(info.getReturnValueF() * scale));
        }
    }

    @ModifyConstant(method={"updateCapeAngles"}, constant={@Constant(doubleValue=10.0), @Constant(doubleValue=-10.0)})
    private double pehkui$updateCapeAngles$limits(double value) {
        float scale = ScaleUtils.getMotionScale((Entity)this);
        return scale != 1.0f ? (double)scale * value : value;
    }
}

