/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.util.MulticonnectCompatibility;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @ModifyArg(method={"getEyeHeight"}, index=1, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getActiveEyeHeight(Lnet/minecraft/entity/EntityPose;Lnet/minecraft/entity/EntityDimensions;)F"))
    private EntityDimensions pehkui$getEyeHeight$dimensions(EntityDimensions dimensions) {
        return dimensions.m_20388_(1.0f / ScaleUtils.getEyeHeightScale((Entity)this));
    }

    @ModifyConstant(method={"travel"}, constant={@Constant(floatValue=1.0f, ordinal=0)})
    private float pehkui$travel$fallDistance(float value) {
        float scale = ScaleUtils.getFallingScale((Entity)this);
        if (scale != 1.0f && ((Boolean)PehkuiConfig.COMMON.scaledFallDamage.get()).booleanValue()) {
            return value / scale;
        }
        return value;
    }

    @Inject(method={"getEyeHeight"}, at={@At(value="RETURN")}, cancellable=true)
    private void pehkui$getEyeHeight(Pose pose, EntityDimensions dimensions, CallbackInfoReturnable<Float> info) {
        float scale;
        if (pose != Pose.SLEEPING && (scale = ScaleUtils.getEyeHeightScale((Entity)this)) != 1.0f) {
            info.setReturnValue((Object)Float.valueOf(info.getReturnValueF() * scale));
        }
    }

    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setVelocity(DDD)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void pehkui$tickMovement$minVelocity(CallbackInfo info, Vec3 velocity) {
        LivingEntity self = (LivingEntity)this;
        float scale = ScaleUtils.getMotionScale((Entity)self);
        if (scale < 1.0f) {
            double min = (double)scale * MulticonnectCompatibility.INSTANCE.getProtocolDependantValue(ver -> ver <= 47, 0.005, 0.003);
            double vX = velocity.f_82479_;
            double vY = velocity.f_82480_;
            double vZ = velocity.f_82481_;
            if (Math.abs(vX) < min) {
                vX = 0.0;
            }
            if (Math.abs(vY) < min) {
                vY = 0.0;
            }
            if (Math.abs(vZ) < min) {
                vZ = 0.0;
            }
            self.m_20334_(vX, vY, vZ);
        }
    }

    @ModifyVariable(method={"applyArmorToDamage(Lnet/minecraft/entity/damage/DamageSource;F)F"}, at=@At(value="HEAD"), argsOnly=true)
    private float pehkui$applyArmorToDamage(float value, DamageSource source, float amount) {
        Entity attacker = source.m_7639_();
        float attackScale = attacker == null ? 1.0f : ScaleUtils.getAttackScale(attacker);
        float defenseScale = ScaleUtils.getDefenseScale((Entity)this);
        if (attackScale != 1.0f || defenseScale != 1.0f) {
            value = attackScale * value / defenseScale;
        }
        return value;
    }

    @Inject(method={"getMaxHealth"}, at={@At(value="RETURN")}, cancellable=true)
    private void pehkui$getMaxHealth(CallbackInfoReturnable<Float> info) {
        float scale = ScaleUtils.getHealthScale((Entity)this);
        if (scale != 1.0f) {
            info.setReturnValue((Object)Float.valueOf(info.getReturnValueF() * scale));
        }
    }

    @Inject(method={"getAttackDistanceScalingFactor"}, at={@At(value="RETURN")}, cancellable=true)
    private void pehkui$getAttackDistanceScalingFactor(@Nullable Entity entity, CallbackInfoReturnable<Double> info) {
        float scale = ScaleUtils.getVisibilityScale((Entity)this);
        if (scale != 1.0f) {
            info.setReturnValue((Object)(info.getReturnValueD() * (double)scale));
        }
    }

    @Inject(method={"getJumpVelocity"}, at={@At(value="RETURN")}, cancellable=true)
    private void pehkui$getJumpVelocity(CallbackInfoReturnable<Float> info) {
        float scale = ScaleUtils.getJumpHeightScale((Entity)this);
        if (scale != 1.0f) {
            info.setReturnValue((Object)Float.valueOf(info.getReturnValueF() * scale));
        }
    }

    @Inject(method={"applyClimbingSpeed(Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/util/math/Vec3d;"}, at={@At(value="RETURN")}, cancellable=true)
    private void pehkui$applyClimbingSpeed(Vec3 motion, CallbackInfoReturnable<Vec3> info) {
        LivingEntity self = (LivingEntity)this;
        if (!self.m_6147_()) {
            return;
        }
        float width = ScaleUtils.getBoundingBoxWidthScale((Entity)self);
        if (width > 1.0f) {
            AABB bounds = self.m_142469_();
            double halfUnscaledXLength = bounds.m_82362_() / (double)width / 2.0;
            int minX = Mth.m_14107_((double)(bounds.f_82288_ + halfUnscaledXLength));
            int maxX = Mth.m_14107_((double)(bounds.f_82291_ - halfUnscaledXLength));
            int minY = Mth.m_14107_((double)bounds.f_82289_);
            double halfUnscaledZLength = bounds.m_82385_() / (double)width / 2.0;
            int minZ = Mth.m_14107_((double)(bounds.f_82290_ + halfUnscaledZLength));
            int maxZ = Mth.m_14107_((double)(bounds.f_82293_ - halfUnscaledZLength));
            for (BlockPos pos : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)minY, (int)maxZ)) {
                if (!self.f_19853_.m_8055_(pos).isScaffolding(self)) continue;
                Vec3 prev = (Vec3)info.getReturnValue();
                info.setReturnValue((Object)new Vec3(prev.f_82479_, Math.max(self.m_20184_().f_82480_, -0.15), prev.f_82481_));
                break;
            }
        }
    }

    @Inject(method={"isClimbing()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void pehkui$isClimbing(CallbackInfoReturnable<Boolean> info) {
        LivingEntity self = (LivingEntity)this;
        if (info.getReturnValueZ() || self.m_5833_()) {
            return;
        }
        float width = ScaleUtils.getBoundingBoxWidthScale((Entity)self);
        if (width > 1.0f) {
            AABB bounds = self.m_142469_();
            double halfUnscaledXLength = bounds.m_82362_() / (double)width / 2.0;
            int minX = Mth.m_14107_((double)(bounds.f_82288_ + halfUnscaledXLength));
            int maxX = Mth.m_14107_((double)(bounds.f_82291_ - halfUnscaledXLength));
            int minY = Mth.m_14107_((double)bounds.f_82289_);
            double halfUnscaledZLength = bounds.m_82385_() / (double)width / 2.0;
            int minZ = Mth.m_14107_((double)(bounds.f_82290_ + halfUnscaledZLength));
            int maxZ = Mth.m_14107_((double)(bounds.f_82293_ - halfUnscaledZLength));
            for (BlockPos pos : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)minY, (int)maxZ)) {
                if (!self.f_19853_.m_8055_(pos).isLadder((LevelReader)self.f_19853_, pos, self)) continue;
                info.setReturnValue((Object)true);
                break;
            }
        }
    }

    @Redirect(method={"tickCramming"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getBoundingBox()Lnet/minecraft/util/math/Box;"))
    private AABB pehkui$tickCramming$getBoundingBox(LivingEntity obj) {
        AABB bounds = obj.m_142469_();
        float interactionWidth = ScaleUtils.getInteractionBoxWidthScale((Entity)obj);
        float interactionHeight = ScaleUtils.getInteractionBoxHeightScale((Entity)obj);
        if (interactionWidth != 1.0f || interactionHeight != 1.0f) {
            double scaledXLength = bounds.m_82362_() * 0.5 * (double)(interactionWidth - 1.0f);
            double scaledYLength = bounds.m_82376_() * 0.5 * (double)(interactionHeight - 1.0f);
            double scaledZLength = bounds.m_82385_() * 0.5 * (double)(interactionWidth - 1.0f);
            return bounds.m_82377_(scaledXLength, scaledYLength, scaledZLength);
        }
        return bounds;
    }
}

