/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.icon;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;
import xaero.map.WorldMap;
import xaero.map.exception.OpenGLException;
import xaero.map.icon.XaeroIcon;

public final class XaeroIconAtlas {
    private final int textureId;
    private final int width;
    private int currentIndex;
    private final int iconWidth;
    private final int sideIconCount;
    private final int maxIconCount;

    private XaeroIconAtlas(int textureId, int width, int iconWidth) {
        this.textureId = textureId;
        this.width = width;
        this.iconWidth = iconWidth;
        this.sideIconCount = width / iconWidth;
        this.maxIconCount = this.sideIconCount * this.sideIconCount;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public int getWidth() {
        return this.width;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public boolean isFull() {
        return this.currentIndex >= this.maxIconCount;
    }

    public XaeroIcon createIcon() {
        if (!this.isFull()) {
            int offsetX = this.currentIndex % this.sideIconCount * this.iconWidth;
            int offsetY = this.currentIndex / this.sideIconCount * this.iconWidth;
            ++this.currentIndex;
            return new XaeroIcon(this, offsetX, offsetY);
        }
        return null;
    }

    public static class Builder {
        private int width;
        private int preparedTexture;
        private int iconWidth;

        private Builder() {
        }

        public Builder setDefault() {
            this.setIconWidth(64);
            return this;
        }

        public Builder setPreparedTexture(int preparedTexture) {
            this.preparedTexture = preparedTexture;
            return this;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setIconWidth(int iconWidth) {
            this.iconWidth = iconWidth;
            return this;
        }

        private int createGlTexture(int actualWidth) {
            int texture = GlStateManager.m_84111_();
            OpenGLException.checkGLError();
            if (texture == 0) {
                return 0;
            }
            GlStateManager.m_84544_((int)texture);
            GL11.glTexParameteri((int)3553, (int)33085, (int)0);
            GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
            GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
            GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GlStateManager.m_84209_((int)3553, (int)0, (int)32856, (int)actualWidth, (int)actualWidth, (int)0, (int)32993, (int)32821, (IntBuffer)null);
            GlStateManager.m_84544_((int)0);
            OpenGLException.checkGLError();
            return texture;
        }

        public XaeroIconAtlas build() {
            int texture;
            if (this.width == 0 || this.iconWidth <= 0) {
                throw new IllegalStateException();
            }
            if (this.width / this.iconWidth * this.iconWidth != this.width) {
                throw new IllegalArgumentException();
            }
            int n = texture = this.preparedTexture == 0 ? this.createGlTexture(this.width) : this.preparedTexture;
            if (texture == 0) {
                WorldMap.LOGGER.error("Failed to create a GL texture for a new xaero icon atlas!");
                return null;
            }
            return new XaeroIconAtlas(texture, this.width, this.iconWidth);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

