/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import com.mojang.datafixers.DataFixer;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.BitStorage;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.material.FluidState;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeKey;
import xaero.map.biome.BiomeKeyManager;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.misc.CachedFunction;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class WorldDataReader {
    private MapProcessor mapProcessor;
    private boolean[] underair;
    private boolean[] blockFound;
    private byte[] lightLevels;
    private int[] topH;
    private MapBlock buildingObject = new MapBlock();
    private OverlayBuilder[] overlayBuilders;
    private BlockPos.MutableBlockPos mutableBlockPos;
    private List<BlockState> blockStatePalette;
    private BitStorage heightMapBitArray;
    private BitStorage blockStatesBitArray;
    private BitStorage biomesBitArray;
    private CompoundTag[] chunkNBTCompounds;
    public Object taskCreationSync;
    private BiomeKeyManager biomeKeyManager;
    private BlockStateShortShapeCache blockStateShortShapeCache;
    private BiomeKey defaultBiomeKey;
    private final CachedFunction<StateHolder<?, ?>, Boolean> transparentCache;
    private int[] firstTransparentStateY;
    private boolean[] shouldExtendTillTheBottom;
    private CachedFunction<FluidState, BlockState> fluidToBlock;

    public WorldDataReader(OverlayManager overlayManager, BiomeKeyManager biomeKeyManager, BlockStateShortShapeCache blockStateShortShapeCache) {
        this.underair = new boolean[256];
        this.blockFound = new boolean[256];
        this.lightLevels = new byte[256];
        this.overlayBuilders = new OverlayBuilder[256];
        this.mutableBlockPos = new BlockPos.MutableBlockPos();
        this.blockStatePalette = new ArrayList<BlockState>();
        this.heightMapBitArray = new SimpleBitStorage(9, 256);
        this.taskCreationSync = new Object();
        for (int i = 0; i < this.overlayBuilders.length; ++i) {
            this.overlayBuilders[i] = new OverlayBuilder(overlayManager);
        }
        this.chunkNBTCompounds = new CompoundTag[16];
        this.biomeKeyManager = biomeKeyManager;
        this.topH = new int[256];
        this.blockStateShortShapeCache = blockStateShortShapeCache;
        this.defaultBiomeKey = biomeKeyManager.get(Biomes.f_48174_.m_135782_().toString());
        this.biomesBitArray = new SimpleBitStorage(1, 64);
        this.transparentCache = new CachedFunction<StateHolder, Boolean>(state -> this.mapProcessor.getMapWriter().shouldOverlay((StateHolder<?, ?>)state));
        this.shouldExtendTillTheBottom = new boolean[256];
        this.firstTransparentStateY = new int[256];
        this.fluidToBlock = new CachedFunction<FluidState, BlockState>(FluidState::m_76188_);
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    private void updateHeightArray(int bitsPerHeight) {
        if (this.heightMapBitArray.m_144604_() != bitsPerHeight) {
            this.heightMapBitArray = new SimpleBitStorage(bitsPerHeight, 256);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildRegion(MapRegion region, ServerLevel worldServer, Level world, boolean loading, int[] chunkCountDest) {
        boolean regionIsResting;
        if (!loading) {
            region.pushWriterPause();
        }
        boolean result = true;
        int prevRegX = region.getRegionX();
        int prevRegZ = region.getRegionZ() - 1;
        MapRegion prevRegion = this.mapProcessor.getMapRegion(prevRegX, prevRegZ, false);
        MapRegion mapRegion = region;
        synchronized (mapRegion) {
            regionIsResting = region.isResting();
            if (!loading && regionIsResting) {
                region.setBeingWritten(true);
                region.setShouldCache(false, "world save");
                region.setReloadHasBeenRequested(false, "world save");
                region.setVersion(this.mapProcessor.getGlobalVersion());
                region.setCacheHashCode(WorldMap.settings.getRegionCacheHashCode());
                if (region.getLoadState() != 2) {
                    if (region.getLoadState() == 4) {
                        region.restoreBufferUpdateObjects();
                    }
                    region.setLoadState((byte)2);
                    region.setLastSaveTime(System.currentTimeMillis() + 100000L);
                    this.mapProcessor.addToProcess(region);
                } else {
                    this.mapProcessor.removeToRefresh(region);
                    region.setRefreshing(false);
                }
            }
        }
        int caveStart = this.mapProcessor.getCaveStart();
        boolean ignoreHeightmaps = this.mapProcessor.getMapWorld().isIgnoreHeightmaps();
        boolean flowers = WorldMap.settings.flowers;
        if (loading || region.getLoadState() == 2 && regionIsResting) {
            int worldBottomY = worldServer.m_141937_();
            int worldTopY = worldServer.m_151558_();
            ChunkMap chunkManager = worldServer.m_7726_().f_8325_;
            Registry<Biome> biomeRegistry = region.getBiomeRegistry();
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    MapTileChunk tileChunk = region.getChunk(i, j);
                    if (tileChunk == null) {
                        tileChunk = new MapTileChunk(region, (region.getRegionX() << 3) + i, (region.getRegionZ() << 3) + j);
                        region.setChunk(i, j, tileChunk);
                        MapRegion mapRegion2 = region;
                        synchronized (mapRegion2) {
                            region.setAllCachePrepared(false);
                        }
                    }
                    if (region.isMetaLoaded()) {
                        tileChunk.getLeafTexture().setBufferedTextureVersion(region.getAndResetCachedTextureVersion(i, j));
                    }
                    this.readChunkNBTCompounds((ChunkStorage)chunkManager, tileChunk);
                    this.buildTileChunk(tileChunk, caveStart, ignoreHeightmaps, prevRegion, world, biomeRegistry, flowers, worldBottomY, worldTopY);
                    tileChunk.setLoadState((byte)2);
                    if (!tileChunk.includeInSave() && !tileChunk.hasHighlightsIfUndiscovered()) {
                        region.setChunk(i, j, null);
                        tileChunk.getLeafTexture().deleteTexturesAndBuffers();
                        tileChunk = null;
                        continue;
                    }
                    chunkCountDest[0] = chunkCountDest[0] + 1;
                }
            }
            if (region.isMultiplayer()) {
                region.setLastSaveTime(System.currentTimeMillis() - 60000L + 1500L);
            }
        } else {
            result = false;
        }
        if (!loading) {
            region.popWriterPause();
        }
        return result;
    }

    private void readChunkNBTCompounds(ChunkStorage chunkLoader, MapTileChunk tileChunk) {
        for (int xl = 0; xl < 4; ++xl) {
            for (int zl = 0; zl < 4; ++zl) {
                int i = zl << 2 | xl;
                try {
                    this.chunkNBTCompounds[i] = chunkLoader.m_63512_(new ChunkPos(tileChunk.getX() * 4 + xl, tileChunk.getZ() * 4 + zl));
                    continue;
                }
                catch (IOException e) {
                    this.chunkNBTCompounds[i] = null;
                }
            }
        }
    }

    public CompoundTag readChunk(RegionFile regionFile, ChunkPos pos) throws IOException {
        try (DataInputStream datainputstream = regionFile.m_63645_(pos);){
            if (datainputstream != null) {
                CompoundTag compoundTag = NbtIo.m_128928_((DataInput)datainputstream);
                return compoundTag;
            }
            CompoundTag compoundTag = null;
            return compoundTag;
        }
    }

    private void buildTileChunk(MapTileChunk tileChunk, int caveStart, boolean ignoreHeightmaps, MapRegion prevRegion, Level world, Registry<Biome> biomeRegistry, boolean flowers, int worldBottomY, int worldTopY) {
        tileChunk.unincludeInSave();
        tileChunk.resetHeights();
        for (int insideX = 0; insideX < 4; ++insideX) {
            for (int insideZ = 0; insideZ < 4; ++insideZ) {
                int i;
                DataFixer fixer;
                MapTile tile = tileChunk.getTile(insideX, insideZ);
                int chunkX = (tileChunk.getX() << 2) + insideX;
                int chunkZ = (tileChunk.getZ() << 2) + insideZ;
                CompoundTag nbttagcompound = this.chunkNBTCompounds[insideZ << 2 | insideX];
                if (nbttagcompound == null) {
                    if (tile == null) continue;
                    tileChunk.setChanged(true);
                    tileChunk.setTile(insideX, insideZ, null, this.blockStateShortShapeCache);
                    this.mapProcessor.getTilePool().addToPool(tile);
                    continue;
                }
                boolean createdTile = false;
                if (tile == null) {
                    tile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunkX, chunkZ);
                    createdTile = true;
                }
                if (this.buildTile(nbttagcompound = NbtUtils.m_129213_((DataFixer)(fixer = Minecraft.m_91087_().m_91295_()), (DataFixTypes)DataFixTypes.CHUNK, (CompoundTag)nbttagcompound, (int)(i = nbttagcompound.m_128425_("DataVersion", 99) ? nbttagcompound.m_128451_("DataVersion") : -1)), tile, tileChunk, chunkX, chunkZ, caveStart, ignoreHeightmaps, world, biomeRegistry, flowers, worldBottomY, worldTopY)) {
                    tileChunk.setTile(insideX, insideZ, tile, this.blockStateShortShapeCache);
                    if (!createdTile) continue;
                    tileChunk.setChanged(true);
                    continue;
                }
                tileChunk.setTile(insideX, insideZ, null, this.blockStateShortShapeCache);
                this.mapProcessor.getTilePool().addToPool(tile);
            }
        }
        if (tileChunk.wasChanged()) {
            tileChunk.setToUpdateBuffers(true);
            tileChunk.setChanged(false);
        }
    }

    private boolean buildTile(CompoundTag nbttagcompound, MapTile tile, MapTileChunk tileChunk, int chunkX, int chunkZ, int caveStart, boolean ignoreHeightmaps, Level world, Registry<Biome> biomeRegistry, boolean flowers, int worldBottomY, int worldTopY) {
        boolean cave;
        boolean heightMapExists;
        String status;
        CompoundTag levelCompound = nbttagcompound;
        boolean oldOptimizedChunk = levelCompound.m_128441_("below_zero_retrogen");
        String string = status = !oldOptimizedChunk ? levelCompound.m_128461_("Status") : levelCompound.m_128469_("below_zero_retrogen").m_128461_("target_status");
        if (ChunkStatus.m_62397_((String)status).m_62445_() < ChunkStatus.f_62322_.m_62445_()) {
            return false;
        }
        ListTag sectionsList = levelCompound.m_128437_("sections", 10);
        int fillCounter = 256;
        int[] topH = this.topH;
        int chunkBottomY = levelCompound.m_128451_("yPos") * 16;
        boolean[] shouldExtendTillTheBottom = this.shouldExtendTillTheBottom;
        for (int i = 0; i < this.blockFound.length; ++i) {
            this.overlayBuilders[i].startBuilding();
            this.blockFound[i] = false;
            this.underair[i] = false;
            this.lightLevels[i] = 0;
            topH[i] = worldBottomY;
            shouldExtendTillTheBottom[i] = false;
        }
        boolean oldHeightMap = !levelCompound.m_128425_("Heightmaps", 10);
        int[] oldHeightMapArray = null;
        if (oldHeightMap) {
            oldHeightMapArray = levelCompound.m_128465_("HeightMap");
            heightMapExists = oldHeightMapArray.length == 256;
        } else {
            long[] heightMapArray = levelCompound.m_128469_("Heightmaps").m_128467_("WORLD_SURFACE");
            int potentialBitsPerHeight = heightMapArray.length / 4;
            boolean bl = heightMapExists = potentialBitsPerHeight > 0 && potentialBitsPerHeight <= 10;
            if (heightMapExists) {
                this.updateHeightArray(potentialBitsPerHeight);
                System.arraycopy(heightMapArray, 0, this.heightMapBitArray.m_13513_(), 0, heightMapArray.length);
            }
        }
        boolean bl = cave = caveStart != Short.MAX_VALUE;
        if (sectionsList.size() == 0) {
            for (i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    MapBlock currentPixel = tile.getBlock(i, j);
                    this.buildingObject.prepareForWriting(worldBottomY);
                    this.buildingObject.write(Blocks.f_50016_.m_49966_(), worldBottomY, worldBottomY, null, (byte)0, false, cave);
                    tile.setBlock(i, j, this.buildingObject);
                    this.buildingObject = currentPixel != null ? currentPixel : new MapBlock();
                }
            }
        } else {
            for (i = sectionsList.size() - 1; i >= 0 && fillCounter > 0; --i) {
                CompoundTag sectionCompound = sectionsList.m_128728_(i);
                boolean hasBlocks = false;
                CompoundTag blockStatesCompound = null;
                if (sectionCompound.m_128425_("block_states", 10) && !(hasBlocks = (blockStatesCompound = sectionCompound.m_128469_("block_states")).m_128425_("data", 12)) && blockStatesCompound.m_128425_("palette", 9)) {
                    ListTag paletteList = blockStatesCompound.m_128437_("palette", 10);
                    boolean bl2 = hasBlocks = paletteList.size() == 1 && !((CompoundTag)paletteList.get(0)).m_128423_("Name").m_7916_().equals("minecraft:air");
                }
                if (i > 0 && !hasBlocks && !sectionCompound.m_128425_("BlockLight", 7)) continue;
                boolean preparedSectionData = false;
                boolean hasDifferentBlockStates = false;
                ListTag biomePaletteList = null;
                boolean hasDifferentBiomes = false;
                byte[] lightMap = null;
                int sectionHeight = sectionCompound.m_128445_("Y") * 16;
                int sectionBasedHeight = sectionHeight + 15;
                for (int z = 0; z < 16; ++z) {
                    block5: for (int x = 0; x < 16; ++x) {
                        int startHeight;
                        int pos_2d = (z << 4) + x;
                        if (this.blockFound[pos_2d]) continue;
                        if (cave) {
                            startHeight = caveStart;
                        } else {
                            int height = heightMapExists ? (oldHeightMap ? oldHeightMapArray[pos_2d] : chunkBottomY + this.heightMapBitArray.m_13514_(pos_2d)) : Integer.MIN_VALUE;
                            startHeight = ignoreHeightmaps || height < chunkBottomY ? sectionBasedHeight : height + 3;
                        }
                        if (startHeight >= worldTopY) {
                            startHeight = worldTopY - 1;
                        }
                        if (i > 0 && startHeight < sectionHeight) continue;
                        int localStartHeight = 15;
                        if (startHeight >> 4 << 4 == sectionHeight) {
                            localStartHeight = startHeight & 0xF;
                        }
                        if (!preparedSectionData) {
                            CompoundTag biomesCompound;
                            if (hasBlocks) {
                                ListTag paletteList = blockStatesCompound.m_128437_("palette", 10);
                                hasDifferentBlockStates = blockStatesCompound.m_128425_("data", 12) && paletteList.size() > 1;
                                boolean shouldReadPalette = true;
                                if (hasDifferentBlockStates) {
                                    long[] blockStatesArray = blockStatesCompound.m_128467_("data");
                                    int bits = blockStatesArray.length * 64 / 4096;
                                    int bitsOther = Math.max(4, Mth.m_14163_((int)paletteList.size()));
                                    if (bitsOther > 8) {
                                        bits = bitsOther;
                                    }
                                    if (this.blockStatesBitArray == null || this.blockStatesBitArray.m_144604_() != bits) {
                                        this.blockStatesBitArray = new SimpleBitStorage(bits, 4096);
                                    }
                                    if (blockStatesArray.length == this.blockStatesBitArray.m_13513_().length) {
                                        System.arraycopy(blockStatesArray, 0, this.blockStatesBitArray.m_13513_(), 0, blockStatesArray.length);
                                    } else {
                                        hasDifferentBlockStates = false;
                                        shouldReadPalette = false;
                                    }
                                }
                                this.blockStatePalette.clear();
                                if (shouldReadPalette) {
                                    paletteList.forEach(stateTag -> {
                                        BlockState state = NbtUtils.m_129241_((CompoundTag)((CompoundTag)stateTag));
                                        this.blockStatePalette.add(state);
                                    });
                                }
                            }
                            if ((hasBlocks || i == 0) && sectionCompound.m_128425_("biomes", 10) && (biomesCompound = sectionCompound.m_128469_("biomes")).m_128425_("palette", 9)) {
                                biomePaletteList = biomesCompound.m_128437_("palette", 8);
                                boolean bl3 = hasDifferentBiomes = biomesCompound.m_128425_("data", 12) && biomePaletteList.size() > 1;
                                if (hasDifferentBiomes) {
                                    long[] biomesLongArray = biomesCompound.m_128467_("data");
                                    int bits = Mth.m_14163_((int)biomePaletteList.size());
                                    if (this.biomesBitArray == null || this.biomesBitArray.m_144604_() != bits) {
                                        this.biomesBitArray = new SimpleBitStorage(bits, 64);
                                    }
                                    if (biomesLongArray.length == this.biomesBitArray.m_13513_().length) {
                                        System.arraycopy(biomesLongArray, 0, this.biomesBitArray.m_13513_(), 0, biomesLongArray.length);
                                    } else {
                                        biomePaletteList = null;
                                    }
                                }
                            }
                            if (sectionCompound.m_128425_("BlockLight", 7) && (lightMap = sectionCompound.m_128463_("BlockLight")).length != 2048) {
                                lightMap = null;
                            }
                            preparedSectionData = true;
                        }
                        for (int y = localStartHeight; y >= 0; --y) {
                            boolean buildResult;
                            int h = sectionHeight | y;
                            BiomeKey biome = null;
                            int pos = y << 8 | pos_2d;
                            BlockState state = null;
                            if (hasBlocks) {
                                int indexInPalette;
                                int n = indexInPalette = hasDifferentBlockStates ? this.blockStatesBitArray.m_13514_(pos) : 0;
                                if (indexInPalette < this.blockStatePalette.size()) {
                                    state = this.blockStatePalette.get(indexInPalette);
                                }
                            }
                            if (state == null) {
                                state = Blocks.f_50016_.m_49966_();
                            }
                            if (biomePaletteList != null) {
                                int biomeIndexInPalette;
                                int n = biomeIndexInPalette = hasDifferentBiomes ? this.biomesBitArray.m_13514_(x >> 2 | z >> 2 << 2 | y >> 2 << 4) : 0;
                                if (biomeIndexInPalette < biomePaletteList.size()) {
                                    biome = this.biomeKeyManager.get(biomePaletteList.get(biomeIndexInPalette).m_7916_());
                                }
                            }
                            if (biome == null) {
                                biome = this.defaultBiomeKey;
                            }
                            this.mutableBlockPos.m_122178_(chunkX << 4 | x, h, chunkZ << 4 | z);
                            OverlayBuilder overlayBuilder = this.overlayBuilders[pos_2d];
                            byte light = this.lightLevels[pos_2d];
                            if (!shouldExtendTillTheBottom[pos_2d] && !overlayBuilder.isEmpty() && this.firstTransparentStateY[pos_2d] - h >= 5) {
                                shouldExtendTillTheBottom[pos_2d] = true;
                            }
                            if (!(buildResult = this.buildPixel(this.buildingObject, state, x, h, z, pos_2d, light, biome, cave, overlayBuilder, world, this.mutableBlockPos, biomeRegistry, topH, shouldExtendTillTheBottom[pos_2d], flowers)) && y == 0 && i == 0) {
                                h = worldBottomY;
                                state = Blocks.f_50016_.m_49966_();
                                buildResult = true;
                            }
                            if (buildResult) {
                                BiomeKey blockBiome = biome;
                                this.buildingObject.prepareForWriting(worldBottomY);
                                overlayBuilder.finishBuilding(this.buildingObject);
                                if (overlayBuilder.getOverlayBiome() != null) {
                                    blockBiome = overlayBuilder.getOverlayBiome();
                                }
                                boolean glowing = this.mapProcessor.getMapWriter().isGlowing(state);
                                this.buildingObject.write(state, h, topH[pos_2d], blockBiome, light, glowing, cave);
                                MapBlock currentPixel = tile.getBlock(x, z);
                                boolean equalsSlopesExcluded = this.buildingObject.equalsSlopesExcluded(currentPixel);
                                boolean fullyEqual = this.buildingObject.equals(currentPixel, equalsSlopesExcluded);
                                if (!fullyEqual) {
                                    tile.setBlock(x, z, this.buildingObject);
                                    this.buildingObject = currentPixel != null ? currentPixel : new MapBlock();
                                    if (!equalsSlopesExcluded) {
                                        tileChunk.setChanged(true);
                                    }
                                }
                                this.blockFound[pos_2d] = true;
                                --fillCounter;
                                continue block5;
                            }
                            this.lightLevels[pos_2d] = lightMap == null ? (byte)0 : this.nibbleValue(lightMap, pos);
                        }
                    }
                }
            }
        }
        tile.setWrittenOnce(true);
        tile.setLoaded(true);
        tile.setWorldInterpretationVersion(1);
        return true;
    }

    private boolean buildPixel(MapBlock pixel, BlockState state, int x, int h, int z, int pos_2d, byte light, BiomeKey biome, boolean cave, OverlayBuilder overlayBuilder, Level world, BlockPos.MutableBlockPos mutableBlockPos, Registry<Biome> biomeRegistry, int[] topH, boolean shouldExtendTillTheBottom, boolean flowers) {
        Block b;
        FluidState fluidFluidState = state.m_60819_();
        if (!fluidFluidState.m_76178_()) {
            this.underair[pos_2d] = true;
            BlockState fluidState = this.fluidToBlock.apply(fluidFluidState);
            if (this.buildPixelHelp(pixel, fluidState, fluidState.m_60734_(), fluidFluidState, pos_2d, h, cave, light, biome, overlayBuilder, world, biomeRegistry, topH, shouldExtendTillTheBottom, flowers)) {
                return true;
            }
        }
        if ((b = state.m_60734_()) instanceof AirBlock) {
            this.underair[pos_2d] = true;
            return false;
        }
        if (!this.underair[pos_2d] && cave) {
            return false;
        }
        if (b == this.fluidToBlock.apply(fluidFluidState).m_60734_()) {
            return false;
        }
        return this.buildPixelHelp(pixel, state, state.m_60734_(), null, pos_2d, h, cave, light, biome, overlayBuilder, world, biomeRegistry, topH, shouldExtendTillTheBottom, flowers);
    }

    private boolean buildPixelHelp(MapBlock pixel, BlockState state, Block b, FluidState fluidFluidState, int pos_2d, int h, boolean cave, byte light, BiomeKey dataBiome, OverlayBuilder overlayBuilder, Level world, Registry<Biome> biomeRegistry, int[] topH, boolean shouldExtendTillTheBottom, boolean flowers) {
        if (this.mapProcessor.getMapWriter().isInvisible(world, state, b, flowers)) {
            return false;
        }
        if (this.shouldOverlayCached((StateHolder<?, ?>)(fluidFluidState == null ? state : fluidFluidState))) {
            if (h > topH[pos_2d]) {
                topH[pos_2d] = h;
            }
            if (overlayBuilder.isEmpty()) {
                this.firstTransparentStateY[pos_2d] = h;
            }
            if (shouldExtendTillTheBottom) {
                overlayBuilder.getCurrentOverlay().increaseOpacity(overlayBuilder.getCurrentOverlay().getState().m_60739_((BlockGetter)world, (BlockPos)this.mutableBlockPos));
            } else {
                overlayBuilder.build(state, state.m_60739_((BlockGetter)world, (BlockPos)this.mutableBlockPos), light, this.mapProcessor, dataBiome);
            }
            return false;
        }
        if (!this.mapProcessor.getMapWriter().hasVanillaColor(state, world, (BlockPos)this.mutableBlockPos)) {
            return false;
        }
        if (h > topH[pos_2d]) {
            topH[pos_2d] = h;
        }
        return true;
    }

    private boolean shouldOverlayCached(StateHolder<?, ?> state) {
        return this.transparentCache.apply(state);
    }

    private byte nibbleValue(byte[] array, int index) {
        byte b = array[index >> 1];
        if ((index & 1) == 0) {
            return (byte)(b & 0xF);
        }
        return (byte)(b >> 4 & 0xF);
    }
}

